import re
from collections import defaultdict

idds = ('00', '+')
phone_reg = re.compile(r"(\+|00)?\d[\d\-()]{7,12}\d$")
phone_dial = re.compile(r"[+(]?(\d{0,6})")  # any prefix like `+420` or `(089)`, then up to 6 digits (there is no longer prefix)


def phone_regex_match(val):
    val = val.replace(" ", "")
    return bool(phone_reg.match(val))


def phone_country(val, get_prefix=False):
    """
    We are doing our best to identify any phone number country.
    Possible formats:
        420 (country code only)
        +420 (plus sign)
        00420 (IDD prefix)
    (Library phonenumbers did not find ex Puerto Rico at "1787")
    XX get_prefix seems to not be used
    """
    for idd in idds:
        if val.startswith(idd):
            val = val.lstrip(idd)
            break
    m = phone_dial.match(val.strip())  # strip the number to what may be its prefix only
    if m:
        val = m.group(1)

    for i in range(1, len(val) + 1):
        # get the biggest possible prefix,
        # ex: 4 → "42 exists" → skipped
        #     42 → "420 exist" → skipped
        #     420 → "420X does not exist" → taken
        # ex: number +1675, note there is +1 for US/CA and +1670 for an island
        #     1 , skipped, 16 skipped, 167 skipped, 1675 taken
        if i < len(val) and int(val[:i]) in phones_prefixes:
            continue
        for i2 in range(i, 0, -1):
            # ex: 1675 does not exist, roll back to 167, 16, 1 which is US/CA
            prefix = int(val[:i2])
            if prefix not in phones:  # this prefix does not exist, must be shorter
                continue

            if get_prefix:
                return prefix
            return phones[prefix]


def address_country_lowered(val):
    for s in countries:
        if s in val:
            return countries[s]


def address_country(val):
    val = val.lower()
    for s in countries:
        if s in val:
            return countries[s]


phones = {1: ['ca', 'us'], 1340: 'us', 1670: 'Northern Mariana Islands', 1671: 'gu', 1684: 'as', 1787: 'pr', 1939: 'pr', 1242: 'bs',
          1246: 'bb', 1264: 'ai', 1268: 'ag', 1284: 'vg', 1345: 'ky', 1441: 'bm', 1473: 'gd', 1649: 'tc', 1664: 'ms', 1721: 'sx',
          1758: 'lc', 1767: 'dm', 1784: 'vc', 1809: 'dm', 1829: 'dm', 1849: 'dm', 1868: 'tt', 1869: 'kn', 1876: 'jm', 1658: 'jm',
          20: 'eg', 211: 'sd', 212: 'ma', 213: 'dz', 216: 'tn', 218: 'ly', 220: 'gm', 221: 'sn', 222: 'mr', 223: 'ml', 224: 'gn',
          225: 'ci', 226: 'bf', 227: 'ne', 228: 'tg', 229: 'bj', 230: 'mu', 231: 'lr', 232: 'sl', 233: 'gh', 234: 'ne', 235: 'td',
          236: 'cf', 237: 'cm', 238: 'cv', 239: 'st', 240: 'gn', 241: 'ga', 242: 'cg', 243: 'cd', 244: 'ao', 245: 'gn', 246: 'in',
          247: 'sh', 248: 'sc', 249: 'sd', 250: 'rw', 251: 'et', 252: 'ml', 253: 'dj', 254: 'ke', 255: 'tz',
          524: 'Zanzibar, in place of never-implemented +259', 256: 'ug', 257: 'bi', 258: 'mz', 260: 'zm', 261: 'mg', 262: 're',
          2269: 'yt', 2639: 'km', 263: 'zw', 264: 'na', 265: 'mw', 266: 'ls', 267: 'bw', 268: 'sz', 269: 'km', 27: 'za', 290: 'sh',
          2908: 'sh', 291: 'er', 297: 'aw', 298: 'fo', 299: 'gl', 30: 'gr', 31: 'nl', 32: 'be', 33: 'fr', 34: 'es', 350: 'gi',
          351: 'pt', 352: 'lu', 353: 'ie', 354: 'is', 355: 'al', 356: 'mt', 357: 'cy', 358: 'fi', 818: 'Åland Islands', 359: 'bg',
          36: 'hu', 370: 'lt', 371: 'lv', 372: 'ee', 373: 'md', 374: 'am', 447: 'Artsakh (landlines, formerly +7 893)',
          497: 'Artsakh (mobile phones)', 375: 'by', 376: 'ad', 377: 'mc', 378: 'sm', 379: 'it', 380: 'ua', 381: 'rs', 382: 'me',
          383: 'Kosovo', 385: 'hr', 386: 'si', 387: 'ba', 389: 'mk', 39: 'it',
          906698: ' Vatican City (assigned +379 but not in use)', 40: 'om', 41: 'ch', 420: 'cz', 421: 'sk', 423: 'li', 43: 'at',
          44: 'gb', 41481: 'gg', 41534: 'je', 41624: 'im', 45: 'dk', 46: 'se', 47: 'no', 779: 'sj', 48: 'pl', 49: 'de', 500: 'fk',
          501: 'bz', 502: 'gt', 503: 'sv', 504: 'hn', 505: 'ni', 506: 'cr', 507: 'pa', 508: 'pm', 509: 'ht', 51: 'pe', 52: 'mx',
          53: 'cu', 54: 'ar', 55: 'br', 56: 'cl', 57: 'co', 58: 've', 590: 'gp', 591: 'bo', 592: 'gy', 593: 'ec', 594: 'fr',
          595: 'py', 596: 'mq', 597: 'sr', 598: 'uy', 5993: 'bq', 5994: 'bq', 5997: 'bq', 5999: 'cw', 60: 'my', 61: 'au',
          189162: 'cc', 189164: 'cx', 62: 'id', 63: 'ph', 64: 'pn', 65: 'sg', 66: 'th', 670: 'id', 23: 'nf', 673: 'bn', 674: 'nr',
          675: 'gn', 676: 'to', 677: 'sb', 678: 'vu', 679: 'fj', 680: 'pw', 681: 'wf', 682: 'ck', 683: 'nu', 685: 'ws', 686: 'ki',
          687: 'nc', 688: 'tv', 689: 'fr', 690: 'tk', 691: 'fm', 692: 'mh', 7: 'ru', 76: 'kz', 77: 'kz',
          7840: 'Abkhazia - see also +995 44', 7940: 'Abkhazia - see also +995 44', 800: 'International Freephone (UIFN)',
          808: 'reserved for Shared Cost Services', 81: 'jp', 82: 'kr', 84: 'vn', 850: 'kp', 852: 'hk', 853: 'mo', 855: 'kh',
          856: 'la', 86: 'cn', 870: 'Inmarsat "SNAC" service', 875: 'Maritime Mobile service', 876: 'Maritime Mobile service',
          877: 'Maritime Mobile service', 878: 'Universal Personal Telecommunications services',
          879: 'national non-commercial purposes', 880: 'bd', 881: 'Global Mobile Satellite System', 882: 'International Networks',
          883: 'International Networks', 886: 'tw', 888: 'Telecommunications for Disaster Relief by OCHA', 90: 'tr', 90392: 'cy',
          91: 'in', 92: 'pk', 2582: 'Azad Kashmir[3]', 2581: 'Gilgit Baltistan[3]', 93: 'af', 94: 'lk', 95: 'Myanmar', 960: 'mv',
          961: 'lb', 962: 'jo', 963: 'sy', 964: 'iq', 965: 'kw', 966: 'sa', 967: 'ye', 968: 'om', 970: 'ps', 971: 'ae', 972: 'il',
          973: 'bh', 974: 'qa', 975: 'bt', 976: 'mn', 977: 'np',
          979: 'International Premium Rate Service - originally assigned to Abu Dhabi, now covered under 971', 98: 'ir',
          991: 'International Telecommunications Public Correspondence Service trial (ITPCS)', 992: 'tj', 993: 'tm', 994: 'az',
          995: 'ge', 534: 'South Ossetia', 544: 'Abkhazia[4][5] - see also +7 840, 940', 996: 'kg', 998: 'uz'}

phones_prefixes = defaultdict(list)
for k in phones:
    k = str(k)
    for i in range(1, len(k)):
        try:
            phones_prefixes[int(k[:i])].append(int(k[i]))
        except IndexError:
            pass

countries = {"andorra": "ad",
             "united arab emirates": "ae",
             "afghanistan": "af",
             "barbuda": "ag",
             "antigua": "ag",
             "anguilla": "ai",
             "albania": "al",
             "armenia": "am",
             "angola": "ao",
             "antarctica ": "aq",
             "argentine": "ar",
             "argentina": "ar",
             "american samoa": "as",
             "austria": "at",
             "australia": "au",
             "australia ": "au",
             "aruba": "aw",
             "aland": "ax",
             "azerbaijan": "az",
             "herzegovina": "ba",
             "bosnia": "ba",
             "barbados": "bb",
             "bangladesh": "bd",
             "belgium": "be",
             "burkina faso": "bf",
             "bulgaria": "bg",
             "bahrain": "bh",
             "burundi": "bi",
             "benin": "bj",
             "barthelemy": "bl",
             "bermuda": "bm",
             "brunei": "bn",
             "bolivia": "bo",
             "bonaire": "bq",
             "eustatius": "bq",
             "saba": "bq",
             "brazil": "br",
             "bahamas": "bs",
             "bhutan": "bt",
             "bouvet": "bv",
             "botswana": "bw",
             "belarus": "by",
             "belize": "bz",
             "canada": "ca",
             "keeling": "cc",
             "cocos": "cc",
             "democratic republic of the congo": "cd",
             "central african": "cf",
             "congo": "cg",
             "swiss": "ch",
             "switzerland": "ch",
             "côte d'ivoire": "ci",
             "ivory coast": "ci",
             "cook": "ck",
             "chile": "cl",
             "cameroon": "cm",
             "china": "cn",
             "colombia": "co",
             "costa rica": "cr",
             "cuba": "cu",
             "cabo verde": "cv",
             "cabo verde ": "cv",
             "cape verde": "cv",
             "curacao": "cw",
             "curaçao": "cw",
             "christmas island": "cx",
             "cyprus": "cy",
             "czech": "cz",
             "germany": "de",
             "djibouti": "dj",
             "denmark": "dk",
             "dominica": "dm",
             "dominican": "do",
             "algeria": "dz",
             "ecuador": "ec",
             "estonia": "ee",
             "egypt": "eg",
             "sahrawi": "eh",
             "western sahara": "eh",
             "eritrea": "er",
             "spain": "es",
             "ethiopia": "et",
             "finland": "fi",
             "fiji": "fj",
             "falkland": "fk",
             "falkland islands": "fk",
             "micronesia": "fm",
             "faroe": "fo",
             "french": "fr",
             "france": "fr",
             "gabonese": "ga",
             "gabon": "ga",
             "northern ireland": "gb",
             "great britain": "gb",
             "united kingdom": "gb",
             "england": "gb",
             "grenada": "gd",
             "georgia": "ge",
             "guyane": "gf",
             "french guiana": "gf",
             "bailiwick of guernsey": "gg",
             "guernsey": "gg",
             "ghana": "gh",
             "gibraltar": "gi",
             "kalaallit nunaat": "gl",
             "greenland": "gl",
             "gambia": "gm",
             "guinea": "gn",
             "guadeloupe": "gp",
             "equatorial guinea": "gq",
             "hellenic": "gr",
             "greece": "gr",
             "south sandwich": "gs",
             "south georgia": "gs",
             "guatemala": "gt",
             "guam": "gu",
             "guinea-bissau": "gw",
             "guyana": "gy",
             "hong kong": "hk",
             "mcdonald": "hm",
             "heard": "hm",
             "honduras": "hn",
             "croatia": "hr",
             "haiti": "ht",
             "hungary": "hu",
             "indonesia": "id",
             "ireland": "ie",
             "israel": "il",
             "isle of man": "im",
             "india": "in",
             "british indian ocean": "io",
             "iraq": "iq",
             "iran": "ir",
             "iceland": "is",
             "italian": "it",
             "italy": "it",
             "jersey": "je",
             "jamaica": "jm",
             "hashemite": "jo",
             "jordan": "jo",
             "japan": "jp",
             "kenya": "ke",
             "kyrgyz": "kg",
             "cambodia": "kh",
             "kiribati": "ki",
             "comoros": "km",
             "nevis": "kn",
             "saint kitts": "kn",
             "democratic people": "kp",
             "north korea": "kp",
             "korea": "kr",
             "kuwait": "kw",
             "cayman": "ky",
             "kazakhstan": "kz",
             "lao": "la",
             "lebanese": "lb",
             "lebanon": "lb",
             "lucia": "lc",
             "saint lucia": "lc",
             "liechtenstein": "li",
             "sri lanka": "lk",
             "liberia": "lr",
             "lesotho": "ls",
             "lithuania": "lt",
             "luxembourg": "lu",
             "latvia": "lv",
             "libya": "ly",
             "morocco": "ma",
             "monaco": "mc",
             "moldova": "md",
             "montenegro": "me",
             "saint-martin": "mf",
             "saint martin": "mf",
             "madagascar": "mg",
             "marshall islands": "mh",
             "north macedonia": "mk",
             "mali": "ml",
             "myanmar ": "mm",
             "mongolia": "mn",
             "macao": "mo",
             "macau": "mo",
             "norrn mariana islands": "mp",
             "martinique": "mq",
             "mauritania": "mr",
             "montserrat": "ms",
             "malta": "mt",
             "mauritius": "mu",
             "maldives": "mv",
             "malawi": "mw",
             "mexican": "mx",
             "mexico": "mx",
             "malaysia": "my",
             "mozambique": "mz",
             "namibia": "na",
             "new caledonia": "nc",
             "niger": "ne",
             "norfolk island": "nf",
             "federal nigeria": "ng",
             "nigeria": "ng",
             "nicaragua": "ni",
             "netherlands": "nl",
             "norway": "no",
             "nepal": "np",
             "nauru": "nr",
             "niue": "nu",
             "new zealand": "nz",
             "oman": "om",
             "panama": "pa",
             "peru": "pe",
             "french polynesia": "pf",
             "new guinea": "pg",
             "papua": "pg",
             "philippines": "ph",
             "pakistan": "pk",
             "poland": "pl",
             "miquelon": "pm",
             "saint-pierre": "pm",
             "pitcairn": "pn",
             "henderson": "pn",
             "ducie": "pn",
             "oeno": "pn",
             "puerto rico": "pr",
             "palestine": "ps",
             "portuguese": "pt",
             "portugal": "pt",
             "palau": "pw",
             "paraguay": "py",
             "qatar": "qa",
             "reunion": "re",
             "réunion": "re",
             "romania": "ro",
             "serbia": "rs",
             "russia": "ru",
             "rwanda": "rw",
             "saudi arabia": "sa",
             "solomon islands": "sb",
             "seychelles": "sc",
             "sudan": "sd",
             "sweden": "se",
             "singapore": "sg",
             "helena": "sh",
             "ascension": "sh",
             "tristan": "sh",
             "cunha": "sh",
             "slovenia": "si",
             "jan mayen": "sj",
             "svalbard": "sj",
             "slovak": "sk",
             "slovakia": "sk",
             "sierra leone": "sl",
             "san marino": "sm",
             "senegal": "sn",
             "federal somalia": "so",
             "somalia": "so",
             "suriname": "sr",
             "south sudan": "ss",
             "príncipe": "st",
             "sao tome": "st",
             "principe": "st",
             "el salvador": "sv",
             "sint maarten": "sx",
             "syria": "sy",
             "eswatini": "sz",
             "eswatini ": "sz",
             "caicos islands": "tc",
             "turks": "tc",
             "chad": "td",
             "antarctic lands": "tf",
             "french southern": "tf",
             "togolese": "tg",
             "togo": "tg",
             "thailand": "th",
             "tajikistan": "tj",
             "tokelau": "tk",
             "timor-leste": "tl",
             "turkmenistan": "tm",
             "tunisia": "tn",
             "tonga": "to",
             "turkey": "tr",
             "tobago": "tt",
             "trinidad": "tt",
             "tuvalu": "tv",
             "taiwan": "tw",
             "tanzania": "tz",
             "ukraine": "ua",
             "uganda": "ug",
             "baker": "um",
             "howland": "um",
             "jarvis": "um",
             "johnston": "um",
             "kingman": "um",
             "midway": "um",
             "navassa": "um",
             "palmyra": "um",
             "wake": "um",
             "minor outlying islands  ": "um",
             "united states": "us",
             "uruguay": "uy",
             "uzbekistan": "uz",
             "holy see": "va",
             "grenadines": "vc",
             "saint vincent": "vc",
             "venezuela": "ve",
             "british virgin islands": "vg",
             "virgin islands of united states": "vi",
             "viet nam ": "vn",
             "vietnam": "vn",
             "vanuatu": "vu",
             "futuna": "wf",
             "wallis": "wf",
             "samoa": "ws",
             "yemen": "ye",
             "mayotte": "yt",
             "south africa": "za",
             "zambia": "zm",
             "zimbabwe": "zw"}

country_codes = defaultdict(str, {'af': 'Afghanistan',
                                  'ax': 'Åland Islands',
                                  'al': 'Albania',
                                  'dz': 'Algeria',
                                  'as': 'American Samoa',
                                  'ad': 'Andorra',
                                  'ao': 'Angola',
                                  'ai': 'Anguilla',
                                  'aq': 'Antarctica',
                                  'ag': 'Antigua and Barbuda',
                                  'ar': 'Argentina',
                                  'am': 'Armenia',
                                  'aw': 'Aruba',
                                  'au': 'Australia',
                                  'at': 'Austria',
                                  'az': 'Azerbaijan',
                                  'bs': 'Bahamas',
                                  'bh': 'Bahrain',
                                  'bd': 'Bangladesh',
                                  'bb': 'Barbados',
                                  'by': 'Belarus',
                                  'be': 'Belgium',
                                  'bz': 'Belize',
                                  'bj': 'Benin',
                                  'bm': 'Bermuda',
                                  'bt': 'Bhutan',
                                  'bo': 'Bolivia (Plurinational State of)',
                                  'bq': 'Bonaire, Sint Eustatius and Saba',
                                  'ba': 'Bosnia and Herzegovina',
                                  'bw': 'Botswana',
                                  'bv': 'Bouvet Island',
                                  'br': 'Brazil',
                                  'io': 'British Indian Ocean Territory',
                                  'bn': 'Brunei Darussalam',
                                  'bg': 'Bulgaria',
                                  'bf': 'Burkina Faso',
                                  'bi': 'Burundi',
                                  'cv': 'Cabo Verde',
                                  'kh': 'Cambodia',
                                  'cm': 'Cameroon',
                                  'ca': 'Canada',
                                  'ky': 'Cayman Islands',
                                  'cf': 'Central African Republic',
                                  'td': 'Chad',
                                  'cl': 'Chile',
                                  'cn': 'China',
                                  'cx': 'Christmas Island',
                                  'cc': 'Cocos (Keeling) Islands',
                                  'co': 'Colombia',
                                  'km': 'Comoros',
                                  'cg': 'Congo',
                                  'cd': 'Congo, Democratic Republic of the',
                                  'ck': 'Cook Islands',
                                  'cr': 'Costa Rica',
                                  'ci': "Côte d'Ivoire",
                                  'hr': 'Croatia',
                                  'cu': 'Cuba',
                                  'cw': 'Curaçao',
                                  'cy': 'Cyprus',
                                  'cz': 'Czechia',
                                  'dk': 'Denmark',
                                  'dj': 'Djibouti',
                                  'dm': 'Dominica',
                                  'do': 'Dominican Republic',
                                  'ec': 'Ecuador',
                                  'eg': 'Egypt',
                                  'sv': 'El Salvador',
                                  'gq': 'Equatorial Guinea',
                                  'er': 'Eritrea',
                                  'ee': 'Estonia',
                                  'sz': 'Eswatini',
                                  'et': 'Ethiopia',
                                  'fk': 'Falkland Islands (Malvinas)',
                                  'fo': 'Faroe Islands',
                                  'fj': 'Fiji',
                                  'fi': 'Finland',
                                  'fr': 'France',
                                  'gf': 'French Guiana',
                                  'pf': 'French Polynesia',
                                  'tf': 'French Southern Territories',
                                  'ga': 'Gabon',
                                  'gm': 'Gambia',
                                  'ge': 'Georgia',
                                  'de': 'Germany',
                                  'gh': 'Ghana',
                                  'gi': 'Gibraltar',
                                  'gr': 'Greece',
                                  'gl': 'Greenland',
                                  'gd': 'Grenada',
                                  'gp': 'Guadeloupe',
                                  'gu': 'Guam',
                                  'gt': 'Guatemala',
                                  'gg': 'Guernsey',
                                  'gn': 'Guinea',
                                  'gw': 'Guinea-Bissau',
                                  'gy': 'Guyana',
                                  'ht': 'Haiti',
                                  'hm': 'Heard Island and McDonald Islands',
                                  'va': 'Holy See',
                                  'hn': 'Honduras',
                                  'hk': 'Hong Kong',
                                  'hu': 'Hungary',
                                  'is': 'Iceland',
                                  'in': 'India',
                                  'id': 'Indonesia',
                                  'ir': 'Iran (Islamic Republic of)',
                                  'iq': 'Iraq',
                                  'ie': 'Ireland',
                                  'im': 'Isle of Man',
                                  'il': 'Israel',
                                  'it': 'Italy',
                                  'jm': 'Jamaica',
                                  'jp': 'Japan',
                                  'je': 'Jersey',
                                  'jo': 'Jordan',
                                  'kz': 'Kazakhstan',
                                  'ke': 'Kenya',
                                  'ki': 'Kiribati',
                                  'kp': "Korea (Democratic People's Republic of)",
                                  'kr': 'Korea, Republic of',
                                  'kw': 'Kuwait',
                                  'kg': 'Kyrgyzstan',
                                  'la': "Lao People's Democratic Republic",
                                  'lv': 'Latvia',
                                  'lb': 'Lebanon',
                                  'ls': 'Lesotho',
                                  'lr': 'Liberia',
                                  'ly': 'Libya',
                                  'li': 'Liechtenstein',
                                  'lt': 'Lithuania',
                                  'lu': 'Luxembourg',
                                  'mo': 'Macao',
                                  'mg': 'Madagascar',
                                  'mw': 'Malawi',
                                  'my': 'Malaysia',
                                  'mv': 'Maldives',
                                  'ml': 'Mali',
                                  'mt': 'Malta',
                                  'mh': 'Marshall Islands',
                                  'mq': 'Martinique',
                                  'mr': 'Mauritania',
                                  'mu': 'Mauritius',
                                  'yt': 'Mayotte',
                                  'mx': 'Mexico',
                                  'fm': 'Micronesia (Federated States of)',
                                  'md': 'Moldova, Republic of',
                                  'mc': 'Monaco',
                                  'mn': 'Mongolia',
                                  'me': 'Montenegro',
                                  'ms': 'Montserrat',
                                  'ma': 'Morocco',
                                  'mz': 'Mozambique',
                                  'mm': 'Myanmar',
                                  'na': 'Namibia',
                                  'nr': 'Nauru',
                                  'np': 'Nepal',
                                  'nl': 'Netherlands',
                                  'nc': 'New Caledonia',
                                  'nz': 'New Zealand',
                                  'ni': 'Nicaragua',
                                  'ne': 'Niger',
                                  'ng': 'Nigeria',
                                  'nu': 'Niue',
                                  'nf': 'Norfolk Island',
                                  'mk': 'North Macedonia',
                                  'mp': 'Northern Mariana Islands',
                                  'no': 'Norway',
                                  'om': 'Oman',
                                  'pk': 'Pakistan',
                                  'pw': 'Palau',
                                  'ps': 'Palestine, State of',
                                  'pa': 'Panama',
                                  'pg': 'Papua New Guinea',
                                  'py': 'Paraguay',
                                  'pe': 'Peru',
                                  'ph': 'Philippines',
                                  'pn': 'Pitcairn',
                                  'pl': 'Poland',
                                  'pt': 'Portugal',
                                  'pr': 'Puerto Rico',
                                  'qa': 'Qatar',
                                  're': 'Réunion',
                                  'ro': 'Romania',
                                  'ru': 'Russian Federation',
                                  'rw': 'Rwanda',
                                  'bl': 'Saint Barthélemy',
                                  'sh': 'Saint Helena, Ascension and Tristan da Cunha',
                                  'kn': 'Saint Kitts and Nevis',
                                  'lc': 'Saint Lucia',
                                  'mf': 'Saint Martin (French part)',
                                  'pm': 'Saint Pierre and Miquelon',
                                  'vc': 'Saint Vincent and the Grenadines',
                                  'ws': 'Samoa',
                                  'sm': 'San Marino',
                                  'st': 'Sao Tome and Principe',
                                  'sa': 'Saudi Arabia',
                                  'sn': 'Senegal',
                                  'rs': 'Serbia',
                                  'sc': 'Seychelles',
                                  'sl': 'Sierra Leone',
                                  'sg': 'Singapore',
                                  'sx': 'Sint Maarten (Dutch part)',
                                  'sk': 'Slovakia',
                                  'si': 'Slovenia',
                                  'sb': 'Solomon Islands',
                                  'so': 'Somalia',
                                  'za': 'South Africa',
                                  'gs': 'South Georgia and the South Sandwich Islands',
                                  'ss': 'South Sudan',
                                  'es': 'Spain',
                                  'lk': 'Sri Lanka',
                                  'sd': 'Sudan',
                                  'sr': 'Suriname',
                                  'sj': 'Svalbard and Jan Mayen',
                                  'se': 'Sweden',
                                  'ch': 'Switzerland',
                                  'sy': 'Syrian Arab Republic',
                                  'tw': 'Taiwan, Province of China[a]',
                                  'tj': 'Tajikistan',
                                  'tz': 'Tanzania, United Republic of',
                                  'th': 'Thailand',
                                  'tl': 'Timor-Leste',
                                  'tg': 'Togo',
                                  'tk': 'Tokelau',
                                  'to': 'Tonga',
                                  'tt': 'Trinidad and Tobago',
                                  'tn': 'Tunisia',
                                  'tr': 'Turkey',
                                  'tm': 'Turkmenistan',
                                  'tc': 'Turks and Caicos Islands',
                                  'tv': 'Tuvalu',
                                  'ug': 'Uganda',
                                  'ua': 'Ukraine',
                                  'ae': 'United Arab Emirates',
                                  'gb': 'United Kingdom of Great Britain and Northern Ireland',
                                  'us': 'United States of America',
                                  'um': 'United States Minor Outlying Islands',
                                  'uy': 'Uruguay',
                                  'uz': 'Uzbekistan',
                                  'vu': 'Vanuatu',
                                  've': 'Venezuela (Bolivarian Republic of)',
                                  'vn': 'Viet Nam',
                                  'vg': 'Virgin Islands (British)',
                                  'vi': 'Virgin Islands (U.S.)',
                                  'wf': 'Wallis and Futuna',
                                  'eh': 'Western Sahara',
                                  'ye': 'Yemen',
                                  'zm': 'Zambia',
                                  'zw': 'Zimbabwe'})
