# cycl

[![PyPI](https://img.shields.io/pypi/v/cycl)](https://pypi.org/project/cycl/)
[![Downloads](https://static.pepy.tech/badge/cycl)](https://pypi.python.org/pypi/cycl/)
[![PyPI Supported Python Versions](https://img.shields.io/pypi/pyversions/cycl.svg)](https://pypi.python.org/pypi/cycl/)
[![Build Status](https://github.com/tcm5343/cycl/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/tcm5343/cycl/actions)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/charliermarsh/ruff/main/assets/badge/v0.json)](https://github.com/charliermarsh/ruff)
![Checked with mypy](https://img.shields.io/badge/mypy-checked-blue)

cycl is a CLI and Python SDK to help identify cross-stack import/export circular dependencies, for a given AWS account and region. The successor to [circular-dependency-detector](https://github.com/tcm5343/circular-dependency-detector), which was built at the University of Texas at Austin (ECE 382C: Software Testing).

## Documentation

Documentation for using `cycl` may be found [here](https://tcm5343.github.io/cycl/).

## Contributing

`cycl` is being actively developed, instructions will come as it becomes more stable. Run `make` to see the available targets and their descriptions. To run tests using `tox`, you must install `tox` and `pyenv`. A VScode dev container is coming soon.

To run specific tests:

* using tox: `tox -e py39 -- ./tests/utils/cdk_test.py`
* using pytest directly: `make test ARGS=./tests/utils/cdk_test.py`
