# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictFloat, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_10.models.image_format import ImageFormat
from jellyfin.generated.api_10_10.models.image_info import ImageInfo
from jellyfin.generated.api_10_10.models.image_type import ImageType

from jellyfin.generated.api_10_10.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_10.api_response import ApiResponse
from jellyfin.generated.api_10_10.rest import RESTResponseType


class ImageApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_custom_splashscreen(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete a custom splashscreen.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_splashscreen_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_custom_splashscreen_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete a custom splashscreen.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_splashscreen_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_custom_splashscreen_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a custom splashscreen.


        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_splashscreen_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_custom_splashscreen_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/Branding/Splashscreen',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_item_image(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[Optional[StrictInt], Field(description="The image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_item_image_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[Optional[StrictInt], Field(description="The image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_item_image_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[Optional[StrictInt], Field(description="The image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_item_image_serialize(
        self,
        item_id,
        image_type,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/Items/{itemId}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_item_image_by_index(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="The image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index. (required)
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_item_image_by_index_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="The image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index. (required)
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_item_image_by_index_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="The image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: The image index. (required)
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_item_image_by_index_serialize(
        self,
        item_id,
        image_type,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_user_image(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete the user's image.


        :param user_id: User Id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_image_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_user_image_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete the user's image.


        :param user_id: User Id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_image_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_user_image_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete the user's image.


        :param user_id: User Id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_user_image_serialize(
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_user_image_serialize(
        self,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/UserImage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_artist_image(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_artist_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_artist_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_artist_image_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Artists/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_genre_image(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_genre_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_genre_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_genre_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Genres/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_genre_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_genre_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_genre_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_genre_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Genres/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_item_image(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_item_image_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_item_image_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_item_image_serialize(
        self,
        item_id,
        image_type,
        max_width,
        max_height,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/{itemId}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_item_image2(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_item_image2_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_item_image2_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_item_image2_serialize(
        self,
        item_id,
        image_type,
        max_width,
        max_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        image_index,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if max_width is not None:
            _path_params['maxWidth'] = max_width
        if max_height is not None:
            _path_params['maxHeight'] = max_height
        if tag is not None:
            _path_params['tag'] = tag
        if format is not None:
            _path_params['format'] = format.value
        if percent_played is not None:
            _path_params['percentPlayed'] = percent_played
        if unplayed_count is not None:
            _path_params['unplayedCount'] = unplayed_count
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_item_image_by_index(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_item_image_by_index_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_item_image_by_index_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_item_image_by_index_serialize(
        self,
        item_id,
        image_type,
        image_index,
        max_width,
        max_height,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_item_image_infos(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ImageInfo]:
        """Get item image infos.


        :param item_id: Item id. (required)
        :type item_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_infos_serialize(
            item_id=item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImageInfo]",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_item_image_infos_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ImageInfo]]:
        """Get item image infos.


        :param item_id: Item id. (required)
        :type item_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_infos_serialize(
            item_id=item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImageInfo]",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_item_image_infos_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get item image infos.


        :param item_id: Item id. (required)
        :type item_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_item_image_infos_serialize(
            item_id=item_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImageInfo]",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_item_image_infos_serialize(
        self,
        item_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/{itemId}/Images',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_music_genre_image(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_music_genre_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_music_genre_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_music_genre_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/MusicGenres/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_music_genre_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_music_genre_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_music_genre_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_music_genre_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/MusicGenres/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_person_image(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_person_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_person_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_person_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Persons/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_person_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_person_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_person_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_person_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Persons/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_splashscreen(
        self,
        tag: Annotated[Optional[StrictStr], Field(description="Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Apply a foreground layer on top of the image.")] = None,
        quality: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Quality setting, from 0-100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Generates or gets the splashscreen.


        :param tag: Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Blur image.
        :type blur: int
        :param background_color: Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param quality: Quality setting, from 0-100.
        :type quality: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_splashscreen_serialize(
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            quality=quality,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_splashscreen_with_http_info(
        self,
        tag: Annotated[Optional[StrictStr], Field(description="Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Apply a foreground layer on top of the image.")] = None,
        quality: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Quality setting, from 0-100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Generates or gets the splashscreen.


        :param tag: Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Blur image.
        :type blur: int
        :param background_color: Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param quality: Quality setting, from 0-100.
        :type quality: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_splashscreen_serialize(
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            quality=quality,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_splashscreen_without_preload_content(
        self,
        tag: Annotated[Optional[StrictStr], Field(description="Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Apply a foreground layer on top of the image.")] = None,
        quality: Annotated[Optional[Annotated[int, Field(le=100, strict=True, ge=0)]], Field(description="Quality setting, from 0-100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generates or gets the splashscreen.


        :param tag: Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Blur image.
        :type blur: int
        :param background_color: Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param quality: Quality setting, from 0-100.
        :type quality: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_splashscreen_serialize(
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            quality=quality,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_splashscreen_serialize(
        self,
        tag,
        format,
        max_width,
        max_height,
        width,
        height,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        quality,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Branding/Splashscreen',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studio_image(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studio_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studio_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studio_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Studios/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studio_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studio_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studio_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studio_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Studios/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_user_image(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_user_image_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_user_image_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_user_image_serialize(
        self,
        user_id,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/UserImage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_artist_image(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_artist_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_artist_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Artist name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get artist image by name.


        :param name: Artist name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_artist_image_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_artist_image_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Artists/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_genre_image(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_genre_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_genre_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_genre_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Genres/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_genre_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_genre_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_genre_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get genre image by name.


        :param name: Genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_genre_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Genres/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_item_image(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_item_image_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_item_image_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_item_image_serialize(
        self,
        item_id,
        image_type,
        max_width,
        max_height,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Items/{itemId}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_item_image2(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_item_image2_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_item_image2_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        max_width: Annotated[StrictInt, Field(description="The maximum image width to return.")],
        max_height: Annotated[StrictInt, Field(description="The maximum image height to return.")],
        tag: Annotated[StrictStr, Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")],
        format: Annotated[ImageFormat, Field(description="Determines the output format of the image - original,gif,jpg,png.")],
        percent_played: Annotated[Union[StrictFloat, StrictInt], Field(description="Optional. Percent to render for the percent played overlay.")],
        unplayed_count: Annotated[StrictInt, Field(description="Optional. Unplayed count overlay to render.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param max_width: The maximum image width to return. (required)
        :type max_width: int
        :param max_height: The maximum image height to return. (required)
        :type max_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers. (required)
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png. (required)
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay. (required)
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render. (required)
        :type unplayed_count: int
        :param image_index: Image index. (required)
        :type image_index: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image2_serialize(
            item_id=item_id,
            image_type=image_type,
            max_width=max_width,
            max_height=max_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            image_index=image_index,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_item_image2_serialize(
        self,
        item_id,
        image_type,
        max_width,
        max_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        image_index,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if max_width is not None:
            _path_params['maxWidth'] = max_width
        if max_height is not None:
            _path_params['maxHeight'] = max_height
        if tag is not None:
            _path_params['tag'] = tag
        if format is not None:
            _path_params['format'] = format.value
        if percent_played is not None:
            _path_params['percentPlayed'] = percent_played
        if unplayed_count is not None:
            _path_params['unplayedCount'] = unplayed_count
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}/{tag}/{format}/{maxWidth}/{maxHeight}/{percentPlayed}/{unplayedCount}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_item_image_by_index(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_item_image_by_index_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_item_image_by_index_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the item's image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Optional. The MediaBrowser.Model.Drawing.ImageFormat of the returned image.
        :type format: ImageFormat
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            max_width=max_width,
            max_height=max_height,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            tag=tag,
            format=format,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_item_image_by_index_serialize(
        self,
        item_id,
        image_type,
        image_index,
        max_width,
        max_height,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        tag,
        format,
        percent_played,
        unplayed_count,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_music_genre_image(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_music_genre_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_music_genre_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_music_genre_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/MusicGenres/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_music_genre_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_music_genre_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_music_genre_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Music genre name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get music genre image by name.


        :param name: Music genre name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_music_genre_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_music_genre_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/MusicGenres/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_person_image(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_person_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_person_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_person_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Persons/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_person_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_person_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_person_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Person name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get person image by name.


        :param name: Person name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_person_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_person_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Persons/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_studio_image(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_studio_image_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_studio_image_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_serialize(
            name=name,
            image_type=image_type,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_studio_image_serialize(
        self,
        name,
        image_type,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Studios/{name}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_studio_image_by_index(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_studio_image_by_index_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_studio_image_by_index_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Image index.")],
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get studio image by name.


        :param name: Studio name. (required)
        :type name: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Image index. (required)
        :type image_index: int
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_studio_image_by_index_serialize(
            name=name,
            image_type=image_type,
            image_index=image_index,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_studio_image_by_index_serialize(
        self,
        name,
        image_type,
        image_index,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Studios/{name}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_user_image(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_user_image_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_user_image_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Optional. Supply the cache tag from the item object to receive strong caching headers.")] = None,
        format: Annotated[Optional[ImageFormat], Field(description="Determines the output format of the image - original,gif,jpg,png.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="The maximum image width to return.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="The maximum image height to return.")] = None,
        percent_played: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. Percent to render for the percent played overlay.")] = None,
        unplayed_count: Annotated[Optional[StrictInt], Field(description="Optional. Unplayed count overlay to render.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="The fixed image width to return.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="The fixed image height to return.")] = None,
        quality: Annotated[Optional[StrictInt], Field(description="Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.")] = None,
        fill_width: Annotated[Optional[StrictInt], Field(description="Width of box to fill.")] = None,
        fill_height: Annotated[Optional[StrictInt], Field(description="Height of box to fill.")] = None,
        blur: Annotated[Optional[StrictInt], Field(description="Optional. Blur image.")] = None,
        background_color: Annotated[Optional[StrictStr], Field(description="Optional. Apply a background color for transparent images.")] = None,
        foreground_layer: Annotated[Optional[StrictStr], Field(description="Optional. Apply a foreground layer on top of the image.")] = None,
        image_index: Annotated[Optional[StrictInt], Field(description="Image index.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get user profile image.


        :param user_id: User id.
        :type user_id: str
        :param tag: Optional. Supply the cache tag from the item object to receive strong caching headers.
        :type tag: str
        :param format: Determines the output format of the image - original,gif,jpg,png.
        :type format: ImageFormat
        :param max_width: The maximum image width to return.
        :type max_width: int
        :param max_height: The maximum image height to return.
        :type max_height: int
        :param percent_played: Optional. Percent to render for the percent played overlay.
        :type percent_played: float
        :param unplayed_count: Optional. Unplayed count overlay to render.
        :type unplayed_count: int
        :param width: The fixed image width to return.
        :type width: int
        :param height: The fixed image height to return.
        :type height: int
        :param quality: Optional. Quality setting, from 0-100. Defaults to 90 and should suffice in most cases.
        :type quality: int
        :param fill_width: Width of box to fill.
        :type fill_width: int
        :param fill_height: Height of box to fill.
        :type fill_height: int
        :param blur: Optional. Blur image.
        :type blur: int
        :param background_color: Optional. Apply a background color for transparent images.
        :type background_color: str
        :param foreground_layer: Optional. Apply a foreground layer on top of the image.
        :type foreground_layer: str
        :param image_index: Image index.
        :type image_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_user_image_serialize(
            user_id=user_id,
            tag=tag,
            format=format,
            max_width=max_width,
            max_height=max_height,
            percent_played=percent_played,
            unplayed_count=unplayed_count,
            width=width,
            height=height,
            quality=quality,
            fill_width=fill_width,
            fill_height=fill_height,
            blur=blur,
            background_color=background_color,
            foreground_layer=foreground_layer,
            image_index=image_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_user_image_serialize(
        self,
        user_id,
        tag,
        format,
        max_width,
        max_height,
        percent_played,
        unplayed_count,
        width,
        height,
        quality,
        fill_width,
        fill_height,
        blur,
        background_color,
        foreground_layer,
        image_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if format is not None:
            
            _query_params.append(('format', format.value))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if percent_played is not None:
            
            _query_params.append(('percentPlayed', percent_played))
            
        if unplayed_count is not None:
            
            _query_params.append(('unplayedCount', unplayed_count))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if quality is not None:
            
            _query_params.append(('quality', quality))
            
        if fill_width is not None:
            
            _query_params.append(('fillWidth', fill_width))
            
        if fill_height is not None:
            
            _query_params.append(('fillHeight', fill_height))
            
        if blur is not None:
            
            _query_params.append(('blur', blur))
            
        if background_color is not None:
            
            _query_params.append(('backgroundColor', background_color))
            
        if foreground_layer is not None:
            
            _query_params.append(('foregroundLayer', foreground_layer))
            
        if image_index is not None:
            
            _query_params.append(('imageIndex', image_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'image/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/UserImage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_user_image(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Sets the user image.


        :param user_id: User Id.
        :type user_id: str
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_user_image_serialize(
            user_id=user_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_user_image_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Sets the user image.


        :param user_id: User Id.
        :type user_id: str
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_user_image_serialize(
            user_id=user_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_user_image_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="User Id.")] = None,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Sets the user image.


        :param user_id: User Id.
        :type user_id: str
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_user_image_serialize(
            user_id=user_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_user_image_serialize(
        self,
        user_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'image/*'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/UserImage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_item_image(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_item_image_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_item_image_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_serialize(
            item_id=item_id,
            image_type=image_type,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_item_image_serialize(
        self,
        item_id,
        image_type,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'image/*'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/Items/{itemId}/Images/{imageType}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_item_image_by_index(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="(Unused) Image index.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: (Unused) Image index. (required)
        :type image_index: int
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_item_image_by_index_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="(Unused) Image index.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: (Unused) Image index. (required)
        :type image_index: int
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_item_image_by_index_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="(Unused) Image index.")],
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: (Unused) Image index. (required)
        :type image_index: int
        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_item_image_by_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_item_image_by_index_serialize(
        self,
        item_id,
        image_type,
        image_index,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'image/*'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_item_image_index(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Old image index.")],
        new_index: Annotated[StrictInt, Field(description="New image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Updates the index for an item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Old image index. (required)
        :type image_index: int
        :param new_index: New image index. (required)
        :type new_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_item_image_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            new_index=new_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_item_image_index_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Old image index.")],
        new_index: Annotated[StrictInt, Field(description="New image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Updates the index for an item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Old image index. (required)
        :type image_index: int
        :param new_index: New image index. (required)
        :type new_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_item_image_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            new_index=new_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_item_image_index_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="Item id.")],
        image_type: Annotated[ImageType, Field(description="Image type.")],
        image_index: Annotated[StrictInt, Field(description="Old image index.")],
        new_index: Annotated[StrictInt, Field(description="New image index.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Updates the index for an item image.


        :param item_id: Item id. (required)
        :type item_id: str
        :param image_type: Image type. (required)
        :type image_type: ImageType
        :param image_index: Old image index. (required)
        :type image_index: int
        :param new_index: New image index. (required)
        :type new_index: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_item_image_index_serialize(
            item_id=item_id,
            image_type=image_type,
            image_index=image_index,
            new_index=new_index,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_item_image_index_serialize(
        self,
        item_id,
        image_type,
        image_index,
        new_index,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if image_type is not None:
            _path_params['imageType'] = image_type.value
        if image_index is not None:
            _path_params['imageIndex'] = image_index
        # process the query parameters
        if new_index is not None:
            
            _query_params.append(('newIndex', new_index))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/Items/{itemId}/Images/{imageType}/{imageIndex}/Index',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def upload_custom_splashscreen(
        self,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Uploads a custom splashscreen.  The body is expected to the image contents base64 encoded.


        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_custom_splashscreen_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def upload_custom_splashscreen_with_http_info(
        self,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Uploads a custom splashscreen.  The body is expected to the image contents base64 encoded.


        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_custom_splashscreen_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def upload_custom_splashscreen_without_preload_content(
        self,
        body: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Uploads a custom splashscreen.  The body is expected to the image contents base64 encoded.


        :param body:
        :type body: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_custom_splashscreen_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ProblemDetails",
            '401': None,
            '403': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _upload_custom_splashscreen_serialize(
        self,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            # convert to byte array if the input is a file name (str)
            if isinstance(body, str):
                with open(body, "rb") as _fp:
                    _body_params = _fp.read()
            elif isinstance(body, tuple):
                # drop the filename from the tuple
                _body_params = body[1]
            else:
                _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'image/*'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/Branding/Splashscreen',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


