# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import Optional, Tuple, Union
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_10.models.live_stream_response import LiveStreamResponse
from jellyfin.generated.api_10_10.models.open_live_stream_dto import OpenLiveStreamDto
from jellyfin.generated.api_10_10.models.playback_info_dto import PlaybackInfoDto
from jellyfin.generated.api_10_10.models.playback_info_response import PlaybackInfoResponse

from jellyfin.generated.api_10_10.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_10.api_response import ApiResponse
from jellyfin.generated.api_10_10.rest import RESTResponseType


class MediaInfoApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def close_live_stream(
        self,
        live_stream_id: Annotated[StrictStr, Field(description="The livestream id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Closes a media source.


        :param live_stream_id: The livestream id. (required)
        :type live_stream_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._close_live_stream_serialize(
            live_stream_id=live_stream_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def close_live_stream_with_http_info(
        self,
        live_stream_id: Annotated[StrictStr, Field(description="The livestream id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Closes a media source.


        :param live_stream_id: The livestream id. (required)
        :type live_stream_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._close_live_stream_serialize(
            live_stream_id=live_stream_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def close_live_stream_without_preload_content(
        self,
        live_stream_id: Annotated[StrictStr, Field(description="The livestream id.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Closes a media source.


        :param live_stream_id: The livestream id. (required)
        :type live_stream_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._close_live_stream_serialize(
            live_stream_id=live_stream_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _close_live_stream_serialize(
        self,
        live_stream_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/LiveStreams/Close',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_bitrate_test_bytes(
        self,
        size: Annotated[Optional[Annotated[int, Field(le=100000000, strict=True, ge=1)]], Field(description="The bitrate. Defaults to 102400.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Tests the network with a request with the size of the bitrate.


        :param size: The bitrate. Defaults to 102400.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bitrate_test_bytes_serialize(
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_bitrate_test_bytes_with_http_info(
        self,
        size: Annotated[Optional[Annotated[int, Field(le=100000000, strict=True, ge=1)]], Field(description="The bitrate. Defaults to 102400.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Tests the network with a request with the size of the bitrate.


        :param size: The bitrate. Defaults to 102400.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bitrate_test_bytes_serialize(
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_bitrate_test_bytes_without_preload_content(
        self,
        size: Annotated[Optional[Annotated[int, Field(le=100000000, strict=True, ge=1)]], Field(description="The bitrate. Defaults to 102400.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Tests the network with a request with the size of the bitrate.


        :param size: The bitrate. Defaults to 102400.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_bitrate_test_bytes_serialize(
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_bitrate_test_bytes_serialize(
        self,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if size is not None:
            
            _query_params.append(('size', size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/octet-stream'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Playback/BitrateTest',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_playback_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlaybackInfoResponse:
        """Gets live playback media info for an item.


        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_playback_info_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlaybackInfoResponse]:
        """Gets live playback media info for an item.


        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_playback_info_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets live playback media info for an item.


        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_playback_info_serialize(
        self,
        item_id,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/{itemId}/PlaybackInfo',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_posted_playback_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media source id.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The livestream id.")] = None,
        auto_open_live_stream: Annotated[Optional[StrictBool], Field(description="Whether to auto open the livestream.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        enable_transcoding: Annotated[Optional[StrictBool], Field(description="Whether to enable transcoding. Default: true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the video stream. Default: true.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the audio stream. Default: true.")] = None,
        playback_info_dto: Annotated[Optional[PlaybackInfoDto], Field(description="The playback info.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PlaybackInfoResponse:
        """Gets live playback media info for an item.

        For backwards compatibility parameters can be sent via Query or Body, with Query having higher precedence.  Query parameters are obsolete.

        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param media_source_id: The media source id.
        :type media_source_id: str
        :param live_stream_id: The livestream id.
        :type live_stream_id: str
        :param auto_open_live_stream: Whether to auto open the livestream.
        :type auto_open_live_stream: bool
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param enable_transcoding: Whether to enable transcoding. Default: true.
        :type enable_transcoding: bool
        :param allow_video_stream_copy: Whether to allow to copy the video stream. Default: true.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether to allow to copy the audio stream. Default: true.
        :type allow_audio_stream_copy: bool
        :param playback_info_dto: The playback info.
        :type playback_info_dto: PlaybackInfoDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posted_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            media_source_id=media_source_id,
            live_stream_id=live_stream_id,
            auto_open_live_stream=auto_open_live_stream,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            enable_transcoding=enable_transcoding,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            playback_info_dto=playback_info_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_posted_playback_info_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media source id.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The livestream id.")] = None,
        auto_open_live_stream: Annotated[Optional[StrictBool], Field(description="Whether to auto open the livestream.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        enable_transcoding: Annotated[Optional[StrictBool], Field(description="Whether to enable transcoding. Default: true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the video stream. Default: true.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the audio stream. Default: true.")] = None,
        playback_info_dto: Annotated[Optional[PlaybackInfoDto], Field(description="The playback info.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PlaybackInfoResponse]:
        """Gets live playback media info for an item.

        For backwards compatibility parameters can be sent via Query or Body, with Query having higher precedence.  Query parameters are obsolete.

        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param media_source_id: The media source id.
        :type media_source_id: str
        :param live_stream_id: The livestream id.
        :type live_stream_id: str
        :param auto_open_live_stream: Whether to auto open the livestream.
        :type auto_open_live_stream: bool
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param enable_transcoding: Whether to enable transcoding. Default: true.
        :type enable_transcoding: bool
        :param allow_video_stream_copy: Whether to allow to copy the video stream. Default: true.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether to allow to copy the audio stream. Default: true.
        :type allow_audio_stream_copy: bool
        :param playback_info_dto: The playback info.
        :type playback_info_dto: PlaybackInfoDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posted_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            media_source_id=media_source_id,
            live_stream_id=live_stream_id,
            auto_open_live_stream=auto_open_live_stream,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            enable_transcoding=enable_transcoding,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            playback_info_dto=playback_info_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_posted_playback_info_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media source id.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The livestream id.")] = None,
        auto_open_live_stream: Annotated[Optional[StrictBool], Field(description="Whether to auto open the livestream.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        enable_transcoding: Annotated[Optional[StrictBool], Field(description="Whether to enable transcoding. Default: true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the video stream. Default: true.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether to allow to copy the audio stream. Default: true.")] = None,
        playback_info_dto: Annotated[Optional[PlaybackInfoDto], Field(description="The playback info.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets live playback media info for an item.

        For backwards compatibility parameters can be sent via Query or Body, with Query having higher precedence.  Query parameters are obsolete.

        :param item_id: The item id. (required)
        :type item_id: str
        :param user_id: The user id.
        :type user_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param media_source_id: The media source id.
        :type media_source_id: str
        :param live_stream_id: The livestream id.
        :type live_stream_id: str
        :param auto_open_live_stream: Whether to auto open the livestream.
        :type auto_open_live_stream: bool
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param enable_transcoding: Whether to enable transcoding. Default: true.
        :type enable_transcoding: bool
        :param allow_video_stream_copy: Whether to allow to copy the video stream. Default: true.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether to allow to copy the audio stream. Default: true.
        :type allow_audio_stream_copy: bool
        :param playback_info_dto: The playback info.
        :type playback_info_dto: PlaybackInfoDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_posted_playback_info_serialize(
            item_id=item_id,
            user_id=user_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            media_source_id=media_source_id,
            live_stream_id=live_stream_id,
            auto_open_live_stream=auto_open_live_stream,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            enable_transcoding=enable_transcoding,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            playback_info_dto=playback_info_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PlaybackInfoResponse",
            '401': None,
            '403': None,
            '404': "ProblemDetails",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_posted_playback_info_serialize(
        self,
        item_id,
        user_id,
        max_streaming_bitrate,
        start_time_ticks,
        audio_stream_index,
        subtitle_stream_index,
        max_audio_channels,
        media_source_id,
        live_stream_id,
        auto_open_live_stream,
        enable_direct_play,
        enable_direct_stream,
        enable_transcoding,
        allow_video_stream_copy,
        allow_audio_stream_copy,
        playback_info_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if max_streaming_bitrate is not None:
            
            _query_params.append(('maxStreamingBitrate', max_streaming_bitrate))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        if auto_open_live_stream is not None:
            
            _query_params.append(('autoOpenLiveStream', auto_open_live_stream))
            
        if enable_direct_play is not None:
            
            _query_params.append(('enableDirectPlay', enable_direct_play))
            
        if enable_direct_stream is not None:
            
            _query_params.append(('enableDirectStream', enable_direct_stream))
            
        if enable_transcoding is not None:
            
            _query_params.append(('enableTranscoding', enable_transcoding))
            
        if allow_video_stream_copy is not None:
            
            _query_params.append(('allowVideoStreamCopy', allow_video_stream_copy))
            
        if allow_audio_stream_copy is not None:
            
            _query_params.append(('allowAudioStreamCopy', allow_audio_stream_copy))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if playback_info_dto is not None:
            _body_params = playback_info_dto


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/Items/{itemId}/PlaybackInfo',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def open_live_stream(
        self,
        open_token: Annotated[Optional[StrictStr], Field(description="The open token.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        item_id: Annotated[Optional[UUID], Field(description="The item id.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        always_burn_in_subtitle_when_transcoding: Annotated[Optional[StrictBool], Field(description="Always burn-in subtitle when transcoding.")] = None,
        open_live_stream_dto: Annotated[Optional[OpenLiveStreamDto], Field(description="The open live stream dto.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> LiveStreamResponse:
        """Opens a media source.


        :param open_token: The open token.
        :type open_token: str
        :param user_id: The user id.
        :type user_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param item_id: The item id.
        :type item_id: str
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param always_burn_in_subtitle_when_transcoding: Always burn-in subtitle when transcoding.
        :type always_burn_in_subtitle_when_transcoding: bool
        :param open_live_stream_dto: The open live stream dto.
        :type open_live_stream_dto: OpenLiveStreamDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_live_stream_serialize(
            open_token=open_token,
            user_id=user_id,
            play_session_id=play_session_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            item_id=item_id,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            always_burn_in_subtitle_when_transcoding=always_burn_in_subtitle_when_transcoding,
            open_live_stream_dto=open_live_stream_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LiveStreamResponse",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def open_live_stream_with_http_info(
        self,
        open_token: Annotated[Optional[StrictStr], Field(description="The open token.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        item_id: Annotated[Optional[UUID], Field(description="The item id.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        always_burn_in_subtitle_when_transcoding: Annotated[Optional[StrictBool], Field(description="Always burn-in subtitle when transcoding.")] = None,
        open_live_stream_dto: Annotated[Optional[OpenLiveStreamDto], Field(description="The open live stream dto.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[LiveStreamResponse]:
        """Opens a media source.


        :param open_token: The open token.
        :type open_token: str
        :param user_id: The user id.
        :type user_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param item_id: The item id.
        :type item_id: str
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param always_burn_in_subtitle_when_transcoding: Always burn-in subtitle when transcoding.
        :type always_burn_in_subtitle_when_transcoding: bool
        :param open_live_stream_dto: The open live stream dto.
        :type open_live_stream_dto: OpenLiveStreamDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_live_stream_serialize(
            open_token=open_token,
            user_id=user_id,
            play_session_id=play_session_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            item_id=item_id,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            always_burn_in_subtitle_when_transcoding=always_burn_in_subtitle_when_transcoding,
            open_live_stream_dto=open_live_stream_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LiveStreamResponse",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def open_live_stream_without_preload_content(
        self,
        open_token: Annotated[Optional[StrictStr], Field(description="The open token.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="The maximum streaming bitrate.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="The start time in ticks.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="The audio stream index.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="The subtitle stream index.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="The maximum number of audio channels.")] = None,
        item_id: Annotated[Optional[UUID], Field(description="The item id.")] = None,
        enable_direct_play: Annotated[Optional[StrictBool], Field(description="Whether to enable direct play. Default: true.")] = None,
        enable_direct_stream: Annotated[Optional[StrictBool], Field(description="Whether to enable direct stream. Default: true.")] = None,
        always_burn_in_subtitle_when_transcoding: Annotated[Optional[StrictBool], Field(description="Always burn-in subtitle when transcoding.")] = None,
        open_live_stream_dto: Annotated[Optional[OpenLiveStreamDto], Field(description="The open live stream dto.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Opens a media source.


        :param open_token: The open token.
        :type open_token: str
        :param user_id: The user id.
        :type user_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param max_streaming_bitrate: The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param start_time_ticks: The start time in ticks.
        :type start_time_ticks: int
        :param audio_stream_index: The audio stream index.
        :type audio_stream_index: int
        :param subtitle_stream_index: The subtitle stream index.
        :type subtitle_stream_index: int
        :param max_audio_channels: The maximum number of audio channels.
        :type max_audio_channels: int
        :param item_id: The item id.
        :type item_id: str
        :param enable_direct_play: Whether to enable direct play. Default: true.
        :type enable_direct_play: bool
        :param enable_direct_stream: Whether to enable direct stream. Default: true.
        :type enable_direct_stream: bool
        :param always_burn_in_subtitle_when_transcoding: Always burn-in subtitle when transcoding.
        :type always_burn_in_subtitle_when_transcoding: bool
        :param open_live_stream_dto: The open live stream dto.
        :type open_live_stream_dto: OpenLiveStreamDto
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._open_live_stream_serialize(
            open_token=open_token,
            user_id=user_id,
            play_session_id=play_session_id,
            max_streaming_bitrate=max_streaming_bitrate,
            start_time_ticks=start_time_ticks,
            audio_stream_index=audio_stream_index,
            subtitle_stream_index=subtitle_stream_index,
            max_audio_channels=max_audio_channels,
            item_id=item_id,
            enable_direct_play=enable_direct_play,
            enable_direct_stream=enable_direct_stream,
            always_burn_in_subtitle_when_transcoding=always_burn_in_subtitle_when_transcoding,
            open_live_stream_dto=open_live_stream_dto,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "LiveStreamResponse",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _open_live_stream_serialize(
        self,
        open_token,
        user_id,
        play_session_id,
        max_streaming_bitrate,
        start_time_ticks,
        audio_stream_index,
        subtitle_stream_index,
        max_audio_channels,
        item_id,
        enable_direct_play,
        enable_direct_stream,
        always_burn_in_subtitle_when_transcoding,
        open_live_stream_dto,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if open_token is not None:
            
            _query_params.append(('openToken', open_token))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if play_session_id is not None:
            
            _query_params.append(('playSessionId', play_session_id))
            
        if max_streaming_bitrate is not None:
            
            _query_params.append(('maxStreamingBitrate', max_streaming_bitrate))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if item_id is not None:
            
            _query_params.append(('itemId', item_id))
            
        if enable_direct_play is not None:
            
            _query_params.append(('enableDirectPlay', enable_direct_play))
            
        if enable_direct_stream is not None:
            
            _query_params.append(('enableDirectStream', enable_direct_stream))
            
        if always_burn_in_subtitle_when_transcoding is not None:
            
            _query_params.append(('alwaysBurnInSubtitleWhenTranscoding', always_burn_in_subtitle_when_transcoding))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if open_live_stream_dto is not None:
            _body_params = open_live_stream_dto


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/LiveStreams/Open',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


