# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_10.models.media_type import MediaType
from jellyfin.generated.api_10_10.models.search_hint_result import SearchHintResult

from jellyfin.generated.api_10_10.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_10.api_response import ApiResponse
from jellyfin.generated.api_10_10.rest import RESTResponseType


class SearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_search_hints(
        self,
        search_term: Annotated[StrictStr, Field(description="The search term to filter on.")],
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. Supply a user id to search within a user's library or omit to search all.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, only results with the specified item types are returned. This allows multiple, comma delimited.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, results with these item types are filtered out. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="If specified, only results with the specified media types are returned. This allows multiple, comma delimited.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="If specified, only children of the parent are returned.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for sports.")] = None,
        include_people: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include people.")] = None,
        include_media: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include media.")] = None,
        include_genres: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include genres.")] = None,
        include_studios: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include studios.")] = None,
        include_artists: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include artists.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SearchHintResult:
        """Gets the search hint result.


        :param search_term: The search term to filter on. (required)
        :type search_term: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param user_id: Optional. Supply a user id to search within a user's library or omit to search all.
        :type user_id: str
        :param include_item_types: If specified, only results with the specified item types are returned. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param exclude_item_types: If specified, results with these item types are filtered out. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param media_types: If specified, only results with the specified media types are returned. This allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param parent_id: If specified, only children of the parent are returned.
        :type parent_id: str
        :param is_movie: Optional filter for movies.
        :type is_movie: bool
        :param is_series: Optional filter for series.
        :type is_series: bool
        :param is_news: Optional filter for news.
        :type is_news: bool
        :param is_kids: Optional filter for kids.
        :type is_kids: bool
        :param is_sports: Optional filter for sports.
        :type is_sports: bool
        :param include_people: Optional filter whether to include people.
        :type include_people: bool
        :param include_media: Optional filter whether to include media.
        :type include_media: bool
        :param include_genres: Optional filter whether to include genres.
        :type include_genres: bool
        :param include_studios: Optional filter whether to include studios.
        :type include_studios: bool
        :param include_artists: Optional filter whether to include artists.
        :type include_artists: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_hints_serialize(
            search_term=search_term,
            start_index=start_index,
            limit=limit,
            user_id=user_id,
            include_item_types=include_item_types,
            exclude_item_types=exclude_item_types,
            media_types=media_types,
            parent_id=parent_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            include_people=include_people,
            include_media=include_media,
            include_genres=include_genres,
            include_studios=include_studios,
            include_artists=include_artists,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SearchHintResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_search_hints_with_http_info(
        self,
        search_term: Annotated[StrictStr, Field(description="The search term to filter on.")],
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. Supply a user id to search within a user's library or omit to search all.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, only results with the specified item types are returned. This allows multiple, comma delimited.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, results with these item types are filtered out. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="If specified, only results with the specified media types are returned. This allows multiple, comma delimited.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="If specified, only children of the parent are returned.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for sports.")] = None,
        include_people: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include people.")] = None,
        include_media: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include media.")] = None,
        include_genres: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include genres.")] = None,
        include_studios: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include studios.")] = None,
        include_artists: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include artists.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SearchHintResult]:
        """Gets the search hint result.


        :param search_term: The search term to filter on. (required)
        :type search_term: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param user_id: Optional. Supply a user id to search within a user's library or omit to search all.
        :type user_id: str
        :param include_item_types: If specified, only results with the specified item types are returned. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param exclude_item_types: If specified, results with these item types are filtered out. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param media_types: If specified, only results with the specified media types are returned. This allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param parent_id: If specified, only children of the parent are returned.
        :type parent_id: str
        :param is_movie: Optional filter for movies.
        :type is_movie: bool
        :param is_series: Optional filter for series.
        :type is_series: bool
        :param is_news: Optional filter for news.
        :type is_news: bool
        :param is_kids: Optional filter for kids.
        :type is_kids: bool
        :param is_sports: Optional filter for sports.
        :type is_sports: bool
        :param include_people: Optional filter whether to include people.
        :type include_people: bool
        :param include_media: Optional filter whether to include media.
        :type include_media: bool
        :param include_genres: Optional filter whether to include genres.
        :type include_genres: bool
        :param include_studios: Optional filter whether to include studios.
        :type include_studios: bool
        :param include_artists: Optional filter whether to include artists.
        :type include_artists: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_hints_serialize(
            search_term=search_term,
            start_index=start_index,
            limit=limit,
            user_id=user_id,
            include_item_types=include_item_types,
            exclude_item_types=exclude_item_types,
            media_types=media_types,
            parent_id=parent_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            include_people=include_people,
            include_media=include_media,
            include_genres=include_genres,
            include_studios=include_studios,
            include_artists=include_artists,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SearchHintResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_search_hints_without_preload_content(
        self,
        search_term: Annotated[StrictStr, Field(description="The search term to filter on.")],
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. Supply a user id to search within a user's library or omit to search all.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, only results with the specified item types are returned. This allows multiple, comma delimited.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="If specified, results with these item types are filtered out. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="If specified, only results with the specified media types are returned. This allows multiple, comma delimited.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="If specified, only children of the parent are returned.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for sports.")] = None,
        include_people: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include people.")] = None,
        include_media: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include media.")] = None,
        include_genres: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include genres.")] = None,
        include_studios: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include studios.")] = None,
        include_artists: Annotated[Optional[StrictBool], Field(description="Optional filter whether to include artists.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets the search hint result.


        :param search_term: The search term to filter on. (required)
        :type search_term: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param user_id: Optional. Supply a user id to search within a user's library or omit to search all.
        :type user_id: str
        :param include_item_types: If specified, only results with the specified item types are returned. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param exclude_item_types: If specified, results with these item types are filtered out. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param media_types: If specified, only results with the specified media types are returned. This allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param parent_id: If specified, only children of the parent are returned.
        :type parent_id: str
        :param is_movie: Optional filter for movies.
        :type is_movie: bool
        :param is_series: Optional filter for series.
        :type is_series: bool
        :param is_news: Optional filter for news.
        :type is_news: bool
        :param is_kids: Optional filter for kids.
        :type is_kids: bool
        :param is_sports: Optional filter for sports.
        :type is_sports: bool
        :param include_people: Optional filter whether to include people.
        :type include_people: bool
        :param include_media: Optional filter whether to include media.
        :type include_media: bool
        :param include_genres: Optional filter whether to include genres.
        :type include_genres: bool
        :param include_studios: Optional filter whether to include studios.
        :type include_studios: bool
        :param include_artists: Optional filter whether to include artists.
        :type include_artists: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_hints_serialize(
            search_term=search_term,
            start_index=start_index,
            limit=limit,
            user_id=user_id,
            include_item_types=include_item_types,
            exclude_item_types=exclude_item_types,
            media_types=media_types,
            parent_id=parent_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            include_people=include_people,
            include_media=include_media,
            include_genres=include_genres,
            include_studios=include_studios,
            include_artists=include_artists,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SearchHintResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_search_hints_serialize(
        self,
        search_term,
        start_index,
        limit,
        user_id,
        include_item_types,
        exclude_item_types,
        media_types,
        parent_id,
        is_movie,
        is_series,
        is_news,
        is_kids,
        is_sports,
        include_people,
        include_media,
        include_genres,
        include_studios,
        include_artists,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'includeItemTypes': 'multi',
            'excludeItemTypes': 'multi',
            'mediaTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if search_term is not None:
            
            _query_params.append(('searchTerm', search_term))
            
        if include_item_types is not None:
            
            _query_params.append(('includeItemTypes', include_item_types))
            
        if exclude_item_types is not None:
            
            _query_params.append(('excludeItemTypes', exclude_item_types))
            
        if media_types is not None:
            
            _query_params.append(('mediaTypes', media_types))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if is_movie is not None:
            
            _query_params.append(('isMovie', is_movie))
            
        if is_series is not None:
            
            _query_params.append(('isSeries', is_series))
            
        if is_news is not None:
            
            _query_params.append(('isNews', is_news))
            
        if is_kids is not None:
            
            _query_params.append(('isKids', is_kids))
            
        if is_sports is not None:
            
            _query_params.append(('isSports', is_sports))
            
        if include_people is not None:
            
            _query_params.append(('includePeople', include_people))
            
        if include_media is not None:
            
            _query_params.append(('includeMedia', include_media))
            
        if include_genres is not None:
            
            _query_params.append(('includeGenres', include_genres))
            
        if include_studios is not None:
            
            _query_params.append(('includeStudios', include_studios))
            
        if include_artists is not None:
            
            _query_params.append(('includeArtists', include_artists))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Search/Hints',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


