# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_dto import BaseItemDto
from jellyfin.generated.api_10_10.models.base_item_dto_query_result import BaseItemDtoQueryResult
from jellyfin.generated.api_10_10.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_10.models.image_type import ImageType
from jellyfin.generated.api_10_10.models.item_fields import ItemFields

from jellyfin.generated.api_10_10.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_10.api_response import ApiResponse
from jellyfin.generated.api_10_10.rest import RESTResponseType


class StudiosApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_studio(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        user_id: Annotated[Optional[UUID], Field(description="Optional. Filter by user id, and attach user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDto:
        """Gets a studio by name.


        :param name: Studio name. (required)
        :type name: str
        :param user_id: Optional. Filter by user id, and attach user data.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_serialize(
            name=name,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDto",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studio_with_http_info(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        user_id: Annotated[Optional[UUID], Field(description="Optional. Filter by user id, and attach user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDto]:
        """Gets a studio by name.


        :param name: Studio name. (required)
        :type name: str
        :param user_id: Optional. Filter by user id, and attach user data.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_serialize(
            name=name,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDto",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studio_without_preload_content(
        self,
        name: Annotated[StrictStr, Field(description="Studio name.")],
        user_id: Annotated[Optional[UUID], Field(description="Optional. Filter by user id, and attach user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets a studio by name.


        :param name: Studio name. (required)
        :type name: str
        :param user_id: Optional. Filter by user id, and attach user data.
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studio_serialize(
            name=name,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDto",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studio_serialize(
        self,
        name,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if name is not None:
            _path_params['name'] = name
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Studios/{name}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studios(
        self,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Search term.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Total record count.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Gets all studios from a given item, folder, or the entire library.


        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param search_term: Optional. Search term.
        :type search_term: str
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param user_id: User id.
        :type user_id: str
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param enable_total_record_count: Total record count.
        :type enable_total_record_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studios_serialize(
            start_index=start_index,
            limit=limit,
            search_term=search_term,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            include_item_types=include_item_types,
            is_favorite=is_favorite,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            user_id=user_id,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            enable_images=enable_images,
            enable_total_record_count=enable_total_record_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studios_with_http_info(
        self,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Search term.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Total record count.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Gets all studios from a given item, folder, or the entire library.


        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param search_term: Optional. Search term.
        :type search_term: str
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param user_id: User id.
        :type user_id: str
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param enable_total_record_count: Total record count.
        :type enable_total_record_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studios_serialize(
            start_index=start_index,
            limit=limit,
            search_term=search_term,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            include_item_types=include_item_types,
            is_favorite=is_favorite,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            user_id=user_id,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            enable_images=enable_images,
            enable_total_record_count=enable_total_record_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studios_without_preload_content(
        self,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Search term.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="User id.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Total record count.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets all studios from a given item, folder, or the entire library.


        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param search_term: Optional. Search term.
        :type search_term: str
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered out based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param user_id: User id.
        :type user_id: str
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param enable_total_record_count: Total record count.
        :type enable_total_record_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studios_serialize(
            start_index=start_index,
            limit=limit,
            search_term=search_term,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            include_item_types=include_item_types,
            is_favorite=is_favorite,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            user_id=user_id,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            enable_images=enable_images,
            enable_total_record_count=enable_total_record_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studios_serialize(
        self,
        start_index,
        limit,
        search_term,
        parent_id,
        fields,
        exclude_item_types,
        include_item_types,
        is_favorite,
        enable_user_data,
        image_type_limit,
        enable_image_types,
        user_id,
        name_starts_with_or_greater,
        name_starts_with,
        name_less_than,
        enable_images,
        enable_total_record_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields': 'multi',
            'excludeItemTypes': 'multi',
            'includeItemTypes': 'multi',
            'enableImageTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if search_term is not None:
            
            _query_params.append(('searchTerm', search_term))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_item_types is not None:
            
            _query_params.append(('excludeItemTypes', exclude_item_types))
            
        if include_item_types is not None:
            
            _query_params.append(('includeItemTypes', include_item_types))
            
        if is_favorite is not None:
            
            _query_params.append(('isFavorite', is_favorite))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if name_starts_with_or_greater is not None:
            
            _query_params.append(('nameStartsWithOrGreater', name_starts_with_or_greater))
            
        if name_starts_with is not None:
            
            _query_params.append(('nameStartsWith', name_starts_with))
            
        if name_less_than is not None:
            
            _query_params.append(('nameLessThan', name_less_than))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        if enable_total_record_count is not None:
            
            _query_params.append(('enableTotalRecordCount', enable_total_record_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Studios',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


