# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.log_level import LogLevel
from typing import Optional, Set
from typing_extensions import Self

class ActivityLogEntry(BaseModel):
    """
    An activity log entry.
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Gets or sets the identifier.", alias="Id")
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    overview: Optional[StrictStr] = Field(default=None, description="Gets or sets the overview.", alias="Overview")
    short_overview: Optional[StrictStr] = Field(default=None, description="Gets or sets the short overview.", alias="ShortOverview")
    type: Optional[StrictStr] = Field(default=None, description="Gets or sets the type.", alias="Type")
    item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the item identifier.", alias="ItemId")
    var_date: Optional[datetime] = Field(default=None, description="Gets or sets the date.", alias="Date")
    user_id: Optional[UUID] = Field(default=None, description="Gets or sets the user identifier.", alias="UserId")
    user_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the user primary image tag.", alias="UserPrimaryImageTag")
    severity: Optional[LogLevel] = Field(default=None, alias="Severity")
    __properties: ClassVar[List[str]] = ["Id", "Name", "Overview", "ShortOverview", "Type", "ItemId", "Date", "UserId", "UserPrimaryImageTag", "Severity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActivityLogEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if overview (nullable) is None
        # and model_fields_set contains the field
        if self.overview is None and "overview" in self.model_fields_set:
            _dict['Overview'] = None

        # set to None if short_overview (nullable) is None
        # and model_fields_set contains the field
        if self.short_overview is None and "short_overview" in self.model_fields_set:
            _dict['ShortOverview'] = None

        # set to None if item_id (nullable) is None
        # and model_fields_set contains the field
        if self.item_id is None and "item_id" in self.model_fields_set:
            _dict['ItemId'] = None

        # set to None if user_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.user_primary_image_tag is None and "user_primary_image_tag" in self.model_fields_set:
            _dict['UserPrimaryImageTag'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActivityLogEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "Name": obj.get("Name"),
            "Overview": obj.get("Overview"),
            "ShortOverview": obj.get("ShortOverview"),
            "Type": obj.get("Type"),
            "ItemId": obj.get("ItemId"),
            "Date": obj.get("Date"),
            "UserId": obj.get("UserId"),
            "UserPrimaryImageTag": obj.get("UserPrimaryImageTag"),
            "Severity": obj.get("Severity")
        })
        return _obj


