# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.session_info_dto import SessionInfoDto
from jellyfin.generated.api_10_10.models.user_dto import UserDto
from typing import Optional, Set
from typing_extensions import Self

class AuthenticationResult(BaseModel):
    """
    A class representing an authentication result.
    """ # noqa: E501
    user: Optional[UserDto] = Field(default=None, alias="User")
    session_info: Optional[SessionInfoDto] = Field(default=None, alias="SessionInfo")
    access_token: Optional[StrictStr] = Field(default=None, description="Gets or sets the access token.", alias="AccessToken")
    server_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the server id.", alias="ServerId")
    __properties: ClassVar[List[str]] = ["User", "SessionInfo", "AccessToken", "ServerId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthenticationResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['User'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of session_info
        if self.session_info:
            _dict['SessionInfo'] = self.session_info.to_dict()
        # set to None if access_token (nullable) is None
        # and model_fields_set contains the field
        if self.access_token is None and "access_token" in self.model_fields_set:
            _dict['AccessToken'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['ServerId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthenticationResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "User": UserDto.from_dict(obj["User"]) if obj.get("User") is not None else None,
            "SessionInfo": SessionInfoDto.from_dict(obj["SessionInfo"]) if obj.get("SessionInfo") is not None else None,
            "AccessToken": obj.get("AccessToken"),
            "ServerId": obj.get("ServerId")
        })
        return _obj


