# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_dto_image_blur_hashes import BaseItemDtoImageBlurHashes
from jellyfin.generated.api_10_10.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_10.models.base_item_person import BaseItemPerson
from jellyfin.generated.api_10_10.models.channel_type import ChannelType
from jellyfin.generated.api_10_10.models.chapter_info import ChapterInfo
from jellyfin.generated.api_10_10.models.collection_type import CollectionType
from jellyfin.generated.api_10_10.models.day_of_week import DayOfWeek
from jellyfin.generated.api_10_10.models.external_url import ExternalUrl
from jellyfin.generated.api_10_10.models.extra_type import ExtraType
from jellyfin.generated.api_10_10.models.image_orientation import ImageOrientation
from jellyfin.generated.api_10_10.models.iso_type import IsoType
from jellyfin.generated.api_10_10.models.location_type import LocationType
from jellyfin.generated.api_10_10.models.media_source_info import MediaSourceInfo
from jellyfin.generated.api_10_10.models.media_stream import MediaStream
from jellyfin.generated.api_10_10.models.media_type import MediaType
from jellyfin.generated.api_10_10.models.media_url import MediaUrl
from jellyfin.generated.api_10_10.models.metadata_field import MetadataField
from jellyfin.generated.api_10_10.models.name_guid_pair import NameGuidPair
from jellyfin.generated.api_10_10.models.play_access import PlayAccess
from jellyfin.generated.api_10_10.models.program_audio import ProgramAudio
from jellyfin.generated.api_10_10.models.trickplay_info import TrickplayInfo
from jellyfin.generated.api_10_10.models.user_item_data_dto import UserItemDataDto
from jellyfin.generated.api_10_10.models.video3_d_format import Video3DFormat
from jellyfin.generated.api_10_10.models.video_type import VideoType
from typing import Optional, Set
from typing_extensions import Self

class BaseItemDto(BaseModel):
    """
    This is strictly used as a data transfer object from the api layer.  This holds information about a BaseItem in a format that is convenient for the client.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    original_title: Optional[StrictStr] = Field(default=None, alias="OriginalTitle")
    server_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the server identifier.", alias="ServerId")
    id: Optional[UUID] = Field(default=None, description="Gets or sets the id.", alias="Id")
    etag: Optional[StrictStr] = Field(default=None, description="Gets or sets the etag.", alias="Etag")
    source_type: Optional[StrictStr] = Field(default=None, description="Gets or sets the type of the source.", alias="SourceType")
    playlist_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the playlist item identifier.", alias="PlaylistItemId")
    date_created: Optional[datetime] = Field(default=None, description="Gets or sets the date created.", alias="DateCreated")
    date_last_media_added: Optional[datetime] = Field(default=None, alias="DateLastMediaAdded")
    extra_type: Optional[ExtraType] = Field(default=None, alias="ExtraType")
    airs_before_season_number: Optional[StrictInt] = Field(default=None, alias="AirsBeforeSeasonNumber")
    airs_after_season_number: Optional[StrictInt] = Field(default=None, alias="AirsAfterSeasonNumber")
    airs_before_episode_number: Optional[StrictInt] = Field(default=None, alias="AirsBeforeEpisodeNumber")
    can_delete: Optional[StrictBool] = Field(default=None, alias="CanDelete")
    can_download: Optional[StrictBool] = Field(default=None, alias="CanDownload")
    has_lyrics: Optional[StrictBool] = Field(default=None, alias="HasLyrics")
    has_subtitles: Optional[StrictBool] = Field(default=None, alias="HasSubtitles")
    preferred_metadata_language: Optional[StrictStr] = Field(default=None, alias="PreferredMetadataLanguage")
    preferred_metadata_country_code: Optional[StrictStr] = Field(default=None, alias="PreferredMetadataCountryCode")
    container: Optional[StrictStr] = Field(default=None, alias="Container")
    sort_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the sort.", alias="SortName")
    forced_sort_name: Optional[StrictStr] = Field(default=None, alias="ForcedSortName")
    video3_d_format: Optional[Video3DFormat] = Field(default=None, alias="Video3DFormat")
    premiere_date: Optional[datetime] = Field(default=None, description="Gets or sets the premiere date.", alias="PremiereDate")
    external_urls: Optional[List[ExternalUrl]] = Field(default=None, description="Gets or sets the external urls.", alias="ExternalUrls")
    media_sources: Optional[List[MediaSourceInfo]] = Field(default=None, description="Gets or sets the media versions.", alias="MediaSources")
    critic_rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the critic rating.", alias="CriticRating")
    production_locations: Optional[List[StrictStr]] = Field(default=None, alias="ProductionLocations")
    path: Optional[StrictStr] = Field(default=None, description="Gets or sets the path.", alias="Path")
    enable_media_source_display: Optional[StrictBool] = Field(default=None, alias="EnableMediaSourceDisplay")
    official_rating: Optional[StrictStr] = Field(default=None, description="Gets or sets the official rating.", alias="OfficialRating")
    custom_rating: Optional[StrictStr] = Field(default=None, description="Gets or sets the custom rating.", alias="CustomRating")
    channel_id: Optional[UUID] = Field(default=None, description="Gets or sets the channel identifier.", alias="ChannelId")
    channel_name: Optional[StrictStr] = Field(default=None, alias="ChannelName")
    overview: Optional[StrictStr] = Field(default=None, description="Gets or sets the overview.", alias="Overview")
    taglines: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the taglines.", alias="Taglines")
    genres: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the genres.", alias="Genres")
    community_rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the community rating.", alias="CommunityRating")
    cumulative_run_time_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the cumulative run time ticks.", alias="CumulativeRunTimeTicks")
    run_time_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the run time ticks.", alias="RunTimeTicks")
    play_access: Optional[PlayAccess] = Field(default=None, alias="PlayAccess")
    aspect_ratio: Optional[StrictStr] = Field(default=None, description="Gets or sets the aspect ratio.", alias="AspectRatio")
    production_year: Optional[StrictInt] = Field(default=None, description="Gets or sets the production year.", alias="ProductionYear")
    is_place_holder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is place holder.", alias="IsPlaceHolder")
    number: Optional[StrictStr] = Field(default=None, description="Gets or sets the number.", alias="Number")
    channel_number: Optional[StrictStr] = Field(default=None, alias="ChannelNumber")
    index_number: Optional[StrictInt] = Field(default=None, description="Gets or sets the index number.", alias="IndexNumber")
    index_number_end: Optional[StrictInt] = Field(default=None, description="Gets or sets the index number end.", alias="IndexNumberEnd")
    parent_index_number: Optional[StrictInt] = Field(default=None, description="Gets or sets the parent index number.", alias="ParentIndexNumber")
    remote_trailers: Optional[List[MediaUrl]] = Field(default=None, description="Gets or sets the trailer urls.", alias="RemoteTrailers")
    provider_ids: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="Gets or sets the provider ids.", alias="ProviderIds")
    is_hd: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is HD.", alias="IsHD")
    is_folder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is folder.", alias="IsFolder")
    parent_id: Optional[UUID] = Field(default=None, description="Gets or sets the parent id.", alias="ParentId")
    type: Optional[BaseItemKind] = Field(default=None, alias="Type")
    people: Optional[List[BaseItemPerson]] = Field(default=None, description="Gets or sets the people.", alias="People")
    studios: Optional[List[NameGuidPair]] = Field(default=None, description="Gets or sets the studios.", alias="Studios")
    genre_items: Optional[List[NameGuidPair]] = Field(default=None, alias="GenreItems")
    parent_logo_item_id: Optional[UUID] = Field(default=None, description="Gets or sets whether the item has a logo, this will hold the Id of the Parent that has one.", alias="ParentLogoItemId")
    parent_backdrop_item_id: Optional[UUID] = Field(default=None, description="Gets or sets whether the item has any backdrops, this will hold the Id of the Parent that has one.", alias="ParentBackdropItemId")
    parent_backdrop_image_tags: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the parent backdrop image tags.", alias="ParentBackdropImageTags")
    local_trailer_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the local trailer count.", alias="LocalTrailerCount")
    user_data: Optional[UserItemDataDto] = Field(default=None, alias="UserData")
    recursive_item_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the recursive item count.", alias="RecursiveItemCount")
    child_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the child count.", alias="ChildCount")
    series_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the series.", alias="SeriesName")
    series_id: Optional[UUID] = Field(default=None, description="Gets or sets the series id.", alias="SeriesId")
    season_id: Optional[UUID] = Field(default=None, description="Gets or sets the season identifier.", alias="SeasonId")
    special_feature_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the special feature count.", alias="SpecialFeatureCount")
    display_preferences_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the display preferences id.", alias="DisplayPreferencesId")
    status: Optional[StrictStr] = Field(default=None, description="Gets or sets the status.", alias="Status")
    air_time: Optional[StrictStr] = Field(default=None, description="Gets or sets the air time.", alias="AirTime")
    air_days: Optional[List[DayOfWeek]] = Field(default=None, description="Gets or sets the air days.", alias="AirDays")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the tags.", alias="Tags")
    primary_image_aspect_ratio: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the primary image aspect ratio, after image enhancements.", alias="PrimaryImageAspectRatio")
    artists: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the artists.", alias="Artists")
    artist_items: Optional[List[NameGuidPair]] = Field(default=None, description="Gets or sets the artist items.", alias="ArtistItems")
    album: Optional[StrictStr] = Field(default=None, description="Gets or sets the album.", alias="Album")
    collection_type: Optional[CollectionType] = Field(default=None, alias="CollectionType")
    display_order: Optional[StrictStr] = Field(default=None, description="Gets or sets the display order.", alias="DisplayOrder")
    album_id: Optional[UUID] = Field(default=None, description="Gets or sets the album id.", alias="AlbumId")
    album_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the album image tag.", alias="AlbumPrimaryImageTag")
    series_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the series primary image tag.", alias="SeriesPrimaryImageTag")
    album_artist: Optional[StrictStr] = Field(default=None, description="Gets or sets the album artist.", alias="AlbumArtist")
    album_artists: Optional[List[NameGuidPair]] = Field(default=None, description="Gets or sets the album artists.", alias="AlbumArtists")
    season_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the season.", alias="SeasonName")
    media_streams: Optional[List[MediaStream]] = Field(default=None, description="Gets or sets the media streams.", alias="MediaStreams")
    video_type: Optional[VideoType] = Field(default=None, alias="VideoType")
    part_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the part count.", alias="PartCount")
    media_source_count: Optional[StrictInt] = Field(default=None, alias="MediaSourceCount")
    image_tags: Optional[Dict[str, StrictStr]] = Field(default=None, description="Gets or sets the image tags.", alias="ImageTags")
    backdrop_image_tags: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the backdrop image tags.", alias="BackdropImageTags")
    screenshot_image_tags: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the screenshot image tags.", alias="ScreenshotImageTags")
    parent_logo_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent logo image tag.", alias="ParentLogoImageTag")
    parent_art_item_id: Optional[UUID] = Field(default=None, description="Gets or sets whether the item has fan art, this will hold the Id of the Parent that has one.", alias="ParentArtItemId")
    parent_art_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent art image tag.", alias="ParentArtImageTag")
    series_thumb_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the series thumb image tag.", alias="SeriesThumbImageTag")
    image_blur_hashes: Optional[BaseItemDtoImageBlurHashes] = Field(default=None, alias="ImageBlurHashes")
    series_studio: Optional[StrictStr] = Field(default=None, description="Gets or sets the series studio.", alias="SeriesStudio")
    parent_thumb_item_id: Optional[UUID] = Field(default=None, description="Gets or sets the parent thumb item id.", alias="ParentThumbItemId")
    parent_thumb_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent thumb image tag.", alias="ParentThumbImageTag")
    parent_primary_image_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent primary image item identifier.", alias="ParentPrimaryImageItemId")
    parent_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent primary image tag.", alias="ParentPrimaryImageTag")
    chapters: Optional[List[ChapterInfo]] = Field(default=None, description="Gets or sets the chapters.", alias="Chapters")
    trickplay: Optional[Dict[str, Dict[str, TrickplayInfo]]] = Field(default=None, description="Gets or sets the trickplay manifest.", alias="Trickplay")
    location_type: Optional[LocationType] = Field(default=None, alias="LocationType")
    iso_type: Optional[IsoType] = Field(default=None, alias="IsoType")
    media_type: Optional[MediaType] = Field(default=None, alias="MediaType")
    end_date: Optional[datetime] = Field(default=None, description="Gets or sets the end date.", alias="EndDate")
    locked_fields: Optional[List[MetadataField]] = Field(default=None, description="Gets or sets the locked fields.", alias="LockedFields")
    trailer_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the trailer count.", alias="TrailerCount")
    movie_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the movie count.", alias="MovieCount")
    series_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the series count.", alias="SeriesCount")
    program_count: Optional[StrictInt] = Field(default=None, alias="ProgramCount")
    episode_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the episode count.", alias="EpisodeCount")
    song_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the song count.", alias="SongCount")
    album_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the album count.", alias="AlbumCount")
    artist_count: Optional[StrictInt] = Field(default=None, alias="ArtistCount")
    music_video_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the music video count.", alias="MusicVideoCount")
    lock_data: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [enable internet providers].", alias="LockData")
    width: Optional[StrictInt] = Field(default=None, alias="Width")
    height: Optional[StrictInt] = Field(default=None, alias="Height")
    camera_make: Optional[StrictStr] = Field(default=None, alias="CameraMake")
    camera_model: Optional[StrictStr] = Field(default=None, alias="CameraModel")
    software: Optional[StrictStr] = Field(default=None, alias="Software")
    exposure_time: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ExposureTime")
    focal_length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="FocalLength")
    image_orientation: Optional[ImageOrientation] = Field(default=None, alias="ImageOrientation")
    aperture: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Aperture")
    shutter_speed: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="ShutterSpeed")
    latitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Latitude")
    longitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Longitude")
    altitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="Altitude")
    iso_speed_rating: Optional[StrictInt] = Field(default=None, alias="IsoSpeedRating")
    series_timer_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the series timer identifier.", alias="SeriesTimerId")
    program_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the program identifier.", alias="ProgramId")
    channel_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the channel primary image tag.", alias="ChannelPrimaryImageTag")
    start_date: Optional[datetime] = Field(default=None, description="Gets or sets the start date of the recording, in UTC.", alias="StartDate")
    completion_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the completion percentage.", alias="CompletionPercentage")
    is_repeat: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is repeat.", alias="IsRepeat")
    episode_title: Optional[StrictStr] = Field(default=None, description="Gets or sets the episode title.", alias="EpisodeTitle")
    channel_type: Optional[ChannelType] = Field(default=None, alias="ChannelType")
    audio: Optional[ProgramAudio] = Field(default=None, alias="Audio")
    is_movie: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is movie.", alias="IsMovie")
    is_sports: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is sports.", alias="IsSports")
    is_series: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is series.", alias="IsSeries")
    is_live: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is live.", alias="IsLive")
    is_news: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is news.", alias="IsNews")
    is_kids: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is kids.", alias="IsKids")
    is_premiere: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is premiere.", alias="IsPremiere")
    timer_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the timer identifier.", alias="TimerId")
    normalization_gain: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the gain required for audio normalization.", alias="NormalizationGain")
    current_program: Optional[BaseItemDto] = Field(default=None, alias="CurrentProgram")
    __properties: ClassVar[List[str]] = ["Name", "OriginalTitle", "ServerId", "Id", "Etag", "SourceType", "PlaylistItemId", "DateCreated", "DateLastMediaAdded", "ExtraType", "AirsBeforeSeasonNumber", "AirsAfterSeasonNumber", "AirsBeforeEpisodeNumber", "CanDelete", "CanDownload", "HasLyrics", "HasSubtitles", "PreferredMetadataLanguage", "PreferredMetadataCountryCode", "Container", "SortName", "ForcedSortName", "Video3DFormat", "PremiereDate", "ExternalUrls", "MediaSources", "CriticRating", "ProductionLocations", "Path", "EnableMediaSourceDisplay", "OfficialRating", "CustomRating", "ChannelId", "ChannelName", "Overview", "Taglines", "Genres", "CommunityRating", "CumulativeRunTimeTicks", "RunTimeTicks", "PlayAccess", "AspectRatio", "ProductionYear", "IsPlaceHolder", "Number", "ChannelNumber", "IndexNumber", "IndexNumberEnd", "ParentIndexNumber", "RemoteTrailers", "ProviderIds", "IsHD", "IsFolder", "ParentId", "Type", "People", "Studios", "GenreItems", "ParentLogoItemId", "ParentBackdropItemId", "ParentBackdropImageTags", "LocalTrailerCount", "UserData", "RecursiveItemCount", "ChildCount", "SeriesName", "SeriesId", "SeasonId", "SpecialFeatureCount", "DisplayPreferencesId", "Status", "AirTime", "AirDays", "Tags", "PrimaryImageAspectRatio", "Artists", "ArtistItems", "Album", "CollectionType", "DisplayOrder", "AlbumId", "AlbumPrimaryImageTag", "SeriesPrimaryImageTag", "AlbumArtist", "AlbumArtists", "SeasonName", "MediaStreams", "VideoType", "PartCount", "MediaSourceCount", "ImageTags", "BackdropImageTags", "ScreenshotImageTags", "ParentLogoImageTag", "ParentArtItemId", "ParentArtImageTag", "SeriesThumbImageTag", "ImageBlurHashes", "SeriesStudio", "ParentThumbItemId", "ParentThumbImageTag", "ParentPrimaryImageItemId", "ParentPrimaryImageTag", "Chapters", "Trickplay", "LocationType", "IsoType", "MediaType", "EndDate", "LockedFields", "TrailerCount", "MovieCount", "SeriesCount", "ProgramCount", "EpisodeCount", "SongCount", "AlbumCount", "ArtistCount", "MusicVideoCount", "LockData", "Width", "Height", "CameraMake", "CameraModel", "Software", "ExposureTime", "FocalLength", "ImageOrientation", "Aperture", "ShutterSpeed", "Latitude", "Longitude", "Altitude", "IsoSpeedRating", "SeriesTimerId", "ProgramId", "ChannelPrimaryImageTag", "StartDate", "CompletionPercentage", "IsRepeat", "EpisodeTitle", "ChannelType", "Audio", "IsMovie", "IsSports", "IsSeries", "IsLive", "IsNews", "IsKids", "IsPremiere", "TimerId", "NormalizationGain", "CurrentProgram"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseItemDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in external_urls (list)
        _items = []
        if self.external_urls:
            for _item_external_urls in self.external_urls:
                if _item_external_urls:
                    _items.append(_item_external_urls.to_dict())
            _dict['ExternalUrls'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in media_sources (list)
        _items = []
        if self.media_sources:
            for _item_media_sources in self.media_sources:
                if _item_media_sources:
                    _items.append(_item_media_sources.to_dict())
            _dict['MediaSources'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remote_trailers (list)
        _items = []
        if self.remote_trailers:
            for _item_remote_trailers in self.remote_trailers:
                if _item_remote_trailers:
                    _items.append(_item_remote_trailers.to_dict())
            _dict['RemoteTrailers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in people (list)
        _items = []
        if self.people:
            for _item_people in self.people:
                if _item_people:
                    _items.append(_item_people.to_dict())
            _dict['People'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in studios (list)
        _items = []
        if self.studios:
            for _item_studios in self.studios:
                if _item_studios:
                    _items.append(_item_studios.to_dict())
            _dict['Studios'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in genre_items (list)
        _items = []
        if self.genre_items:
            for _item_genre_items in self.genre_items:
                if _item_genre_items:
                    _items.append(_item_genre_items.to_dict())
            _dict['GenreItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of user_data
        if self.user_data:
            _dict['UserData'] = self.user_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in artist_items (list)
        _items = []
        if self.artist_items:
            for _item_artist_items in self.artist_items:
                if _item_artist_items:
                    _items.append(_item_artist_items.to_dict())
            _dict['ArtistItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in album_artists (list)
        _items = []
        if self.album_artists:
            for _item_album_artists in self.album_artists:
                if _item_album_artists:
                    _items.append(_item_album_artists.to_dict())
            _dict['AlbumArtists'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in media_streams (list)
        _items = []
        if self.media_streams:
            for _item_media_streams in self.media_streams:
                if _item_media_streams:
                    _items.append(_item_media_streams.to_dict())
            _dict['MediaStreams'] = _items
        # override the default output from pydantic by calling `to_dict()` of image_blur_hashes
        if self.image_blur_hashes:
            _dict['ImageBlurHashes'] = self.image_blur_hashes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in chapters (list)
        _items = []
        if self.chapters:
            for _item_chapters in self.chapters:
                if _item_chapters:
                    _items.append(_item_chapters.to_dict())
            _dict['Chapters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in trickplay (dict)
        _field_dict = {}
        if self.trickplay:
            for _key_trickplay in self.trickplay:
                if self.trickplay[_key_trickplay]:
                    _field_dict[_key_trickplay] = self.trickplay[_key_trickplay].to_dict()
            _dict['Trickplay'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of current_program
        if self.current_program:
            _dict['CurrentProgram'] = self.current_program.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if original_title (nullable) is None
        # and model_fields_set contains the field
        if self.original_title is None and "original_title" in self.model_fields_set:
            _dict['OriginalTitle'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['ServerId'] = None

        # set to None if etag (nullable) is None
        # and model_fields_set contains the field
        if self.etag is None and "etag" in self.model_fields_set:
            _dict['Etag'] = None

        # set to None if source_type (nullable) is None
        # and model_fields_set contains the field
        if self.source_type is None and "source_type" in self.model_fields_set:
            _dict['SourceType'] = None

        # set to None if playlist_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.playlist_item_id is None and "playlist_item_id" in self.model_fields_set:
            _dict['PlaylistItemId'] = None

        # set to None if date_created (nullable) is None
        # and model_fields_set contains the field
        if self.date_created is None and "date_created" in self.model_fields_set:
            _dict['DateCreated'] = None

        # set to None if date_last_media_added (nullable) is None
        # and model_fields_set contains the field
        if self.date_last_media_added is None and "date_last_media_added" in self.model_fields_set:
            _dict['DateLastMediaAdded'] = None

        # set to None if airs_before_season_number (nullable) is None
        # and model_fields_set contains the field
        if self.airs_before_season_number is None and "airs_before_season_number" in self.model_fields_set:
            _dict['AirsBeforeSeasonNumber'] = None

        # set to None if airs_after_season_number (nullable) is None
        # and model_fields_set contains the field
        if self.airs_after_season_number is None and "airs_after_season_number" in self.model_fields_set:
            _dict['AirsAfterSeasonNumber'] = None

        # set to None if airs_before_episode_number (nullable) is None
        # and model_fields_set contains the field
        if self.airs_before_episode_number is None and "airs_before_episode_number" in self.model_fields_set:
            _dict['AirsBeforeEpisodeNumber'] = None

        # set to None if can_delete (nullable) is None
        # and model_fields_set contains the field
        if self.can_delete is None and "can_delete" in self.model_fields_set:
            _dict['CanDelete'] = None

        # set to None if can_download (nullable) is None
        # and model_fields_set contains the field
        if self.can_download is None and "can_download" in self.model_fields_set:
            _dict['CanDownload'] = None

        # set to None if has_lyrics (nullable) is None
        # and model_fields_set contains the field
        if self.has_lyrics is None and "has_lyrics" in self.model_fields_set:
            _dict['HasLyrics'] = None

        # set to None if has_subtitles (nullable) is None
        # and model_fields_set contains the field
        if self.has_subtitles is None and "has_subtitles" in self.model_fields_set:
            _dict['HasSubtitles'] = None

        # set to None if preferred_metadata_language (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_metadata_language is None and "preferred_metadata_language" in self.model_fields_set:
            _dict['PreferredMetadataLanguage'] = None

        # set to None if preferred_metadata_country_code (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_metadata_country_code is None and "preferred_metadata_country_code" in self.model_fields_set:
            _dict['PreferredMetadataCountryCode'] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict['Container'] = None

        # set to None if sort_name (nullable) is None
        # and model_fields_set contains the field
        if self.sort_name is None and "sort_name" in self.model_fields_set:
            _dict['SortName'] = None

        # set to None if forced_sort_name (nullable) is None
        # and model_fields_set contains the field
        if self.forced_sort_name is None and "forced_sort_name" in self.model_fields_set:
            _dict['ForcedSortName'] = None

        # set to None if premiere_date (nullable) is None
        # and model_fields_set contains the field
        if self.premiere_date is None and "premiere_date" in self.model_fields_set:
            _dict['PremiereDate'] = None

        # set to None if external_urls (nullable) is None
        # and model_fields_set contains the field
        if self.external_urls is None and "external_urls" in self.model_fields_set:
            _dict['ExternalUrls'] = None

        # set to None if media_sources (nullable) is None
        # and model_fields_set contains the field
        if self.media_sources is None and "media_sources" in self.model_fields_set:
            _dict['MediaSources'] = None

        # set to None if critic_rating (nullable) is None
        # and model_fields_set contains the field
        if self.critic_rating is None and "critic_rating" in self.model_fields_set:
            _dict['CriticRating'] = None

        # set to None if production_locations (nullable) is None
        # and model_fields_set contains the field
        if self.production_locations is None and "production_locations" in self.model_fields_set:
            _dict['ProductionLocations'] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['Path'] = None

        # set to None if enable_media_source_display (nullable) is None
        # and model_fields_set contains the field
        if self.enable_media_source_display is None and "enable_media_source_display" in self.model_fields_set:
            _dict['EnableMediaSourceDisplay'] = None

        # set to None if official_rating (nullable) is None
        # and model_fields_set contains the field
        if self.official_rating is None and "official_rating" in self.model_fields_set:
            _dict['OfficialRating'] = None

        # set to None if custom_rating (nullable) is None
        # and model_fields_set contains the field
        if self.custom_rating is None and "custom_rating" in self.model_fields_set:
            _dict['CustomRating'] = None

        # set to None if channel_id (nullable) is None
        # and model_fields_set contains the field
        if self.channel_id is None and "channel_id" in self.model_fields_set:
            _dict['ChannelId'] = None

        # set to None if channel_name (nullable) is None
        # and model_fields_set contains the field
        if self.channel_name is None and "channel_name" in self.model_fields_set:
            _dict['ChannelName'] = None

        # set to None if overview (nullable) is None
        # and model_fields_set contains the field
        if self.overview is None and "overview" in self.model_fields_set:
            _dict['Overview'] = None

        # set to None if taglines (nullable) is None
        # and model_fields_set contains the field
        if self.taglines is None and "taglines" in self.model_fields_set:
            _dict['Taglines'] = None

        # set to None if genres (nullable) is None
        # and model_fields_set contains the field
        if self.genres is None and "genres" in self.model_fields_set:
            _dict['Genres'] = None

        # set to None if community_rating (nullable) is None
        # and model_fields_set contains the field
        if self.community_rating is None and "community_rating" in self.model_fields_set:
            _dict['CommunityRating'] = None

        # set to None if cumulative_run_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.cumulative_run_time_ticks is None and "cumulative_run_time_ticks" in self.model_fields_set:
            _dict['CumulativeRunTimeTicks'] = None

        # set to None if run_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.run_time_ticks is None and "run_time_ticks" in self.model_fields_set:
            _dict['RunTimeTicks'] = None

        # set to None if aspect_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.aspect_ratio is None and "aspect_ratio" in self.model_fields_set:
            _dict['AspectRatio'] = None

        # set to None if production_year (nullable) is None
        # and model_fields_set contains the field
        if self.production_year is None and "production_year" in self.model_fields_set:
            _dict['ProductionYear'] = None

        # set to None if is_place_holder (nullable) is None
        # and model_fields_set contains the field
        if self.is_place_holder is None and "is_place_holder" in self.model_fields_set:
            _dict['IsPlaceHolder'] = None

        # set to None if number (nullable) is None
        # and model_fields_set contains the field
        if self.number is None and "number" in self.model_fields_set:
            _dict['Number'] = None

        # set to None if channel_number (nullable) is None
        # and model_fields_set contains the field
        if self.channel_number is None and "channel_number" in self.model_fields_set:
            _dict['ChannelNumber'] = None

        # set to None if index_number (nullable) is None
        # and model_fields_set contains the field
        if self.index_number is None and "index_number" in self.model_fields_set:
            _dict['IndexNumber'] = None

        # set to None if index_number_end (nullable) is None
        # and model_fields_set contains the field
        if self.index_number_end is None and "index_number_end" in self.model_fields_set:
            _dict['IndexNumberEnd'] = None

        # set to None if parent_index_number (nullable) is None
        # and model_fields_set contains the field
        if self.parent_index_number is None and "parent_index_number" in self.model_fields_set:
            _dict['ParentIndexNumber'] = None

        # set to None if remote_trailers (nullable) is None
        # and model_fields_set contains the field
        if self.remote_trailers is None and "remote_trailers" in self.model_fields_set:
            _dict['RemoteTrailers'] = None

        # set to None if provider_ids (nullable) is None
        # and model_fields_set contains the field
        if self.provider_ids is None and "provider_ids" in self.model_fields_set:
            _dict['ProviderIds'] = None

        # set to None if is_hd (nullable) is None
        # and model_fields_set contains the field
        if self.is_hd is None and "is_hd" in self.model_fields_set:
            _dict['IsHD'] = None

        # set to None if is_folder (nullable) is None
        # and model_fields_set contains the field
        if self.is_folder is None and "is_folder" in self.model_fields_set:
            _dict['IsFolder'] = None

        # set to None if parent_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_id is None and "parent_id" in self.model_fields_set:
            _dict['ParentId'] = None

        # set to None if people (nullable) is None
        # and model_fields_set contains the field
        if self.people is None and "people" in self.model_fields_set:
            _dict['People'] = None

        # set to None if studios (nullable) is None
        # and model_fields_set contains the field
        if self.studios is None and "studios" in self.model_fields_set:
            _dict['Studios'] = None

        # set to None if genre_items (nullable) is None
        # and model_fields_set contains the field
        if self.genre_items is None and "genre_items" in self.model_fields_set:
            _dict['GenreItems'] = None

        # set to None if parent_logo_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_logo_item_id is None and "parent_logo_item_id" in self.model_fields_set:
            _dict['ParentLogoItemId'] = None

        # set to None if parent_backdrop_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_backdrop_item_id is None and "parent_backdrop_item_id" in self.model_fields_set:
            _dict['ParentBackdropItemId'] = None

        # set to None if parent_backdrop_image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.parent_backdrop_image_tags is None and "parent_backdrop_image_tags" in self.model_fields_set:
            _dict['ParentBackdropImageTags'] = None

        # set to None if local_trailer_count (nullable) is None
        # and model_fields_set contains the field
        if self.local_trailer_count is None and "local_trailer_count" in self.model_fields_set:
            _dict['LocalTrailerCount'] = None

        # set to None if recursive_item_count (nullable) is None
        # and model_fields_set contains the field
        if self.recursive_item_count is None and "recursive_item_count" in self.model_fields_set:
            _dict['RecursiveItemCount'] = None

        # set to None if child_count (nullable) is None
        # and model_fields_set contains the field
        if self.child_count is None and "child_count" in self.model_fields_set:
            _dict['ChildCount'] = None

        # set to None if series_name (nullable) is None
        # and model_fields_set contains the field
        if self.series_name is None and "series_name" in self.model_fields_set:
            _dict['SeriesName'] = None

        # set to None if series_id (nullable) is None
        # and model_fields_set contains the field
        if self.series_id is None and "series_id" in self.model_fields_set:
            _dict['SeriesId'] = None

        # set to None if season_id (nullable) is None
        # and model_fields_set contains the field
        if self.season_id is None and "season_id" in self.model_fields_set:
            _dict['SeasonId'] = None

        # set to None if special_feature_count (nullable) is None
        # and model_fields_set contains the field
        if self.special_feature_count is None and "special_feature_count" in self.model_fields_set:
            _dict['SpecialFeatureCount'] = None

        # set to None if display_preferences_id (nullable) is None
        # and model_fields_set contains the field
        if self.display_preferences_id is None and "display_preferences_id" in self.model_fields_set:
            _dict['DisplayPreferencesId'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['Status'] = None

        # set to None if air_time (nullable) is None
        # and model_fields_set contains the field
        if self.air_time is None and "air_time" in self.model_fields_set:
            _dict['AirTime'] = None

        # set to None if air_days (nullable) is None
        # and model_fields_set contains the field
        if self.air_days is None and "air_days" in self.model_fields_set:
            _dict['AirDays'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['Tags'] = None

        # set to None if primary_image_aspect_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.primary_image_aspect_ratio is None and "primary_image_aspect_ratio" in self.model_fields_set:
            _dict['PrimaryImageAspectRatio'] = None

        # set to None if artists (nullable) is None
        # and model_fields_set contains the field
        if self.artists is None and "artists" in self.model_fields_set:
            _dict['Artists'] = None

        # set to None if artist_items (nullable) is None
        # and model_fields_set contains the field
        if self.artist_items is None and "artist_items" in self.model_fields_set:
            _dict['ArtistItems'] = None

        # set to None if album (nullable) is None
        # and model_fields_set contains the field
        if self.album is None and "album" in self.model_fields_set:
            _dict['Album'] = None

        # set to None if display_order (nullable) is None
        # and model_fields_set contains the field
        if self.display_order is None and "display_order" in self.model_fields_set:
            _dict['DisplayOrder'] = None

        # set to None if album_id (nullable) is None
        # and model_fields_set contains the field
        if self.album_id is None and "album_id" in self.model_fields_set:
            _dict['AlbumId'] = None

        # set to None if album_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.album_primary_image_tag is None and "album_primary_image_tag" in self.model_fields_set:
            _dict['AlbumPrimaryImageTag'] = None

        # set to None if series_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.series_primary_image_tag is None and "series_primary_image_tag" in self.model_fields_set:
            _dict['SeriesPrimaryImageTag'] = None

        # set to None if album_artist (nullable) is None
        # and model_fields_set contains the field
        if self.album_artist is None and "album_artist" in self.model_fields_set:
            _dict['AlbumArtist'] = None

        # set to None if album_artists (nullable) is None
        # and model_fields_set contains the field
        if self.album_artists is None and "album_artists" in self.model_fields_set:
            _dict['AlbumArtists'] = None

        # set to None if season_name (nullable) is None
        # and model_fields_set contains the field
        if self.season_name is None and "season_name" in self.model_fields_set:
            _dict['SeasonName'] = None

        # set to None if media_streams (nullable) is None
        # and model_fields_set contains the field
        if self.media_streams is None and "media_streams" in self.model_fields_set:
            _dict['MediaStreams'] = None

        # set to None if part_count (nullable) is None
        # and model_fields_set contains the field
        if self.part_count is None and "part_count" in self.model_fields_set:
            _dict['PartCount'] = None

        # set to None if media_source_count (nullable) is None
        # and model_fields_set contains the field
        if self.media_source_count is None and "media_source_count" in self.model_fields_set:
            _dict['MediaSourceCount'] = None

        # set to None if image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.image_tags is None and "image_tags" in self.model_fields_set:
            _dict['ImageTags'] = None

        # set to None if backdrop_image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.backdrop_image_tags is None and "backdrop_image_tags" in self.model_fields_set:
            _dict['BackdropImageTags'] = None

        # set to None if screenshot_image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.screenshot_image_tags is None and "screenshot_image_tags" in self.model_fields_set:
            _dict['ScreenshotImageTags'] = None

        # set to None if parent_logo_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_logo_image_tag is None and "parent_logo_image_tag" in self.model_fields_set:
            _dict['ParentLogoImageTag'] = None

        # set to None if parent_art_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_art_item_id is None and "parent_art_item_id" in self.model_fields_set:
            _dict['ParentArtItemId'] = None

        # set to None if parent_art_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_art_image_tag is None and "parent_art_image_tag" in self.model_fields_set:
            _dict['ParentArtImageTag'] = None

        # set to None if series_thumb_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.series_thumb_image_tag is None and "series_thumb_image_tag" in self.model_fields_set:
            _dict['SeriesThumbImageTag'] = None

        # set to None if image_blur_hashes (nullable) is None
        # and model_fields_set contains the field
        if self.image_blur_hashes is None and "image_blur_hashes" in self.model_fields_set:
            _dict['ImageBlurHashes'] = None

        # set to None if series_studio (nullable) is None
        # and model_fields_set contains the field
        if self.series_studio is None and "series_studio" in self.model_fields_set:
            _dict['SeriesStudio'] = None

        # set to None if parent_thumb_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_thumb_item_id is None and "parent_thumb_item_id" in self.model_fields_set:
            _dict['ParentThumbItemId'] = None

        # set to None if parent_thumb_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_thumb_image_tag is None and "parent_thumb_image_tag" in self.model_fields_set:
            _dict['ParentThumbImageTag'] = None

        # set to None if parent_primary_image_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_primary_image_item_id is None and "parent_primary_image_item_id" in self.model_fields_set:
            _dict['ParentPrimaryImageItemId'] = None

        # set to None if parent_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_primary_image_tag is None and "parent_primary_image_tag" in self.model_fields_set:
            _dict['ParentPrimaryImageTag'] = None

        # set to None if chapters (nullable) is None
        # and model_fields_set contains the field
        if self.chapters is None and "chapters" in self.model_fields_set:
            _dict['Chapters'] = None

        # set to None if trickplay (nullable) is None
        # and model_fields_set contains the field
        if self.trickplay is None and "trickplay" in self.model_fields_set:
            _dict['Trickplay'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['EndDate'] = None

        # set to None if locked_fields (nullable) is None
        # and model_fields_set contains the field
        if self.locked_fields is None and "locked_fields" in self.model_fields_set:
            _dict['LockedFields'] = None

        # set to None if trailer_count (nullable) is None
        # and model_fields_set contains the field
        if self.trailer_count is None and "trailer_count" in self.model_fields_set:
            _dict['TrailerCount'] = None

        # set to None if movie_count (nullable) is None
        # and model_fields_set contains the field
        if self.movie_count is None and "movie_count" in self.model_fields_set:
            _dict['MovieCount'] = None

        # set to None if series_count (nullable) is None
        # and model_fields_set contains the field
        if self.series_count is None and "series_count" in self.model_fields_set:
            _dict['SeriesCount'] = None

        # set to None if program_count (nullable) is None
        # and model_fields_set contains the field
        if self.program_count is None and "program_count" in self.model_fields_set:
            _dict['ProgramCount'] = None

        # set to None if episode_count (nullable) is None
        # and model_fields_set contains the field
        if self.episode_count is None and "episode_count" in self.model_fields_set:
            _dict['EpisodeCount'] = None

        # set to None if song_count (nullable) is None
        # and model_fields_set contains the field
        if self.song_count is None and "song_count" in self.model_fields_set:
            _dict['SongCount'] = None

        # set to None if album_count (nullable) is None
        # and model_fields_set contains the field
        if self.album_count is None and "album_count" in self.model_fields_set:
            _dict['AlbumCount'] = None

        # set to None if artist_count (nullable) is None
        # and model_fields_set contains the field
        if self.artist_count is None and "artist_count" in self.model_fields_set:
            _dict['ArtistCount'] = None

        # set to None if music_video_count (nullable) is None
        # and model_fields_set contains the field
        if self.music_video_count is None and "music_video_count" in self.model_fields_set:
            _dict['MusicVideoCount'] = None

        # set to None if lock_data (nullable) is None
        # and model_fields_set contains the field
        if self.lock_data is None and "lock_data" in self.model_fields_set:
            _dict['LockData'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['Width'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['Height'] = None

        # set to None if camera_make (nullable) is None
        # and model_fields_set contains the field
        if self.camera_make is None and "camera_make" in self.model_fields_set:
            _dict['CameraMake'] = None

        # set to None if camera_model (nullable) is None
        # and model_fields_set contains the field
        if self.camera_model is None and "camera_model" in self.model_fields_set:
            _dict['CameraModel'] = None

        # set to None if software (nullable) is None
        # and model_fields_set contains the field
        if self.software is None and "software" in self.model_fields_set:
            _dict['Software'] = None

        # set to None if exposure_time (nullable) is None
        # and model_fields_set contains the field
        if self.exposure_time is None and "exposure_time" in self.model_fields_set:
            _dict['ExposureTime'] = None

        # set to None if focal_length (nullable) is None
        # and model_fields_set contains the field
        if self.focal_length is None and "focal_length" in self.model_fields_set:
            _dict['FocalLength'] = None

        # set to None if aperture (nullable) is None
        # and model_fields_set contains the field
        if self.aperture is None and "aperture" in self.model_fields_set:
            _dict['Aperture'] = None

        # set to None if shutter_speed (nullable) is None
        # and model_fields_set contains the field
        if self.shutter_speed is None and "shutter_speed" in self.model_fields_set:
            _dict['ShutterSpeed'] = None

        # set to None if latitude (nullable) is None
        # and model_fields_set contains the field
        if self.latitude is None and "latitude" in self.model_fields_set:
            _dict['Latitude'] = None

        # set to None if longitude (nullable) is None
        # and model_fields_set contains the field
        if self.longitude is None and "longitude" in self.model_fields_set:
            _dict['Longitude'] = None

        # set to None if altitude (nullable) is None
        # and model_fields_set contains the field
        if self.altitude is None and "altitude" in self.model_fields_set:
            _dict['Altitude'] = None

        # set to None if iso_speed_rating (nullable) is None
        # and model_fields_set contains the field
        if self.iso_speed_rating is None and "iso_speed_rating" in self.model_fields_set:
            _dict['IsoSpeedRating'] = None

        # set to None if series_timer_id (nullable) is None
        # and model_fields_set contains the field
        if self.series_timer_id is None and "series_timer_id" in self.model_fields_set:
            _dict['SeriesTimerId'] = None

        # set to None if program_id (nullable) is None
        # and model_fields_set contains the field
        if self.program_id is None and "program_id" in self.model_fields_set:
            _dict['ProgramId'] = None

        # set to None if channel_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.channel_primary_image_tag is None and "channel_primary_image_tag" in self.model_fields_set:
            _dict['ChannelPrimaryImageTag'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['StartDate'] = None

        # set to None if completion_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.completion_percentage is None and "completion_percentage" in self.model_fields_set:
            _dict['CompletionPercentage'] = None

        # set to None if is_repeat (nullable) is None
        # and model_fields_set contains the field
        if self.is_repeat is None and "is_repeat" in self.model_fields_set:
            _dict['IsRepeat'] = None

        # set to None if episode_title (nullable) is None
        # and model_fields_set contains the field
        if self.episode_title is None and "episode_title" in self.model_fields_set:
            _dict['EpisodeTitle'] = None

        # set to None if is_movie (nullable) is None
        # and model_fields_set contains the field
        if self.is_movie is None and "is_movie" in self.model_fields_set:
            _dict['IsMovie'] = None

        # set to None if is_sports (nullable) is None
        # and model_fields_set contains the field
        if self.is_sports is None and "is_sports" in self.model_fields_set:
            _dict['IsSports'] = None

        # set to None if is_series (nullable) is None
        # and model_fields_set contains the field
        if self.is_series is None and "is_series" in self.model_fields_set:
            _dict['IsSeries'] = None

        # set to None if is_live (nullable) is None
        # and model_fields_set contains the field
        if self.is_live is None and "is_live" in self.model_fields_set:
            _dict['IsLive'] = None

        # set to None if is_news (nullable) is None
        # and model_fields_set contains the field
        if self.is_news is None and "is_news" in self.model_fields_set:
            _dict['IsNews'] = None

        # set to None if is_kids (nullable) is None
        # and model_fields_set contains the field
        if self.is_kids is None and "is_kids" in self.model_fields_set:
            _dict['IsKids'] = None

        # set to None if is_premiere (nullable) is None
        # and model_fields_set contains the field
        if self.is_premiere is None and "is_premiere" in self.model_fields_set:
            _dict['IsPremiere'] = None

        # set to None if timer_id (nullable) is None
        # and model_fields_set contains the field
        if self.timer_id is None and "timer_id" in self.model_fields_set:
            _dict['TimerId'] = None

        # set to None if normalization_gain (nullable) is None
        # and model_fields_set contains the field
        if self.normalization_gain is None and "normalization_gain" in self.model_fields_set:
            _dict['NormalizationGain'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseItemDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "OriginalTitle": obj.get("OriginalTitle"),
            "ServerId": obj.get("ServerId"),
            "Id": obj.get("Id"),
            "Etag": obj.get("Etag"),
            "SourceType": obj.get("SourceType"),
            "PlaylistItemId": obj.get("PlaylistItemId"),
            "DateCreated": obj.get("DateCreated"),
            "DateLastMediaAdded": obj.get("DateLastMediaAdded"),
            "ExtraType": obj.get("ExtraType"),
            "AirsBeforeSeasonNumber": obj.get("AirsBeforeSeasonNumber"),
            "AirsAfterSeasonNumber": obj.get("AirsAfterSeasonNumber"),
            "AirsBeforeEpisodeNumber": obj.get("AirsBeforeEpisodeNumber"),
            "CanDelete": obj.get("CanDelete"),
            "CanDownload": obj.get("CanDownload"),
            "HasLyrics": obj.get("HasLyrics"),
            "HasSubtitles": obj.get("HasSubtitles"),
            "PreferredMetadataLanguage": obj.get("PreferredMetadataLanguage"),
            "PreferredMetadataCountryCode": obj.get("PreferredMetadataCountryCode"),
            "Container": obj.get("Container"),
            "SortName": obj.get("SortName"),
            "ForcedSortName": obj.get("ForcedSortName"),
            "Video3DFormat": obj.get("Video3DFormat"),
            "PremiereDate": obj.get("PremiereDate"),
            "ExternalUrls": [ExternalUrl.from_dict(_item) for _item in obj["ExternalUrls"]] if obj.get("ExternalUrls") is not None else None,
            "MediaSources": [MediaSourceInfo.from_dict(_item) for _item in obj["MediaSources"]] if obj.get("MediaSources") is not None else None,
            "CriticRating": obj.get("CriticRating"),
            "ProductionLocations": obj.get("ProductionLocations"),
            "Path": obj.get("Path"),
            "EnableMediaSourceDisplay": obj.get("EnableMediaSourceDisplay"),
            "OfficialRating": obj.get("OfficialRating"),
            "CustomRating": obj.get("CustomRating"),
            "ChannelId": obj.get("ChannelId"),
            "ChannelName": obj.get("ChannelName"),
            "Overview": obj.get("Overview"),
            "Taglines": obj.get("Taglines"),
            "Genres": obj.get("Genres"),
            "CommunityRating": obj.get("CommunityRating"),
            "CumulativeRunTimeTicks": obj.get("CumulativeRunTimeTicks"),
            "RunTimeTicks": obj.get("RunTimeTicks"),
            "PlayAccess": obj.get("PlayAccess"),
            "AspectRatio": obj.get("AspectRatio"),
            "ProductionYear": obj.get("ProductionYear"),
            "IsPlaceHolder": obj.get("IsPlaceHolder"),
            "Number": obj.get("Number"),
            "ChannelNumber": obj.get("ChannelNumber"),
            "IndexNumber": obj.get("IndexNumber"),
            "IndexNumberEnd": obj.get("IndexNumberEnd"),
            "ParentIndexNumber": obj.get("ParentIndexNumber"),
            "RemoteTrailers": [MediaUrl.from_dict(_item) for _item in obj["RemoteTrailers"]] if obj.get("RemoteTrailers") is not None else None,
            "ProviderIds": obj.get("ProviderIds"),
            "IsHD": obj.get("IsHD"),
            "IsFolder": obj.get("IsFolder"),
            "ParentId": obj.get("ParentId"),
            "Type": obj.get("Type"),
            "People": [BaseItemPerson.from_dict(_item) for _item in obj["People"]] if obj.get("People") is not None else None,
            "Studios": [NameGuidPair.from_dict(_item) for _item in obj["Studios"]] if obj.get("Studios") is not None else None,
            "GenreItems": [NameGuidPair.from_dict(_item) for _item in obj["GenreItems"]] if obj.get("GenreItems") is not None else None,
            "ParentLogoItemId": obj.get("ParentLogoItemId"),
            "ParentBackdropItemId": obj.get("ParentBackdropItemId"),
            "ParentBackdropImageTags": obj.get("ParentBackdropImageTags"),
            "LocalTrailerCount": obj.get("LocalTrailerCount"),
            "UserData": UserItemDataDto.from_dict(obj["UserData"]) if obj.get("UserData") is not None else None,
            "RecursiveItemCount": obj.get("RecursiveItemCount"),
            "ChildCount": obj.get("ChildCount"),
            "SeriesName": obj.get("SeriesName"),
            "SeriesId": obj.get("SeriesId"),
            "SeasonId": obj.get("SeasonId"),
            "SpecialFeatureCount": obj.get("SpecialFeatureCount"),
            "DisplayPreferencesId": obj.get("DisplayPreferencesId"),
            "Status": obj.get("Status"),
            "AirTime": obj.get("AirTime"),
            "AirDays": obj.get("AirDays"),
            "Tags": obj.get("Tags"),
            "PrimaryImageAspectRatio": obj.get("PrimaryImageAspectRatio"),
            "Artists": obj.get("Artists"),
            "ArtistItems": [NameGuidPair.from_dict(_item) for _item in obj["ArtistItems"]] if obj.get("ArtistItems") is not None else None,
            "Album": obj.get("Album"),
            "CollectionType": obj.get("CollectionType"),
            "DisplayOrder": obj.get("DisplayOrder"),
            "AlbumId": obj.get("AlbumId"),
            "AlbumPrimaryImageTag": obj.get("AlbumPrimaryImageTag"),
            "SeriesPrimaryImageTag": obj.get("SeriesPrimaryImageTag"),
            "AlbumArtist": obj.get("AlbumArtist"),
            "AlbumArtists": [NameGuidPair.from_dict(_item) for _item in obj["AlbumArtists"]] if obj.get("AlbumArtists") is not None else None,
            "SeasonName": obj.get("SeasonName"),
            "MediaStreams": [MediaStream.from_dict(_item) for _item in obj["MediaStreams"]] if obj.get("MediaStreams") is not None else None,
            "VideoType": obj.get("VideoType"),
            "PartCount": obj.get("PartCount"),
            "MediaSourceCount": obj.get("MediaSourceCount"),
            "ImageTags": obj.get("ImageTags"),
            "BackdropImageTags": obj.get("BackdropImageTags"),
            "ScreenshotImageTags": obj.get("ScreenshotImageTags"),
            "ParentLogoImageTag": obj.get("ParentLogoImageTag"),
            "ParentArtItemId": obj.get("ParentArtItemId"),
            "ParentArtImageTag": obj.get("ParentArtImageTag"),
            "SeriesThumbImageTag": obj.get("SeriesThumbImageTag"),
            "ImageBlurHashes": BaseItemDtoImageBlurHashes.from_dict(obj["ImageBlurHashes"]) if obj.get("ImageBlurHashes") is not None else None,
            "SeriesStudio": obj.get("SeriesStudio"),
            "ParentThumbItemId": obj.get("ParentThumbItemId"),
            "ParentThumbImageTag": obj.get("ParentThumbImageTag"),
            "ParentPrimaryImageItemId": obj.get("ParentPrimaryImageItemId"),
            "ParentPrimaryImageTag": obj.get("ParentPrimaryImageTag"),
            "Chapters": [ChapterInfo.from_dict(_item) for _item in obj["Chapters"]] if obj.get("Chapters") is not None else None,
            "Trickplay": dict(
                (_k, dict(
                    (_ik, TrickplayInfo.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("Trickplay").items()
            )
            if obj.get("Trickplay") is not None
            else None,
            "LocationType": obj.get("LocationType"),
            "IsoType": obj.get("IsoType"),
            "MediaType": obj.get("MediaType"),
            "EndDate": obj.get("EndDate"),
            "LockedFields": obj.get("LockedFields"),
            "TrailerCount": obj.get("TrailerCount"),
            "MovieCount": obj.get("MovieCount"),
            "SeriesCount": obj.get("SeriesCount"),
            "ProgramCount": obj.get("ProgramCount"),
            "EpisodeCount": obj.get("EpisodeCount"),
            "SongCount": obj.get("SongCount"),
            "AlbumCount": obj.get("AlbumCount"),
            "ArtistCount": obj.get("ArtistCount"),
            "MusicVideoCount": obj.get("MusicVideoCount"),
            "LockData": obj.get("LockData"),
            "Width": obj.get("Width"),
            "Height": obj.get("Height"),
            "CameraMake": obj.get("CameraMake"),
            "CameraModel": obj.get("CameraModel"),
            "Software": obj.get("Software"),
            "ExposureTime": obj.get("ExposureTime"),
            "FocalLength": obj.get("FocalLength"),
            "ImageOrientation": obj.get("ImageOrientation"),
            "Aperture": obj.get("Aperture"),
            "ShutterSpeed": obj.get("ShutterSpeed"),
            "Latitude": obj.get("Latitude"),
            "Longitude": obj.get("Longitude"),
            "Altitude": obj.get("Altitude"),
            "IsoSpeedRating": obj.get("IsoSpeedRating"),
            "SeriesTimerId": obj.get("SeriesTimerId"),
            "ProgramId": obj.get("ProgramId"),
            "ChannelPrimaryImageTag": obj.get("ChannelPrimaryImageTag"),
            "StartDate": obj.get("StartDate"),
            "CompletionPercentage": obj.get("CompletionPercentage"),
            "IsRepeat": obj.get("IsRepeat"),
            "EpisodeTitle": obj.get("EpisodeTitle"),
            "ChannelType": obj.get("ChannelType"),
            "Audio": obj.get("Audio"),
            "IsMovie": obj.get("IsMovie"),
            "IsSports": obj.get("IsSports"),
            "IsSeries": obj.get("IsSeries"),
            "IsLive": obj.get("IsLive"),
            "IsNews": obj.get("IsNews"),
            "IsKids": obj.get("IsKids"),
            "IsPremiere": obj.get("IsPremiere"),
            "TimerId": obj.get("TimerId"),
            "NormalizationGain": obj.get("NormalizationGain"),
            "CurrentProgram": BaseItemDto.from_dict(obj["CurrentProgram"]) if obj.get("CurrentProgram") is not None else None
        })
        return _obj

# TODO: Rewrite to not use raise_errors
BaseItemDto.model_rebuild(raise_errors=False)

