# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class ConfigurationPageInfo(BaseModel):
    """
    The configuration page info.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    enable_in_main_menu: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the configurations page is enabled in the main menu.", alias="EnableInMainMenu")
    menu_section: Optional[StrictStr] = Field(default=None, description="Gets or sets the menu section.", alias="MenuSection")
    menu_icon: Optional[StrictStr] = Field(default=None, description="Gets or sets the menu icon.", alias="MenuIcon")
    display_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the display name.", alias="DisplayName")
    plugin_id: Optional[UUID] = Field(default=None, description="Gets or sets the plugin id.", alias="PluginId")
    __properties: ClassVar[List[str]] = ["Name", "EnableInMainMenu", "MenuSection", "MenuIcon", "DisplayName", "PluginId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConfigurationPageInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if menu_section (nullable) is None
        # and model_fields_set contains the field
        if self.menu_section is None and "menu_section" in self.model_fields_set:
            _dict['MenuSection'] = None

        # set to None if menu_icon (nullable) is None
        # and model_fields_set contains the field
        if self.menu_icon is None and "menu_icon" in self.model_fields_set:
            _dict['MenuIcon'] = None

        # set to None if display_name (nullable) is None
        # and model_fields_set contains the field
        if self.display_name is None and "display_name" in self.model_fields_set:
            _dict['DisplayName'] = None

        # set to None if plugin_id (nullable) is None
        # and model_fields_set contains the field
        if self.plugin_id is None and "plugin_id" in self.model_fields_set:
            _dict['PluginId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConfigurationPageInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "EnableInMainMenu": obj.get("EnableInMainMenu"),
            "MenuSection": obj.get("MenuSection"),
            "MenuIcon": obj.get("MenuIcon"),
            "DisplayName": obj.get("DisplayName"),
            "PluginId": obj.get("PluginId")
        })
        return _obj


