# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.client_capabilities_dto import ClientCapabilitiesDto
from typing import Optional, Set
from typing_extensions import Self

class DeviceInfoDto(BaseModel):
    """
    A DTO representing device information.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    custom_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the custom name.", alias="CustomName")
    access_token: Optional[StrictStr] = Field(default=None, description="Gets or sets the access token.", alias="AccessToken")
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the identifier.", alias="Id")
    last_user_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the last name of the user.", alias="LastUserName")
    app_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the application.", alias="AppName")
    app_version: Optional[StrictStr] = Field(default=None, description="Gets or sets the application version.", alias="AppVersion")
    last_user_id: Optional[UUID] = Field(default=None, description="Gets or sets the last user identifier.", alias="LastUserId")
    date_last_activity: Optional[datetime] = Field(default=None, description="Gets or sets the date last modified.", alias="DateLastActivity")
    capabilities: Optional[ClientCapabilitiesDto] = Field(default=None, alias="Capabilities")
    icon_url: Optional[StrictStr] = Field(default=None, description="Gets or sets the icon URL.", alias="IconUrl")
    __properties: ClassVar[List[str]] = ["Name", "CustomName", "AccessToken", "Id", "LastUserName", "AppName", "AppVersion", "LastUserId", "DateLastActivity", "Capabilities", "IconUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceInfoDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of capabilities
        if self.capabilities:
            _dict['Capabilities'] = self.capabilities.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if custom_name (nullable) is None
        # and model_fields_set contains the field
        if self.custom_name is None and "custom_name" in self.model_fields_set:
            _dict['CustomName'] = None

        # set to None if access_token (nullable) is None
        # and model_fields_set contains the field
        if self.access_token is None and "access_token" in self.model_fields_set:
            _dict['AccessToken'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if last_user_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_user_name is None and "last_user_name" in self.model_fields_set:
            _dict['LastUserName'] = None

        # set to None if app_name (nullable) is None
        # and model_fields_set contains the field
        if self.app_name is None and "app_name" in self.model_fields_set:
            _dict['AppName'] = None

        # set to None if app_version (nullable) is None
        # and model_fields_set contains the field
        if self.app_version is None and "app_version" in self.model_fields_set:
            _dict['AppVersion'] = None

        # set to None if last_user_id (nullable) is None
        # and model_fields_set contains the field
        if self.last_user_id is None and "last_user_id" in self.model_fields_set:
            _dict['LastUserId'] = None

        # set to None if date_last_activity (nullable) is None
        # and model_fields_set contains the field
        if self.date_last_activity is None and "date_last_activity" in self.model_fields_set:
            _dict['DateLastActivity'] = None

        # set to None if icon_url (nullable) is None
        # and model_fields_set contains the field
        if self.icon_url is None and "icon_url" in self.model_fields_set:
            _dict['IconUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceInfoDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "CustomName": obj.get("CustomName"),
            "AccessToken": obj.get("AccessToken"),
            "Id": obj.get("Id"),
            "LastUserName": obj.get("LastUserName"),
            "AppName": obj.get("AppName"),
            "AppVersion": obj.get("AppVersion"),
            "LastUserId": obj.get("LastUserId"),
            "DateLastActivity": obj.get("DateLastActivity"),
            "Capabilities": ClientCapabilitiesDto.from_dict(obj["Capabilities"]) if obj.get("Capabilities") is not None else None,
            "IconUrl": obj.get("IconUrl")
        })
        return _obj


