# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.codec_profile import CodecProfile
from jellyfin.generated.api_10_10.models.container_profile import ContainerProfile
from jellyfin.generated.api_10_10.models.direct_play_profile import DirectPlayProfile
from jellyfin.generated.api_10_10.models.subtitle_profile import SubtitleProfile
from jellyfin.generated.api_10_10.models.transcoding_profile import TranscodingProfile
from typing import Optional, Set
from typing_extensions import Self

class DeviceProfile(BaseModel):
    """
    A MediaBrowser.Model.Dlna.DeviceProfile represents a set of metadata which determines which content a certain device is able to play.  <br />  Specifically, it defines the supported <see cref=\"P:MediaBrowser.Model.Dlna.DeviceProfile.ContainerProfiles\">containers</see> and  <see cref=\"P:MediaBrowser.Model.Dlna.DeviceProfile.CodecProfiles\">codecs</see> (video and/or audio, including codec profiles and levels)  the device is able to direct play (without transcoding or remuxing),  as well as which <see cref=\"P:MediaBrowser.Model.Dlna.DeviceProfile.TranscodingProfiles\">containers/codecs to transcode to</see> in case it isn't.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of this device profile. User profiles must have a unique name.", alias="Name")
    id: Optional[UUID] = Field(default=None, description="Gets or sets the unique internal identifier.", alias="Id")
    max_streaming_bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum allowed bitrate for all streamed content.", alias="MaxStreamingBitrate")
    max_static_bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum allowed bitrate for statically streamed content (= direct played files).", alias="MaxStaticBitrate")
    music_streaming_transcoding_bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum allowed bitrate for transcoded music streams.", alias="MusicStreamingTranscodingBitrate")
    max_static_music_bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum allowed bitrate for statically streamed (= direct played) music files.", alias="MaxStaticMusicBitrate")
    direct_play_profiles: Optional[List[DirectPlayProfile]] = Field(default=None, description="Gets or sets the direct play profiles.", alias="DirectPlayProfiles")
    transcoding_profiles: Optional[List[TranscodingProfile]] = Field(default=None, description="Gets or sets the transcoding profiles.", alias="TranscodingProfiles")
    container_profiles: Optional[List[ContainerProfile]] = Field(default=None, description="Gets or sets the container profiles. Failing to meet these optional conditions causes transcoding to occur.", alias="ContainerProfiles")
    codec_profiles: Optional[List[CodecProfile]] = Field(default=None, description="Gets or sets the codec profiles.", alias="CodecProfiles")
    subtitle_profiles: Optional[List[SubtitleProfile]] = Field(default=None, description="Gets or sets the subtitle profiles.", alias="SubtitleProfiles")
    __properties: ClassVar[List[str]] = ["Name", "Id", "MaxStreamingBitrate", "MaxStaticBitrate", "MusicStreamingTranscodingBitrate", "MaxStaticMusicBitrate", "DirectPlayProfiles", "TranscodingProfiles", "ContainerProfiles", "CodecProfiles", "SubtitleProfiles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in direct_play_profiles (list)
        _items = []
        if self.direct_play_profiles:
            for _item_direct_play_profiles in self.direct_play_profiles:
                if _item_direct_play_profiles:
                    _items.append(_item_direct_play_profiles.to_dict())
            _dict['DirectPlayProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transcoding_profiles (list)
        _items = []
        if self.transcoding_profiles:
            for _item_transcoding_profiles in self.transcoding_profiles:
                if _item_transcoding_profiles:
                    _items.append(_item_transcoding_profiles.to_dict())
            _dict['TranscodingProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in container_profiles (list)
        _items = []
        if self.container_profiles:
            for _item_container_profiles in self.container_profiles:
                if _item_container_profiles:
                    _items.append(_item_container_profiles.to_dict())
            _dict['ContainerProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in codec_profiles (list)
        _items = []
        if self.codec_profiles:
            for _item_codec_profiles in self.codec_profiles:
                if _item_codec_profiles:
                    _items.append(_item_codec_profiles.to_dict())
            _dict['CodecProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subtitle_profiles (list)
        _items = []
        if self.subtitle_profiles:
            for _item_subtitle_profiles in self.subtitle_profiles:
                if _item_subtitle_profiles:
                    _items.append(_item_subtitle_profiles.to_dict())
            _dict['SubtitleProfiles'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if max_streaming_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.max_streaming_bitrate is None and "max_streaming_bitrate" in self.model_fields_set:
            _dict['MaxStreamingBitrate'] = None

        # set to None if max_static_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.max_static_bitrate is None and "max_static_bitrate" in self.model_fields_set:
            _dict['MaxStaticBitrate'] = None

        # set to None if music_streaming_transcoding_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.music_streaming_transcoding_bitrate is None and "music_streaming_transcoding_bitrate" in self.model_fields_set:
            _dict['MusicStreamingTranscodingBitrate'] = None

        # set to None if max_static_music_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.max_static_music_bitrate is None and "max_static_music_bitrate" in self.model_fields_set:
            _dict['MaxStaticMusicBitrate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Id": obj.get("Id"),
            "MaxStreamingBitrate": obj.get("MaxStreamingBitrate"),
            "MaxStaticBitrate": obj.get("MaxStaticBitrate"),
            "MusicStreamingTranscodingBitrate": obj.get("MusicStreamingTranscodingBitrate"),
            "MaxStaticMusicBitrate": obj.get("MaxStaticMusicBitrate"),
            "DirectPlayProfiles": [DirectPlayProfile.from_dict(_item) for _item in obj["DirectPlayProfiles"]] if obj.get("DirectPlayProfiles") is not None else None,
            "TranscodingProfiles": [TranscodingProfile.from_dict(_item) for _item in obj["TranscodingProfiles"]] if obj.get("TranscodingProfiles") is not None else None,
            "ContainerProfiles": [ContainerProfile.from_dict(_item) for _item in obj["ContainerProfiles"]] if obj.get("ContainerProfiles") is not None else None,
            "CodecProfiles": [CodecProfile.from_dict(_item) for _item in obj["CodecProfiles"]] if obj.get("CodecProfiles") is not None else None,
            "SubtitleProfiles": [SubtitleProfile.from_dict(_item) for _item in obj["SubtitleProfiles"]] if obj.get("SubtitleProfiles") is not None else None
        })
        return _obj


