# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_10.models.deinterlace_method import DeinterlaceMethod
from jellyfin.generated.api_10_10.models.down_mix_stereo_algorithms import DownMixStereoAlgorithms
from jellyfin.generated.api_10_10.models.encoder_preset import EncoderPreset
from jellyfin.generated.api_10_10.models.hardware_acceleration_type import HardwareAccelerationType
from jellyfin.generated.api_10_10.models.tonemapping_algorithm import TonemappingAlgorithm
from jellyfin.generated.api_10_10.models.tonemapping_mode import TonemappingMode
from jellyfin.generated.api_10_10.models.tonemapping_range import TonemappingRange
from typing import Optional, Set
from typing_extensions import Self

class EncodingOptions(BaseModel):
    """
    Class EncodingOptions.
    """ # noqa: E501
    encoding_thread_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the thread count used for encoding.", alias="EncodingThreadCount")
    transcoding_temp_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the temporary transcoding path.", alias="TranscodingTempPath")
    fallback_font_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the path to the fallback font.", alias="FallbackFontPath")
    enable_fallback_font: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to use the fallback font.", alias="EnableFallbackFont")
    enable_audio_vbr: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether audio VBR is enabled.", alias="EnableAudioVbr")
    down_mix_audio_boost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the audio boost applied when downmixing audio.", alias="DownMixAudioBoost")
    down_mix_stereo_algorithm: Optional[DownMixStereoAlgorithms] = Field(default=None, alias="DownMixStereoAlgorithm")
    max_muxing_queue_size: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum size of the muxing queue.", alias="MaxMuxingQueueSize")
    enable_throttling: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether throttling is enabled.", alias="EnableThrottling")
    throttle_delay_seconds: Optional[StrictInt] = Field(default=None, description="Gets or sets the delay after which throttling happens.", alias="ThrottleDelaySeconds")
    enable_segment_deletion: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether segment deletion is enabled.", alias="EnableSegmentDeletion")
    segment_keep_seconds: Optional[StrictInt] = Field(default=None, description="Gets or sets seconds for which segments should be kept before being deleted.", alias="SegmentKeepSeconds")
    hardware_acceleration_type: Optional[HardwareAccelerationType] = Field(default=None, alias="HardwareAccelerationType")
    encoder_app_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the FFmpeg path as set by the user via the UI.", alias="EncoderAppPath")
    encoder_app_path_display: Optional[StrictStr] = Field(default=None, description="Gets or sets the current FFmpeg path being used by the system and displayed on the transcode page.", alias="EncoderAppPathDisplay")
    vaapi_device: Optional[StrictStr] = Field(default=None, description="Gets or sets the VA-API device.", alias="VaapiDevice")
    qsv_device: Optional[StrictStr] = Field(default=None, description="Gets or sets the QSV device.", alias="QsvDevice")
    enable_tonemapping: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether tonemapping is enabled.", alias="EnableTonemapping")
    enable_vpp_tonemapping: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether VPP tonemapping is enabled.", alias="EnableVppTonemapping")
    enable_video_toolbox_tonemapping: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether videotoolbox tonemapping is enabled.", alias="EnableVideoToolboxTonemapping")
    tonemapping_algorithm: Optional[TonemappingAlgorithm] = Field(default=None, alias="TonemappingAlgorithm")
    tonemapping_mode: Optional[TonemappingMode] = Field(default=None, alias="TonemappingMode")
    tonemapping_range: Optional[TonemappingRange] = Field(default=None, alias="TonemappingRange")
    tonemapping_desat: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the tone-mapping desaturation.", alias="TonemappingDesat")
    tonemapping_peak: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the tone-mapping peak.", alias="TonemappingPeak")
    tonemapping_param: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the tone-mapping parameters.", alias="TonemappingParam")
    vpp_tonemapping_brightness: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the VPP tone-mapping brightness.", alias="VppTonemappingBrightness")
    vpp_tonemapping_contrast: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the VPP tone-mapping contrast.", alias="VppTonemappingContrast")
    h264_crf: Optional[StrictInt] = Field(default=None, description="Gets or sets the H264 CRF.", alias="H264Crf")
    h265_crf: Optional[StrictInt] = Field(default=None, description="Gets or sets the H265 CRF.", alias="H265Crf")
    encoder_preset: Optional[EncoderPreset] = Field(default=None, alias="EncoderPreset")
    deinterlace_double_rate: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the framerate is doubled when deinterlacing.", alias="DeinterlaceDoubleRate")
    deinterlace_method: Optional[DeinterlaceMethod] = Field(default=None, alias="DeinterlaceMethod")
    enable_decoding_color_depth10_hevc: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether 10bit HEVC decoding is enabled.", alias="EnableDecodingColorDepth10Hevc")
    enable_decoding_color_depth10_vp9: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether 10bit VP9 decoding is enabled.", alias="EnableDecodingColorDepth10Vp9")
    enable_decoding_color_depth10_hevc_rext: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether 8/10bit HEVC RExt decoding is enabled.", alias="EnableDecodingColorDepth10HevcRext")
    enable_decoding_color_depth12_hevc_rext: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether 12bit HEVC RExt decoding is enabled.", alias="EnableDecodingColorDepth12HevcRext")
    enable_enhanced_nvdec_decoder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the enhanced NVDEC is enabled.", alias="EnableEnhancedNvdecDecoder")
    prefer_system_native_hw_decoder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the system native hardware decoder should be used.", alias="PreferSystemNativeHwDecoder")
    enable_intel_low_power_h264_hw_encoder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the Intel H264 low-power hardware encoder should be used.", alias="EnableIntelLowPowerH264HwEncoder")
    enable_intel_low_power_hevc_hw_encoder: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the Intel HEVC low-power hardware encoder should be used.", alias="EnableIntelLowPowerHevcHwEncoder")
    enable_hardware_encoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether hardware encoding is enabled.", alias="EnableHardwareEncoding")
    allow_hevc_encoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether HEVC encoding is enabled.", alias="AllowHevcEncoding")
    allow_av1_encoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether AV1 encoding is enabled.", alias="AllowAv1Encoding")
    enable_subtitle_extraction: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether subtitle extraction is enabled.", alias="EnableSubtitleExtraction")
    hardware_decoding_codecs: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the codecs hardware encoding is used for.", alias="HardwareDecodingCodecs")
    allow_on_demand_metadata_based_keyframe_extraction_for_extensions: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the file extensions on-demand metadata based keyframe extraction is enabled for.", alias="AllowOnDemandMetadataBasedKeyframeExtractionForExtensions")
    __properties: ClassVar[List[str]] = ["EncodingThreadCount", "TranscodingTempPath", "FallbackFontPath", "EnableFallbackFont", "EnableAudioVbr", "DownMixAudioBoost", "DownMixStereoAlgorithm", "MaxMuxingQueueSize", "EnableThrottling", "ThrottleDelaySeconds", "EnableSegmentDeletion", "SegmentKeepSeconds", "HardwareAccelerationType", "EncoderAppPath", "EncoderAppPathDisplay", "VaapiDevice", "QsvDevice", "EnableTonemapping", "EnableVppTonemapping", "EnableVideoToolboxTonemapping", "TonemappingAlgorithm", "TonemappingMode", "TonemappingRange", "TonemappingDesat", "TonemappingPeak", "TonemappingParam", "VppTonemappingBrightness", "VppTonemappingContrast", "H264Crf", "H265Crf", "EncoderPreset", "DeinterlaceDoubleRate", "DeinterlaceMethod", "EnableDecodingColorDepth10Hevc", "EnableDecodingColorDepth10Vp9", "EnableDecodingColorDepth10HevcRext", "EnableDecodingColorDepth12HevcRext", "EnableEnhancedNvdecDecoder", "PreferSystemNativeHwDecoder", "EnableIntelLowPowerH264HwEncoder", "EnableIntelLowPowerHevcHwEncoder", "EnableHardwareEncoding", "AllowHevcEncoding", "AllowAv1Encoding", "EnableSubtitleExtraction", "HardwareDecodingCodecs", "AllowOnDemandMetadataBasedKeyframeExtractionForExtensions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EncodingOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if transcoding_temp_path (nullable) is None
        # and model_fields_set contains the field
        if self.transcoding_temp_path is None and "transcoding_temp_path" in self.model_fields_set:
            _dict['TranscodingTempPath'] = None

        # set to None if fallback_font_path (nullable) is None
        # and model_fields_set contains the field
        if self.fallback_font_path is None and "fallback_font_path" in self.model_fields_set:
            _dict['FallbackFontPath'] = None

        # set to None if encoder_app_path (nullable) is None
        # and model_fields_set contains the field
        if self.encoder_app_path is None and "encoder_app_path" in self.model_fields_set:
            _dict['EncoderAppPath'] = None

        # set to None if encoder_app_path_display (nullable) is None
        # and model_fields_set contains the field
        if self.encoder_app_path_display is None and "encoder_app_path_display" in self.model_fields_set:
            _dict['EncoderAppPathDisplay'] = None

        # set to None if vaapi_device (nullable) is None
        # and model_fields_set contains the field
        if self.vaapi_device is None and "vaapi_device" in self.model_fields_set:
            _dict['VaapiDevice'] = None

        # set to None if qsv_device (nullable) is None
        # and model_fields_set contains the field
        if self.qsv_device is None and "qsv_device" in self.model_fields_set:
            _dict['QsvDevice'] = None

        # set to None if hardware_decoding_codecs (nullable) is None
        # and model_fields_set contains the field
        if self.hardware_decoding_codecs is None and "hardware_decoding_codecs" in self.model_fields_set:
            _dict['HardwareDecodingCodecs'] = None

        # set to None if allow_on_demand_metadata_based_keyframe_extraction_for_extensions (nullable) is None
        # and model_fields_set contains the field
        if self.allow_on_demand_metadata_based_keyframe_extraction_for_extensions is None and "allow_on_demand_metadata_based_keyframe_extraction_for_extensions" in self.model_fields_set:
            _dict['AllowOnDemandMetadataBasedKeyframeExtractionForExtensions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EncodingOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "EncodingThreadCount": obj.get("EncodingThreadCount"),
            "TranscodingTempPath": obj.get("TranscodingTempPath"),
            "FallbackFontPath": obj.get("FallbackFontPath"),
            "EnableFallbackFont": obj.get("EnableFallbackFont"),
            "EnableAudioVbr": obj.get("EnableAudioVbr"),
            "DownMixAudioBoost": obj.get("DownMixAudioBoost"),
            "DownMixStereoAlgorithm": obj.get("DownMixStereoAlgorithm"),
            "MaxMuxingQueueSize": obj.get("MaxMuxingQueueSize"),
            "EnableThrottling": obj.get("EnableThrottling"),
            "ThrottleDelaySeconds": obj.get("ThrottleDelaySeconds"),
            "EnableSegmentDeletion": obj.get("EnableSegmentDeletion"),
            "SegmentKeepSeconds": obj.get("SegmentKeepSeconds"),
            "HardwareAccelerationType": obj.get("HardwareAccelerationType"),
            "EncoderAppPath": obj.get("EncoderAppPath"),
            "EncoderAppPathDisplay": obj.get("EncoderAppPathDisplay"),
            "VaapiDevice": obj.get("VaapiDevice"),
            "QsvDevice": obj.get("QsvDevice"),
            "EnableTonemapping": obj.get("EnableTonemapping"),
            "EnableVppTonemapping": obj.get("EnableVppTonemapping"),
            "EnableVideoToolboxTonemapping": obj.get("EnableVideoToolboxTonemapping"),
            "TonemappingAlgorithm": obj.get("TonemappingAlgorithm"),
            "TonemappingMode": obj.get("TonemappingMode"),
            "TonemappingRange": obj.get("TonemappingRange"),
            "TonemappingDesat": obj.get("TonemappingDesat"),
            "TonemappingPeak": obj.get("TonemappingPeak"),
            "TonemappingParam": obj.get("TonemappingParam"),
            "VppTonemappingBrightness": obj.get("VppTonemappingBrightness"),
            "VppTonemappingContrast": obj.get("VppTonemappingContrast"),
            "H264Crf": obj.get("H264Crf"),
            "H265Crf": obj.get("H265Crf"),
            "EncoderPreset": obj.get("EncoderPreset"),
            "DeinterlaceDoubleRate": obj.get("DeinterlaceDoubleRate"),
            "DeinterlaceMethod": obj.get("DeinterlaceMethod"),
            "EnableDecodingColorDepth10Hevc": obj.get("EnableDecodingColorDepth10Hevc"),
            "EnableDecodingColorDepth10Vp9": obj.get("EnableDecodingColorDepth10Vp9"),
            "EnableDecodingColorDepth10HevcRext": obj.get("EnableDecodingColorDepth10HevcRext"),
            "EnableDecodingColorDepth12HevcRext": obj.get("EnableDecodingColorDepth12HevcRext"),
            "EnableEnhancedNvdecDecoder": obj.get("EnableEnhancedNvdecDecoder"),
            "PreferSystemNativeHwDecoder": obj.get("PreferSystemNativeHwDecoder"),
            "EnableIntelLowPowerH264HwEncoder": obj.get("EnableIntelLowPowerH264HwEncoder"),
            "EnableIntelLowPowerHevcHwEncoder": obj.get("EnableIntelLowPowerHevcHwEncoder"),
            "EnableHardwareEncoding": obj.get("EnableHardwareEncoding"),
            "AllowHevcEncoding": obj.get("AllowHevcEncoding"),
            "AllowAv1Encoding": obj.get("AllowAv1Encoding"),
            "EnableSubtitleExtraction": obj.get("EnableSubtitleExtraction"),
            "HardwareDecodingCodecs": obj.get("HardwareDecodingCodecs"),
            "AllowOnDemandMetadataBasedKeyframeExtractionForExtensions": obj.get("AllowOnDemandMetadataBasedKeyframeExtractionForExtensions")
        })
        return _obj


