# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from jellyfin.generated.api_10_10.models.group_info_dto_group_update import GroupInfoDtoGroupUpdate
from jellyfin.generated.api_10_10.models.group_state_update_group_update import GroupStateUpdateGroupUpdate
from jellyfin.generated.api_10_10.models.play_queue_update_group_update import PlayQueueUpdateGroupUpdate
from jellyfin.generated.api_10_10.models.string_group_update import StringGroupUpdate
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

GROUPUPDATE_ONE_OF_SCHEMAS = ["GroupInfoDtoGroupUpdate", "GroupStateUpdateGroupUpdate", "PlayQueueUpdateGroupUpdate", "StringGroupUpdate"]

class GroupUpdate(BaseModel):
    """
    Group update without data.
    """
    # data type: GroupInfoDtoGroupUpdate
    oneof_schema_1_validator: Optional[GroupInfoDtoGroupUpdate] = None
    # data type: GroupStateUpdateGroupUpdate
    oneof_schema_2_validator: Optional[GroupStateUpdateGroupUpdate] = None
    # data type: StringGroupUpdate
    oneof_schema_3_validator: Optional[StringGroupUpdate] = None
    # data type: PlayQueueUpdateGroupUpdate
    oneof_schema_4_validator: Optional[PlayQueueUpdateGroupUpdate] = None
    actual_instance: Optional[Union[GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate]] = None
    one_of_schemas: Set[str] = { "GroupInfoDtoGroupUpdate", "GroupStateUpdateGroupUpdate", "PlayQueueUpdateGroupUpdate", "StringGroupUpdate" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = GroupUpdate.model_construct()
        error_messages = []
        match = 0
        # validate data type: GroupInfoDtoGroupUpdate
        if not isinstance(v, GroupInfoDtoGroupUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GroupInfoDtoGroupUpdate`")
        else:
            match += 1
        # validate data type: GroupStateUpdateGroupUpdate
        if not isinstance(v, GroupStateUpdateGroupUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GroupStateUpdateGroupUpdate`")
        else:
            match += 1
        # validate data type: StringGroupUpdate
        if not isinstance(v, StringGroupUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StringGroupUpdate`")
        else:
            match += 1
        # validate data type: PlayQueueUpdateGroupUpdate
        if not isinstance(v, PlayQueueUpdateGroupUpdate):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PlayQueueUpdateGroupUpdate`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in GroupUpdate with oneOf schemas: GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in GroupUpdate with oneOf schemas: GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into GroupInfoDtoGroupUpdate
        try:
            instance.actual_instance = GroupInfoDtoGroupUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into GroupStateUpdateGroupUpdate
        try:
            instance.actual_instance = GroupStateUpdateGroupUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into StringGroupUpdate
        try:
            instance.actual_instance = StringGroupUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PlayQueueUpdateGroupUpdate
        try:
            instance.actual_instance = PlayQueueUpdateGroupUpdate.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into GroupUpdate with oneOf schemas: GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GroupUpdate with oneOf schemas: GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], GroupInfoDtoGroupUpdate, GroupStateUpdateGroupUpdate, PlayQueueUpdateGroupUpdate, StringGroupUpdate]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


