# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class IPlugin(BaseModel):
    """
    Defines the MediaBrowser.Common.Plugins.IPlugin.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets the name of the plugin.", alias="Name")
    description: Optional[StrictStr] = Field(default=None, description="Gets the Description.", alias="Description")
    id: Optional[UUID] = Field(default=None, description="Gets the unique id.", alias="Id")
    version: Optional[StrictStr] = Field(default=None, description="Gets the plugin version.", alias="Version")
    assembly_file_path: Optional[StrictStr] = Field(default=None, description="Gets the path to the assembly file.", alias="AssemblyFilePath")
    can_uninstall: Optional[StrictBool] = Field(default=None, description="Gets a value indicating whether the plugin can be uninstalled.", alias="CanUninstall")
    data_folder_path: Optional[StrictStr] = Field(default=None, description="Gets the full path to the data folder, where the plugin can store any miscellaneous files needed.", alias="DataFolderPath")
    __properties: ClassVar[List[str]] = ["Name", "Description", "Id", "Version", "AssemblyFilePath", "CanUninstall", "DataFolderPath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IPlugin from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "name",
            "description",
            "id",
            "version",
            "assembly_file_path",
            "can_uninstall",
            "data_folder_path",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['Description'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['Version'] = None

        # set to None if assembly_file_path (nullable) is None
        # and model_fields_set contains the field
        if self.assembly_file_path is None and "assembly_file_path" in self.model_fields_set:
            _dict['AssemblyFilePath'] = None

        # set to None if data_folder_path (nullable) is None
        # and model_fields_set contains the field
        if self.data_folder_path is None and "data_folder_path" in self.model_fields_set:
            _dict['DataFolderPath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IPlugin from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Description": obj.get("Description"),
            "Id": obj.get("Id"),
            "Version": obj.get("Version"),
            "AssemblyFilePath": obj.get("AssemblyFilePath"),
            "CanUninstall": obj.get("CanUninstall"),
            "DataFolderPath": obj.get("DataFolderPath")
        })
        return _obj


