# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.embedded_subtitle_options import EmbeddedSubtitleOptions
from jellyfin.generated.api_10_10.models.media_path_info import MediaPathInfo
from jellyfin.generated.api_10_10.models.type_options import TypeOptions
from typing import Optional, Set
from typing_extensions import Self

class LibraryOptions(BaseModel):
    """
    LibraryOptions
    """ # noqa: E501
    enabled: Optional[StrictBool] = Field(default=None, alias="Enabled")
    enable_photos: Optional[StrictBool] = Field(default=None, alias="EnablePhotos")
    enable_realtime_monitor: Optional[StrictBool] = Field(default=None, alias="EnableRealtimeMonitor")
    enable_lufs_scan: Optional[StrictBool] = Field(default=None, alias="EnableLUFSScan")
    enable_chapter_image_extraction: Optional[StrictBool] = Field(default=None, alias="EnableChapterImageExtraction")
    extract_chapter_images_during_library_scan: Optional[StrictBool] = Field(default=None, alias="ExtractChapterImagesDuringLibraryScan")
    enable_trickplay_image_extraction: Optional[StrictBool] = Field(default=None, alias="EnableTrickplayImageExtraction")
    extract_trickplay_images_during_library_scan: Optional[StrictBool] = Field(default=None, alias="ExtractTrickplayImagesDuringLibraryScan")
    path_infos: Optional[List[MediaPathInfo]] = Field(default=None, alias="PathInfos")
    save_local_metadata: Optional[StrictBool] = Field(default=None, alias="SaveLocalMetadata")
    enable_internet_providers: Optional[StrictBool] = Field(default=None, alias="EnableInternetProviders")
    enable_automatic_series_grouping: Optional[StrictBool] = Field(default=None, alias="EnableAutomaticSeriesGrouping")
    enable_embedded_titles: Optional[StrictBool] = Field(default=None, alias="EnableEmbeddedTitles")
    enable_embedded_extras_titles: Optional[StrictBool] = Field(default=None, alias="EnableEmbeddedExtrasTitles")
    enable_embedded_episode_infos: Optional[StrictBool] = Field(default=None, alias="EnableEmbeddedEpisodeInfos")
    automatic_refresh_interval_days: Optional[StrictInt] = Field(default=None, alias="AutomaticRefreshIntervalDays")
    preferred_metadata_language: Optional[StrictStr] = Field(default=None, description="Gets or sets the preferred metadata language.", alias="PreferredMetadataLanguage")
    metadata_country_code: Optional[StrictStr] = Field(default=None, description="Gets or sets the metadata country code.", alias="MetadataCountryCode")
    season_zero_display_name: Optional[StrictStr] = Field(default=None, alias="SeasonZeroDisplayName")
    metadata_savers: Optional[List[StrictStr]] = Field(default=None, alias="MetadataSavers")
    disabled_local_metadata_readers: Optional[List[StrictStr]] = Field(default=None, alias="DisabledLocalMetadataReaders")
    local_metadata_reader_order: Optional[List[StrictStr]] = Field(default=None, alias="LocalMetadataReaderOrder")
    disabled_subtitle_fetchers: Optional[List[StrictStr]] = Field(default=None, alias="DisabledSubtitleFetchers")
    subtitle_fetcher_order: Optional[List[StrictStr]] = Field(default=None, alias="SubtitleFetcherOrder")
    disabled_media_segment_providers: Optional[List[StrictStr]] = Field(default=None, alias="DisabledMediaSegmentProviders")
    media_segment_provide_order: Optional[List[StrictStr]] = Field(default=None, alias="MediaSegmentProvideOrder")
    skip_subtitles_if_embedded_subtitles_present: Optional[StrictBool] = Field(default=None, alias="SkipSubtitlesIfEmbeddedSubtitlesPresent")
    skip_subtitles_if_audio_track_matches: Optional[StrictBool] = Field(default=None, alias="SkipSubtitlesIfAudioTrackMatches")
    subtitle_download_languages: Optional[List[StrictStr]] = Field(default=None, alias="SubtitleDownloadLanguages")
    require_perfect_subtitle_match: Optional[StrictBool] = Field(default=None, alias="RequirePerfectSubtitleMatch")
    save_subtitles_with_media: Optional[StrictBool] = Field(default=None, alias="SaveSubtitlesWithMedia")
    save_lyrics_with_media: Optional[StrictBool] = Field(default=False, alias="SaveLyricsWithMedia")
    save_trickplay_with_media: Optional[StrictBool] = Field(default=False, alias="SaveTrickplayWithMedia")
    disabled_lyric_fetchers: Optional[List[StrictStr]] = Field(default=None, alias="DisabledLyricFetchers")
    lyric_fetcher_order: Optional[List[StrictStr]] = Field(default=None, alias="LyricFetcherOrder")
    prefer_nonstandard_artists_tag: Optional[StrictBool] = Field(default=False, alias="PreferNonstandardArtistsTag")
    use_custom_tag_delimiters: Optional[StrictBool] = Field(default=False, alias="UseCustomTagDelimiters")
    custom_tag_delimiters: Optional[List[StrictStr]] = Field(default=None, alias="CustomTagDelimiters")
    delimiter_whitelist: Optional[List[StrictStr]] = Field(default=None, alias="DelimiterWhitelist")
    automatically_add_to_collection: Optional[StrictBool] = Field(default=None, alias="AutomaticallyAddToCollection")
    allow_embedded_subtitles: Optional[EmbeddedSubtitleOptions] = Field(default=None, alias="AllowEmbeddedSubtitles")
    type_options: Optional[List[TypeOptions]] = Field(default=None, alias="TypeOptions")
    __properties: ClassVar[List[str]] = ["Enabled", "EnablePhotos", "EnableRealtimeMonitor", "EnableLUFSScan", "EnableChapterImageExtraction", "ExtractChapterImagesDuringLibraryScan", "EnableTrickplayImageExtraction", "ExtractTrickplayImagesDuringLibraryScan", "PathInfos", "SaveLocalMetadata", "EnableInternetProviders", "EnableAutomaticSeriesGrouping", "EnableEmbeddedTitles", "EnableEmbeddedExtrasTitles", "EnableEmbeddedEpisodeInfos", "AutomaticRefreshIntervalDays", "PreferredMetadataLanguage", "MetadataCountryCode", "SeasonZeroDisplayName", "MetadataSavers", "DisabledLocalMetadataReaders", "LocalMetadataReaderOrder", "DisabledSubtitleFetchers", "SubtitleFetcherOrder", "DisabledMediaSegmentProviders", "MediaSegmentProvideOrder", "SkipSubtitlesIfEmbeddedSubtitlesPresent", "SkipSubtitlesIfAudioTrackMatches", "SubtitleDownloadLanguages", "RequirePerfectSubtitleMatch", "SaveSubtitlesWithMedia", "SaveLyricsWithMedia", "SaveTrickplayWithMedia", "DisabledLyricFetchers", "LyricFetcherOrder", "PreferNonstandardArtistsTag", "UseCustomTagDelimiters", "CustomTagDelimiters", "DelimiterWhitelist", "AutomaticallyAddToCollection", "AllowEmbeddedSubtitles", "TypeOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LibraryOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in path_infos (list)
        _items = []
        if self.path_infos:
            for _item_path_infos in self.path_infos:
                if _item_path_infos:
                    _items.append(_item_path_infos.to_dict())
            _dict['PathInfos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in type_options (list)
        _items = []
        if self.type_options:
            for _item_type_options in self.type_options:
                if _item_type_options:
                    _items.append(_item_type_options.to_dict())
            _dict['TypeOptions'] = _items
        # set to None if preferred_metadata_language (nullable) is None
        # and model_fields_set contains the field
        if self.preferred_metadata_language is None and "preferred_metadata_language" in self.model_fields_set:
            _dict['PreferredMetadataLanguage'] = None

        # set to None if metadata_country_code (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_country_code is None and "metadata_country_code" in self.model_fields_set:
            _dict['MetadataCountryCode'] = None

        # set to None if metadata_savers (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_savers is None and "metadata_savers" in self.model_fields_set:
            _dict['MetadataSavers'] = None

        # set to None if local_metadata_reader_order (nullable) is None
        # and model_fields_set contains the field
        if self.local_metadata_reader_order is None and "local_metadata_reader_order" in self.model_fields_set:
            _dict['LocalMetadataReaderOrder'] = None

        # set to None if subtitle_download_languages (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_download_languages is None and "subtitle_download_languages" in self.model_fields_set:
            _dict['SubtitleDownloadLanguages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LibraryOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Enabled": obj.get("Enabled"),
            "EnablePhotos": obj.get("EnablePhotos"),
            "EnableRealtimeMonitor": obj.get("EnableRealtimeMonitor"),
            "EnableLUFSScan": obj.get("EnableLUFSScan"),
            "EnableChapterImageExtraction": obj.get("EnableChapterImageExtraction"),
            "ExtractChapterImagesDuringLibraryScan": obj.get("ExtractChapterImagesDuringLibraryScan"),
            "EnableTrickplayImageExtraction": obj.get("EnableTrickplayImageExtraction"),
            "ExtractTrickplayImagesDuringLibraryScan": obj.get("ExtractTrickplayImagesDuringLibraryScan"),
            "PathInfos": [MediaPathInfo.from_dict(_item) for _item in obj["PathInfos"]] if obj.get("PathInfos") is not None else None,
            "SaveLocalMetadata": obj.get("SaveLocalMetadata"),
            "EnableInternetProviders": obj.get("EnableInternetProviders"),
            "EnableAutomaticSeriesGrouping": obj.get("EnableAutomaticSeriesGrouping"),
            "EnableEmbeddedTitles": obj.get("EnableEmbeddedTitles"),
            "EnableEmbeddedExtrasTitles": obj.get("EnableEmbeddedExtrasTitles"),
            "EnableEmbeddedEpisodeInfos": obj.get("EnableEmbeddedEpisodeInfos"),
            "AutomaticRefreshIntervalDays": obj.get("AutomaticRefreshIntervalDays"),
            "PreferredMetadataLanguage": obj.get("PreferredMetadataLanguage"),
            "MetadataCountryCode": obj.get("MetadataCountryCode"),
            "SeasonZeroDisplayName": obj.get("SeasonZeroDisplayName"),
            "MetadataSavers": obj.get("MetadataSavers"),
            "DisabledLocalMetadataReaders": obj.get("DisabledLocalMetadataReaders"),
            "LocalMetadataReaderOrder": obj.get("LocalMetadataReaderOrder"),
            "DisabledSubtitleFetchers": obj.get("DisabledSubtitleFetchers"),
            "SubtitleFetcherOrder": obj.get("SubtitleFetcherOrder"),
            "DisabledMediaSegmentProviders": obj.get("DisabledMediaSegmentProviders"),
            "MediaSegmentProvideOrder": obj.get("MediaSegmentProvideOrder"),
            "SkipSubtitlesIfEmbeddedSubtitlesPresent": obj.get("SkipSubtitlesIfEmbeddedSubtitlesPresent"),
            "SkipSubtitlesIfAudioTrackMatches": obj.get("SkipSubtitlesIfAudioTrackMatches"),
            "SubtitleDownloadLanguages": obj.get("SubtitleDownloadLanguages"),
            "RequirePerfectSubtitleMatch": obj.get("RequirePerfectSubtitleMatch"),
            "SaveSubtitlesWithMedia": obj.get("SaveSubtitlesWithMedia"),
            "SaveLyricsWithMedia": obj.get("SaveLyricsWithMedia") if obj.get("SaveLyricsWithMedia") is not None else False,
            "SaveTrickplayWithMedia": obj.get("SaveTrickplayWithMedia") if obj.get("SaveTrickplayWithMedia") is not None else False,
            "DisabledLyricFetchers": obj.get("DisabledLyricFetchers"),
            "LyricFetcherOrder": obj.get("LyricFetcherOrder"),
            "PreferNonstandardArtistsTag": obj.get("PreferNonstandardArtistsTag") if obj.get("PreferNonstandardArtistsTag") is not None else False,
            "UseCustomTagDelimiters": obj.get("UseCustomTagDelimiters") if obj.get("UseCustomTagDelimiters") is not None else False,
            "CustomTagDelimiters": obj.get("CustomTagDelimiters"),
            "DelimiterWhitelist": obj.get("DelimiterWhitelist"),
            "AutomaticallyAddToCollection": obj.get("AutomaticallyAddToCollection"),
            "AllowEmbeddedSubtitles": obj.get("AllowEmbeddedSubtitles"),
            "TypeOptions": [TypeOptions.from_dict(_item) for _item in obj["TypeOptions"]] if obj.get("TypeOptions") is not None else None
        })
        return _obj


