# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.listings_provider_info import ListingsProviderInfo
from jellyfin.generated.api_10_10.models.tuner_host_info import TunerHostInfo
from typing import Optional, Set
from typing_extensions import Self

class LiveTvOptions(BaseModel):
    """
    LiveTvOptions
    """ # noqa: E501
    guide_days: Optional[StrictInt] = Field(default=None, alias="GuideDays")
    recording_path: Optional[StrictStr] = Field(default=None, alias="RecordingPath")
    movie_recording_path: Optional[StrictStr] = Field(default=None, alias="MovieRecordingPath")
    series_recording_path: Optional[StrictStr] = Field(default=None, alias="SeriesRecordingPath")
    enable_recording_subfolders: Optional[StrictBool] = Field(default=None, alias="EnableRecordingSubfolders")
    enable_original_audio_with_encoded_recordings: Optional[StrictBool] = Field(default=None, alias="EnableOriginalAudioWithEncodedRecordings")
    tuner_hosts: Optional[List[TunerHostInfo]] = Field(default=None, alias="TunerHosts")
    listing_providers: Optional[List[ListingsProviderInfo]] = Field(default=None, alias="ListingProviders")
    pre_padding_seconds: Optional[StrictInt] = Field(default=None, alias="PrePaddingSeconds")
    post_padding_seconds: Optional[StrictInt] = Field(default=None, alias="PostPaddingSeconds")
    media_locations_created: Optional[List[StrictStr]] = Field(default=None, alias="MediaLocationsCreated")
    recording_post_processor: Optional[StrictStr] = Field(default=None, alias="RecordingPostProcessor")
    recording_post_processor_arguments: Optional[StrictStr] = Field(default=None, alias="RecordingPostProcessorArguments")
    save_recording_nfo: Optional[StrictBool] = Field(default=None, alias="SaveRecordingNFO")
    save_recording_images: Optional[StrictBool] = Field(default=None, alias="SaveRecordingImages")
    __properties: ClassVar[List[str]] = ["GuideDays", "RecordingPath", "MovieRecordingPath", "SeriesRecordingPath", "EnableRecordingSubfolders", "EnableOriginalAudioWithEncodedRecordings", "TunerHosts", "ListingProviders", "PrePaddingSeconds", "PostPaddingSeconds", "MediaLocationsCreated", "RecordingPostProcessor", "RecordingPostProcessorArguments", "SaveRecordingNFO", "SaveRecordingImages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LiveTvOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tuner_hosts (list)
        _items = []
        if self.tuner_hosts:
            for _item_tuner_hosts in self.tuner_hosts:
                if _item_tuner_hosts:
                    _items.append(_item_tuner_hosts.to_dict())
            _dict['TunerHosts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in listing_providers (list)
        _items = []
        if self.listing_providers:
            for _item_listing_providers in self.listing_providers:
                if _item_listing_providers:
                    _items.append(_item_listing_providers.to_dict())
            _dict['ListingProviders'] = _items
        # set to None if guide_days (nullable) is None
        # and model_fields_set contains the field
        if self.guide_days is None and "guide_days" in self.model_fields_set:
            _dict['GuideDays'] = None

        # set to None if recording_path (nullable) is None
        # and model_fields_set contains the field
        if self.recording_path is None and "recording_path" in self.model_fields_set:
            _dict['RecordingPath'] = None

        # set to None if movie_recording_path (nullable) is None
        # and model_fields_set contains the field
        if self.movie_recording_path is None and "movie_recording_path" in self.model_fields_set:
            _dict['MovieRecordingPath'] = None

        # set to None if series_recording_path (nullable) is None
        # and model_fields_set contains the field
        if self.series_recording_path is None and "series_recording_path" in self.model_fields_set:
            _dict['SeriesRecordingPath'] = None

        # set to None if tuner_hosts (nullable) is None
        # and model_fields_set contains the field
        if self.tuner_hosts is None and "tuner_hosts" in self.model_fields_set:
            _dict['TunerHosts'] = None

        # set to None if listing_providers (nullable) is None
        # and model_fields_set contains the field
        if self.listing_providers is None and "listing_providers" in self.model_fields_set:
            _dict['ListingProviders'] = None

        # set to None if media_locations_created (nullable) is None
        # and model_fields_set contains the field
        if self.media_locations_created is None and "media_locations_created" in self.model_fields_set:
            _dict['MediaLocationsCreated'] = None

        # set to None if recording_post_processor (nullable) is None
        # and model_fields_set contains the field
        if self.recording_post_processor is None and "recording_post_processor" in self.model_fields_set:
            _dict['RecordingPostProcessor'] = None

        # set to None if recording_post_processor_arguments (nullable) is None
        # and model_fields_set contains the field
        if self.recording_post_processor_arguments is None and "recording_post_processor_arguments" in self.model_fields_set:
            _dict['RecordingPostProcessorArguments'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LiveTvOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "GuideDays": obj.get("GuideDays"),
            "RecordingPath": obj.get("RecordingPath"),
            "MovieRecordingPath": obj.get("MovieRecordingPath"),
            "SeriesRecordingPath": obj.get("SeriesRecordingPath"),
            "EnableRecordingSubfolders": obj.get("EnableRecordingSubfolders"),
            "EnableOriginalAudioWithEncodedRecordings": obj.get("EnableOriginalAudioWithEncodedRecordings"),
            "TunerHosts": [TunerHostInfo.from_dict(_item) for _item in obj["TunerHosts"]] if obj.get("TunerHosts") is not None else None,
            "ListingProviders": [ListingsProviderInfo.from_dict(_item) for _item in obj["ListingProviders"]] if obj.get("ListingProviders") is not None else None,
            "PrePaddingSeconds": obj.get("PrePaddingSeconds"),
            "PostPaddingSeconds": obj.get("PostPaddingSeconds"),
            "MediaLocationsCreated": obj.get("MediaLocationsCreated"),
            "RecordingPostProcessor": obj.get("RecordingPostProcessor"),
            "RecordingPostProcessorArguments": obj.get("RecordingPostProcessorArguments"),
            "SaveRecordingNFO": obj.get("SaveRecordingNFO"),
            "SaveRecordingImages": obj.get("SaveRecordingImages")
        })
        return _obj


