# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_10.models.audio_spatial_format import AudioSpatialFormat
from jellyfin.generated.api_10_10.models.media_stream_type import MediaStreamType
from jellyfin.generated.api_10_10.models.subtitle_delivery_method import SubtitleDeliveryMethod
from jellyfin.generated.api_10_10.models.video_range import VideoRange
from jellyfin.generated.api_10_10.models.video_range_type import VideoRangeType
from typing import Optional, Set
from typing_extensions import Self

class MediaStream(BaseModel):
    """
    Class MediaStream.
    """ # noqa: E501
    codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the codec.", alias="Codec")
    codec_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the codec tag.", alias="CodecTag")
    language: Optional[StrictStr] = Field(default=None, description="Gets or sets the language.", alias="Language")
    color_range: Optional[StrictStr] = Field(default=None, description="Gets or sets the color range.", alias="ColorRange")
    color_space: Optional[StrictStr] = Field(default=None, description="Gets or sets the color space.", alias="ColorSpace")
    color_transfer: Optional[StrictStr] = Field(default=None, description="Gets or sets the color transfer.", alias="ColorTransfer")
    color_primaries: Optional[StrictStr] = Field(default=None, description="Gets or sets the color primaries.", alias="ColorPrimaries")
    dv_version_major: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision version major.", alias="DvVersionMajor")
    dv_version_minor: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision version minor.", alias="DvVersionMinor")
    dv_profile: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision profile.", alias="DvProfile")
    dv_level: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision level.", alias="DvLevel")
    rpu_present_flag: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision rpu present flag.", alias="RpuPresentFlag")
    el_present_flag: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision el present flag.", alias="ElPresentFlag")
    bl_present_flag: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision bl present flag.", alias="BlPresentFlag")
    dv_bl_signal_compatibility_id: Optional[StrictInt] = Field(default=None, description="Gets or sets the Dolby Vision bl signal compatibility id.", alias="DvBlSignalCompatibilityId")
    rotation: Optional[StrictInt] = Field(default=None, description="Gets or sets the Rotation in degrees.", alias="Rotation")
    comment: Optional[StrictStr] = Field(default=None, description="Gets or sets the comment.", alias="Comment")
    time_base: Optional[StrictStr] = Field(default=None, description="Gets or sets the time base.", alias="TimeBase")
    codec_time_base: Optional[StrictStr] = Field(default=None, description="Gets or sets the codec time base.", alias="CodecTimeBase")
    title: Optional[StrictStr] = Field(default=None, description="Gets or sets the title.", alias="Title")
    video_range: Optional[VideoRange] = Field(default=None, alias="VideoRange")
    video_range_type: Optional[VideoRangeType] = Field(default=None, alias="VideoRangeType")
    video_do_vi_title: Optional[StrictStr] = Field(default=None, description="Gets the video dovi title.", alias="VideoDoViTitle")
    audio_spatial_format: Optional[AudioSpatialFormat] = Field(default=None, alias="AudioSpatialFormat")
    localized_undefined: Optional[StrictStr] = Field(default=None, alias="LocalizedUndefined")
    localized_default: Optional[StrictStr] = Field(default=None, alias="LocalizedDefault")
    localized_forced: Optional[StrictStr] = Field(default=None, alias="LocalizedForced")
    localized_external: Optional[StrictStr] = Field(default=None, alias="LocalizedExternal")
    localized_hearing_impaired: Optional[StrictStr] = Field(default=None, alias="LocalizedHearingImpaired")
    display_title: Optional[StrictStr] = Field(default=None, alias="DisplayTitle")
    nal_length_size: Optional[StrictStr] = Field(default=None, alias="NalLengthSize")
    is_interlaced: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is interlaced.", alias="IsInterlaced")
    is_avc: Optional[StrictBool] = Field(default=None, alias="IsAVC")
    channel_layout: Optional[StrictStr] = Field(default=None, description="Gets or sets the channel layout.", alias="ChannelLayout")
    bit_rate: Optional[StrictInt] = Field(default=None, description="Gets or sets the bit rate.", alias="BitRate")
    bit_depth: Optional[StrictInt] = Field(default=None, description="Gets or sets the bit depth.", alias="BitDepth")
    ref_frames: Optional[StrictInt] = Field(default=None, description="Gets or sets the reference frames.", alias="RefFrames")
    packet_length: Optional[StrictInt] = Field(default=None, description="Gets or sets the length of the packet.", alias="PacketLength")
    channels: Optional[StrictInt] = Field(default=None, description="Gets or sets the channels.", alias="Channels")
    sample_rate: Optional[StrictInt] = Field(default=None, description="Gets or sets the sample rate.", alias="SampleRate")
    is_default: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is default.", alias="IsDefault")
    is_forced: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is forced.", alias="IsForced")
    is_hearing_impaired: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is for the hearing impaired.", alias="IsHearingImpaired")
    height: Optional[StrictInt] = Field(default=None, description="Gets or sets the height.", alias="Height")
    width: Optional[StrictInt] = Field(default=None, description="Gets or sets the width.", alias="Width")
    average_frame_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the average frame rate.", alias="AverageFrameRate")
    real_frame_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the real frame rate.", alias="RealFrameRate")
    reference_frame_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets the framerate used as reference.  Prefer AverageFrameRate, if that is null or an unrealistic value  then fallback to RealFrameRate.", alias="ReferenceFrameRate")
    profile: Optional[StrictStr] = Field(default=None, description="Gets or sets the profile.", alias="Profile")
    type: Optional[MediaStreamType] = Field(default=None, alias="Type")
    aspect_ratio: Optional[StrictStr] = Field(default=None, description="Gets or sets the aspect ratio.", alias="AspectRatio")
    index: Optional[StrictInt] = Field(default=None, description="Gets or sets the index.", alias="Index")
    score: Optional[StrictInt] = Field(default=None, description="Gets or sets the score.", alias="Score")
    is_external: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is external.", alias="IsExternal")
    delivery_method: Optional[SubtitleDeliveryMethod] = Field(default=None, alias="DeliveryMethod")
    delivery_url: Optional[StrictStr] = Field(default=None, description="Gets or sets the delivery URL.", alias="DeliveryUrl")
    is_external_url: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is external URL.", alias="IsExternalUrl")
    is_text_subtitle_stream: Optional[StrictBool] = Field(default=None, alias="IsTextSubtitleStream")
    supports_external_stream: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [supports external stream].", alias="SupportsExternalStream")
    path: Optional[StrictStr] = Field(default=None, description="Gets or sets the filename.", alias="Path")
    pixel_format: Optional[StrictStr] = Field(default=None, description="Gets or sets the pixel format.", alias="PixelFormat")
    level: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the level.", alias="Level")
    is_anamorphic: Optional[StrictBool] = Field(default=None, description="Gets or sets whether this instance is anamorphic.", alias="IsAnamorphic")
    __properties: ClassVar[List[str]] = ["Codec", "CodecTag", "Language", "ColorRange", "ColorSpace", "ColorTransfer", "ColorPrimaries", "DvVersionMajor", "DvVersionMinor", "DvProfile", "DvLevel", "RpuPresentFlag", "ElPresentFlag", "BlPresentFlag", "DvBlSignalCompatibilityId", "Rotation", "Comment", "TimeBase", "CodecTimeBase", "Title", "VideoRange", "VideoRangeType", "VideoDoViTitle", "AudioSpatialFormat", "LocalizedUndefined", "LocalizedDefault", "LocalizedForced", "LocalizedExternal", "LocalizedHearingImpaired", "DisplayTitle", "NalLengthSize", "IsInterlaced", "IsAVC", "ChannelLayout", "BitRate", "BitDepth", "RefFrames", "PacketLength", "Channels", "SampleRate", "IsDefault", "IsForced", "IsHearingImpaired", "Height", "Width", "AverageFrameRate", "RealFrameRate", "ReferenceFrameRate", "Profile", "Type", "AspectRatio", "Index", "Score", "IsExternal", "DeliveryMethod", "DeliveryUrl", "IsExternalUrl", "IsTextSubtitleStream", "SupportsExternalStream", "Path", "PixelFormat", "Level", "IsAnamorphic"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaStream from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "video_do_vi_title",
            "display_title",
            "reference_frame_rate",
            "is_text_subtitle_stream",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if codec (nullable) is None
        # and model_fields_set contains the field
        if self.codec is None and "codec" in self.model_fields_set:
            _dict['Codec'] = None

        # set to None if codec_tag (nullable) is None
        # and model_fields_set contains the field
        if self.codec_tag is None and "codec_tag" in self.model_fields_set:
            _dict['CodecTag'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['Language'] = None

        # set to None if color_range (nullable) is None
        # and model_fields_set contains the field
        if self.color_range is None and "color_range" in self.model_fields_set:
            _dict['ColorRange'] = None

        # set to None if color_space (nullable) is None
        # and model_fields_set contains the field
        if self.color_space is None and "color_space" in self.model_fields_set:
            _dict['ColorSpace'] = None

        # set to None if color_transfer (nullable) is None
        # and model_fields_set contains the field
        if self.color_transfer is None and "color_transfer" in self.model_fields_set:
            _dict['ColorTransfer'] = None

        # set to None if color_primaries (nullable) is None
        # and model_fields_set contains the field
        if self.color_primaries is None and "color_primaries" in self.model_fields_set:
            _dict['ColorPrimaries'] = None

        # set to None if dv_version_major (nullable) is None
        # and model_fields_set contains the field
        if self.dv_version_major is None and "dv_version_major" in self.model_fields_set:
            _dict['DvVersionMajor'] = None

        # set to None if dv_version_minor (nullable) is None
        # and model_fields_set contains the field
        if self.dv_version_minor is None and "dv_version_minor" in self.model_fields_set:
            _dict['DvVersionMinor'] = None

        # set to None if dv_profile (nullable) is None
        # and model_fields_set contains the field
        if self.dv_profile is None and "dv_profile" in self.model_fields_set:
            _dict['DvProfile'] = None

        # set to None if dv_level (nullable) is None
        # and model_fields_set contains the field
        if self.dv_level is None and "dv_level" in self.model_fields_set:
            _dict['DvLevel'] = None

        # set to None if rpu_present_flag (nullable) is None
        # and model_fields_set contains the field
        if self.rpu_present_flag is None and "rpu_present_flag" in self.model_fields_set:
            _dict['RpuPresentFlag'] = None

        # set to None if el_present_flag (nullable) is None
        # and model_fields_set contains the field
        if self.el_present_flag is None and "el_present_flag" in self.model_fields_set:
            _dict['ElPresentFlag'] = None

        # set to None if bl_present_flag (nullable) is None
        # and model_fields_set contains the field
        if self.bl_present_flag is None and "bl_present_flag" in self.model_fields_set:
            _dict['BlPresentFlag'] = None

        # set to None if dv_bl_signal_compatibility_id (nullable) is None
        # and model_fields_set contains the field
        if self.dv_bl_signal_compatibility_id is None and "dv_bl_signal_compatibility_id" in self.model_fields_set:
            _dict['DvBlSignalCompatibilityId'] = None

        # set to None if rotation (nullable) is None
        # and model_fields_set contains the field
        if self.rotation is None and "rotation" in self.model_fields_set:
            _dict['Rotation'] = None

        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['Comment'] = None

        # set to None if time_base (nullable) is None
        # and model_fields_set contains the field
        if self.time_base is None and "time_base" in self.model_fields_set:
            _dict['TimeBase'] = None

        # set to None if codec_time_base (nullable) is None
        # and model_fields_set contains the field
        if self.codec_time_base is None and "codec_time_base" in self.model_fields_set:
            _dict['CodecTimeBase'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['Title'] = None

        # set to None if video_do_vi_title (nullable) is None
        # and model_fields_set contains the field
        if self.video_do_vi_title is None and "video_do_vi_title" in self.model_fields_set:
            _dict['VideoDoViTitle'] = None

        # set to None if localized_undefined (nullable) is None
        # and model_fields_set contains the field
        if self.localized_undefined is None and "localized_undefined" in self.model_fields_set:
            _dict['LocalizedUndefined'] = None

        # set to None if localized_default (nullable) is None
        # and model_fields_set contains the field
        if self.localized_default is None and "localized_default" in self.model_fields_set:
            _dict['LocalizedDefault'] = None

        # set to None if localized_forced (nullable) is None
        # and model_fields_set contains the field
        if self.localized_forced is None and "localized_forced" in self.model_fields_set:
            _dict['LocalizedForced'] = None

        # set to None if localized_external (nullable) is None
        # and model_fields_set contains the field
        if self.localized_external is None and "localized_external" in self.model_fields_set:
            _dict['LocalizedExternal'] = None

        # set to None if localized_hearing_impaired (nullable) is None
        # and model_fields_set contains the field
        if self.localized_hearing_impaired is None and "localized_hearing_impaired" in self.model_fields_set:
            _dict['LocalizedHearingImpaired'] = None

        # set to None if display_title (nullable) is None
        # and model_fields_set contains the field
        if self.display_title is None and "display_title" in self.model_fields_set:
            _dict['DisplayTitle'] = None

        # set to None if nal_length_size (nullable) is None
        # and model_fields_set contains the field
        if self.nal_length_size is None and "nal_length_size" in self.model_fields_set:
            _dict['NalLengthSize'] = None

        # set to None if is_avc (nullable) is None
        # and model_fields_set contains the field
        if self.is_avc is None and "is_avc" in self.model_fields_set:
            _dict['IsAVC'] = None

        # set to None if channel_layout (nullable) is None
        # and model_fields_set contains the field
        if self.channel_layout is None and "channel_layout" in self.model_fields_set:
            _dict['ChannelLayout'] = None

        # set to None if bit_rate (nullable) is None
        # and model_fields_set contains the field
        if self.bit_rate is None and "bit_rate" in self.model_fields_set:
            _dict['BitRate'] = None

        # set to None if bit_depth (nullable) is None
        # and model_fields_set contains the field
        if self.bit_depth is None and "bit_depth" in self.model_fields_set:
            _dict['BitDepth'] = None

        # set to None if ref_frames (nullable) is None
        # and model_fields_set contains the field
        if self.ref_frames is None and "ref_frames" in self.model_fields_set:
            _dict['RefFrames'] = None

        # set to None if packet_length (nullable) is None
        # and model_fields_set contains the field
        if self.packet_length is None and "packet_length" in self.model_fields_set:
            _dict['PacketLength'] = None

        # set to None if channels (nullable) is None
        # and model_fields_set contains the field
        if self.channels is None and "channels" in self.model_fields_set:
            _dict['Channels'] = None

        # set to None if sample_rate (nullable) is None
        # and model_fields_set contains the field
        if self.sample_rate is None and "sample_rate" in self.model_fields_set:
            _dict['SampleRate'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['Height'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['Width'] = None

        # set to None if average_frame_rate (nullable) is None
        # and model_fields_set contains the field
        if self.average_frame_rate is None and "average_frame_rate" in self.model_fields_set:
            _dict['AverageFrameRate'] = None

        # set to None if real_frame_rate (nullable) is None
        # and model_fields_set contains the field
        if self.real_frame_rate is None and "real_frame_rate" in self.model_fields_set:
            _dict['RealFrameRate'] = None

        # set to None if reference_frame_rate (nullable) is None
        # and model_fields_set contains the field
        if self.reference_frame_rate is None and "reference_frame_rate" in self.model_fields_set:
            _dict['ReferenceFrameRate'] = None

        # set to None if profile (nullable) is None
        # and model_fields_set contains the field
        if self.profile is None and "profile" in self.model_fields_set:
            _dict['Profile'] = None

        # set to None if aspect_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.aspect_ratio is None and "aspect_ratio" in self.model_fields_set:
            _dict['AspectRatio'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['Score'] = None

        # set to None if delivery_url (nullable) is None
        # and model_fields_set contains the field
        if self.delivery_url is None and "delivery_url" in self.model_fields_set:
            _dict['DeliveryUrl'] = None

        # set to None if is_external_url (nullable) is None
        # and model_fields_set contains the field
        if self.is_external_url is None and "is_external_url" in self.model_fields_set:
            _dict['IsExternalUrl'] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['Path'] = None

        # set to None if pixel_format (nullable) is None
        # and model_fields_set contains the field
        if self.pixel_format is None and "pixel_format" in self.model_fields_set:
            _dict['PixelFormat'] = None

        # set to None if level (nullable) is None
        # and model_fields_set contains the field
        if self.level is None and "level" in self.model_fields_set:
            _dict['Level'] = None

        # set to None if is_anamorphic (nullable) is None
        # and model_fields_set contains the field
        if self.is_anamorphic is None and "is_anamorphic" in self.model_fields_set:
            _dict['IsAnamorphic'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaStream from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Codec": obj.get("Codec"),
            "CodecTag": obj.get("CodecTag"),
            "Language": obj.get("Language"),
            "ColorRange": obj.get("ColorRange"),
            "ColorSpace": obj.get("ColorSpace"),
            "ColorTransfer": obj.get("ColorTransfer"),
            "ColorPrimaries": obj.get("ColorPrimaries"),
            "DvVersionMajor": obj.get("DvVersionMajor"),
            "DvVersionMinor": obj.get("DvVersionMinor"),
            "DvProfile": obj.get("DvProfile"),
            "DvLevel": obj.get("DvLevel"),
            "RpuPresentFlag": obj.get("RpuPresentFlag"),
            "ElPresentFlag": obj.get("ElPresentFlag"),
            "BlPresentFlag": obj.get("BlPresentFlag"),
            "DvBlSignalCompatibilityId": obj.get("DvBlSignalCompatibilityId"),
            "Rotation": obj.get("Rotation"),
            "Comment": obj.get("Comment"),
            "TimeBase": obj.get("TimeBase"),
            "CodecTimeBase": obj.get("CodecTimeBase"),
            "Title": obj.get("Title"),
            "VideoRange": obj.get("VideoRange"),
            "VideoRangeType": obj.get("VideoRangeType"),
            "VideoDoViTitle": obj.get("VideoDoViTitle"),
            "AudioSpatialFormat": obj.get("AudioSpatialFormat"),
            "LocalizedUndefined": obj.get("LocalizedUndefined"),
            "LocalizedDefault": obj.get("LocalizedDefault"),
            "LocalizedForced": obj.get("LocalizedForced"),
            "LocalizedExternal": obj.get("LocalizedExternal"),
            "LocalizedHearingImpaired": obj.get("LocalizedHearingImpaired"),
            "DisplayTitle": obj.get("DisplayTitle"),
            "NalLengthSize": obj.get("NalLengthSize"),
            "IsInterlaced": obj.get("IsInterlaced"),
            "IsAVC": obj.get("IsAVC"),
            "ChannelLayout": obj.get("ChannelLayout"),
            "BitRate": obj.get("BitRate"),
            "BitDepth": obj.get("BitDepth"),
            "RefFrames": obj.get("RefFrames"),
            "PacketLength": obj.get("PacketLength"),
            "Channels": obj.get("Channels"),
            "SampleRate": obj.get("SampleRate"),
            "IsDefault": obj.get("IsDefault"),
            "IsForced": obj.get("IsForced"),
            "IsHearingImpaired": obj.get("IsHearingImpaired"),
            "Height": obj.get("Height"),
            "Width": obj.get("Width"),
            "AverageFrameRate": obj.get("AverageFrameRate"),
            "RealFrameRate": obj.get("RealFrameRate"),
            "ReferenceFrameRate": obj.get("ReferenceFrameRate"),
            "Profile": obj.get("Profile"),
            "Type": obj.get("Type"),
            "AspectRatio": obj.get("AspectRatio"),
            "Index": obj.get("Index"),
            "Score": obj.get("Score"),
            "IsExternal": obj.get("IsExternal"),
            "DeliveryMethod": obj.get("DeliveryMethod"),
            "DeliveryUrl": obj.get("DeliveryUrl"),
            "IsExternalUrl": obj.get("IsExternalUrl"),
            "IsTextSubtitleStream": obj.get("IsTextSubtitleStream"),
            "SupportsExternalStream": obj.get("SupportsExternalStream"),
            "Path": obj.get("Path"),
            "PixelFormat": obj.get("PixelFormat"),
            "Level": obj.get("Level"),
            "IsAnamorphic": obj.get("IsAnamorphic")
        })
        return _obj


