# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NetworkConfiguration(BaseModel):
    """
    Defines the MediaBrowser.Common.Net.NetworkConfiguration.
    """ # noqa: E501
    base_url: Optional[StrictStr] = Field(default=None, description="Gets or sets a value used to specify the URL prefix that your Jellyfin instance can be accessed at.", alias="BaseUrl")
    enable_https: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to use HTTPS.", alias="EnableHttps")
    require_https: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the server should force connections over HTTPS.", alias="RequireHttps")
    certificate_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the filesystem path of an X.509 certificate to use for SSL.", alias="CertificatePath")
    certificate_password: Optional[StrictStr] = Field(default=None, description="Gets or sets the password required to access the X.509 certificate data in the file specified by MediaBrowser.Common.Net.NetworkConfiguration.CertificatePath.", alias="CertificatePassword")
    internal_http_port: Optional[StrictInt] = Field(default=None, description="Gets or sets the internal HTTP server port.", alias="InternalHttpPort")
    internal_https_port: Optional[StrictInt] = Field(default=None, description="Gets or sets the internal HTTPS server port.", alias="InternalHttpsPort")
    public_http_port: Optional[StrictInt] = Field(default=None, description="Gets or sets the public HTTP port.", alias="PublicHttpPort")
    public_https_port: Optional[StrictInt] = Field(default=None, description="Gets or sets the public HTTPS port.", alias="PublicHttpsPort")
    auto_discovery: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether Autodiscovery is enabled.", alias="AutoDiscovery")
    enable_upn_p: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to enable automatic port forwarding.", alias="EnableUPnP")
    enable_ipv4: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether IPv6 is enabled.", alias="EnableIPv4")
    enable_ipv6: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether IPv6 is enabled.", alias="EnableIPv6")
    enable_remote_access: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether access from outside of the LAN is permitted.", alias="EnableRemoteAccess")
    local_network_subnets: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the subnets that are deemed to make up the LAN.", alias="LocalNetworkSubnets")
    local_network_addresses: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the interface addresses which Jellyfin will bind to. If empty, all interfaces will be used.", alias="LocalNetworkAddresses")
    known_proxies: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the known proxies.", alias="KnownProxies")
    ignore_virtual_interfaces: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether address names that match MediaBrowser.Common.Net.NetworkConfiguration.VirtualInterfaceNames should be ignored for the purposes of binding.", alias="IgnoreVirtualInterfaces")
    virtual_interface_names: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets a value indicating the interface name prefixes that should be ignored. The list can be comma separated and values are case-insensitive. <seealso cref=\"P:MediaBrowser.Common.Net.NetworkConfiguration.IgnoreVirtualInterfaces\" />.", alias="VirtualInterfaceNames")
    enable_published_server_uri_by_request: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the published server uri is based on information in HTTP requests.", alias="EnablePublishedServerUriByRequest")
    published_server_uri_by_subnet: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the PublishedServerUriBySubnet  Gets or sets PublishedServerUri to advertise for specific subnets.", alias="PublishedServerUriBySubnet")
    remote_ip_filter: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the filter for remote IP connectivity. Used in conjunction with <seealso cref=\"P:MediaBrowser.Common.Net.NetworkConfiguration.IsRemoteIPFilterBlacklist\" />.", alias="RemoteIPFilter")
    is_remote_ip_filter_blacklist: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether <seealso cref=\"P:MediaBrowser.Common.Net.NetworkConfiguration.RemoteIPFilter\" /> contains a blacklist or a whitelist. Default is a whitelist.", alias="IsRemoteIPFilterBlacklist")
    __properties: ClassVar[List[str]] = ["BaseUrl", "EnableHttps", "RequireHttps", "CertificatePath", "CertificatePassword", "InternalHttpPort", "InternalHttpsPort", "PublicHttpPort", "PublicHttpsPort", "AutoDiscovery", "EnableUPnP", "EnableIPv4", "EnableIPv6", "EnableRemoteAccess", "LocalNetworkSubnets", "LocalNetworkAddresses", "KnownProxies", "IgnoreVirtualInterfaces", "VirtualInterfaceNames", "EnablePublishedServerUriByRequest", "PublishedServerUriBySubnet", "RemoteIPFilter", "IsRemoteIPFilterBlacklist"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "BaseUrl": obj.get("BaseUrl"),
            "EnableHttps": obj.get("EnableHttps"),
            "RequireHttps": obj.get("RequireHttps"),
            "CertificatePath": obj.get("CertificatePath"),
            "CertificatePassword": obj.get("CertificatePassword"),
            "InternalHttpPort": obj.get("InternalHttpPort"),
            "InternalHttpsPort": obj.get("InternalHttpsPort"),
            "PublicHttpPort": obj.get("PublicHttpPort"),
            "PublicHttpsPort": obj.get("PublicHttpsPort"),
            "AutoDiscovery": obj.get("AutoDiscovery"),
            "EnableUPnP": obj.get("EnableUPnP"),
            "EnableIPv4": obj.get("EnableIPv4"),
            "EnableIPv6": obj.get("EnableIPv6"),
            "EnableRemoteAccess": obj.get("EnableRemoteAccess"),
            "LocalNetworkSubnets": obj.get("LocalNetworkSubnets"),
            "LocalNetworkAddresses": obj.get("LocalNetworkAddresses"),
            "KnownProxies": obj.get("KnownProxies"),
            "IgnoreVirtualInterfaces": obj.get("IgnoreVirtualInterfaces"),
            "VirtualInterfaceNames": obj.get("VirtualInterfaceNames"),
            "EnablePublishedServerUriByRequest": obj.get("EnablePublishedServerUriByRequest"),
            "PublishedServerUriBySubnet": obj.get("PublishedServerUriBySubnet"),
            "RemoteIPFilter": obj.get("RemoteIPFilter"),
            "IsRemoteIPFilterBlacklist": obj.get("IsRemoteIPFilterBlacklist")
        })
        return _obj


