# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.device_profile import DeviceProfile
from jellyfin.generated.api_10_10.models.media_protocol import MediaProtocol
from typing import Optional, Set
from typing_extensions import Self

class OpenLiveStreamDto(BaseModel):
    """
    Open live stream dto.
    """ # noqa: E501
    open_token: Optional[StrictStr] = Field(default=None, description="Gets or sets the open token.", alias="OpenToken")
    user_id: Optional[UUID] = Field(default=None, description="Gets or sets the user id.", alias="UserId")
    play_session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the play session id.", alias="PlaySessionId")
    max_streaming_bitrate: Optional[StrictInt] = Field(default=None, description="Gets or sets the max streaming bitrate.", alias="MaxStreamingBitrate")
    start_time_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the start time in ticks.", alias="StartTimeTicks")
    audio_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the audio stream index.", alias="AudioStreamIndex")
    subtitle_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the subtitle stream index.", alias="SubtitleStreamIndex")
    max_audio_channels: Optional[StrictInt] = Field(default=None, description="Gets or sets the max audio channels.", alias="MaxAudioChannels")
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the item id.", alias="ItemId")
    enable_direct_play: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to enable direct play.", alias="EnableDirectPlay")
    enable_direct_stream: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to enale direct stream.", alias="EnableDirectStream")
    always_burn_in_subtitle_when_transcoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether always burn in subtitles when transcoding.", alias="AlwaysBurnInSubtitleWhenTranscoding")
    device_profile: Optional[DeviceProfile] = Field(default=None, alias="DeviceProfile")
    direct_play_protocols: Optional[List[MediaProtocol]] = Field(default=None, description="Gets or sets the device play protocols.", alias="DirectPlayProtocols")
    __properties: ClassVar[List[str]] = ["OpenToken", "UserId", "PlaySessionId", "MaxStreamingBitrate", "StartTimeTicks", "AudioStreamIndex", "SubtitleStreamIndex", "MaxAudioChannels", "ItemId", "EnableDirectPlay", "EnableDirectStream", "AlwaysBurnInSubtitleWhenTranscoding", "DeviceProfile", "DirectPlayProtocols"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OpenLiveStreamDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of device_profile
        if self.device_profile:
            _dict['DeviceProfile'] = self.device_profile.to_dict()
        # set to None if open_token (nullable) is None
        # and model_fields_set contains the field
        if self.open_token is None and "open_token" in self.model_fields_set:
            _dict['OpenToken'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['UserId'] = None

        # set to None if play_session_id (nullable) is None
        # and model_fields_set contains the field
        if self.play_session_id is None and "play_session_id" in self.model_fields_set:
            _dict['PlaySessionId'] = None

        # set to None if max_streaming_bitrate (nullable) is None
        # and model_fields_set contains the field
        if self.max_streaming_bitrate is None and "max_streaming_bitrate" in self.model_fields_set:
            _dict['MaxStreamingBitrate'] = None

        # set to None if start_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.start_time_ticks is None and "start_time_ticks" in self.model_fields_set:
            _dict['StartTimeTicks'] = None

        # set to None if audio_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.audio_stream_index is None and "audio_stream_index" in self.model_fields_set:
            _dict['AudioStreamIndex'] = None

        # set to None if subtitle_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_stream_index is None and "subtitle_stream_index" in self.model_fields_set:
            _dict['SubtitleStreamIndex'] = None

        # set to None if max_audio_channels (nullable) is None
        # and model_fields_set contains the field
        if self.max_audio_channels is None and "max_audio_channels" in self.model_fields_set:
            _dict['MaxAudioChannels'] = None

        # set to None if item_id (nullable) is None
        # and model_fields_set contains the field
        if self.item_id is None and "item_id" in self.model_fields_set:
            _dict['ItemId'] = None

        # set to None if enable_direct_play (nullable) is None
        # and model_fields_set contains the field
        if self.enable_direct_play is None and "enable_direct_play" in self.model_fields_set:
            _dict['EnableDirectPlay'] = None

        # set to None if enable_direct_stream (nullable) is None
        # and model_fields_set contains the field
        if self.enable_direct_stream is None and "enable_direct_stream" in self.model_fields_set:
            _dict['EnableDirectStream'] = None

        # set to None if always_burn_in_subtitle_when_transcoding (nullable) is None
        # and model_fields_set contains the field
        if self.always_burn_in_subtitle_when_transcoding is None and "always_burn_in_subtitle_when_transcoding" in self.model_fields_set:
            _dict['AlwaysBurnInSubtitleWhenTranscoding'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OpenLiveStreamDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "OpenToken": obj.get("OpenToken"),
            "UserId": obj.get("UserId"),
            "PlaySessionId": obj.get("PlaySessionId"),
            "MaxStreamingBitrate": obj.get("MaxStreamingBitrate"),
            "StartTimeTicks": obj.get("StartTimeTicks"),
            "AudioStreamIndex": obj.get("AudioStreamIndex"),
            "SubtitleStreamIndex": obj.get("SubtitleStreamIndex"),
            "MaxAudioChannels": obj.get("MaxAudioChannels"),
            "ItemId": obj.get("ItemId"),
            "EnableDirectPlay": obj.get("EnableDirectPlay"),
            "EnableDirectStream": obj.get("EnableDirectStream"),
            "AlwaysBurnInSubtitleWhenTranscoding": obj.get("AlwaysBurnInSubtitleWhenTranscoding"),
            "DeviceProfile": DeviceProfile.from_dict(obj["DeviceProfile"]) if obj.get("DeviceProfile") is not None else None,
            "DirectPlayProtocols": obj.get("DirectPlayProtocols")
        })
        return _obj


