# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.play_command import PlayCommand
from typing import Optional, Set
from typing_extensions import Self

class PlayRequest(BaseModel):
    """
    Class PlayRequest.
    """ # noqa: E501
    item_ids: Optional[List[UUID]] = Field(default=None, description="Gets or sets the item ids.", alias="ItemIds")
    start_position_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the start position ticks that the first item should be played at.", alias="StartPositionTicks")
    play_command: Optional[PlayCommand] = Field(default=None, alias="PlayCommand")
    controlling_user_id: Optional[UUID] = Field(default=None, description="Gets or sets the controlling user identifier.", alias="ControllingUserId")
    subtitle_stream_index: Optional[StrictInt] = Field(default=None, alias="SubtitleStreamIndex")
    audio_stream_index: Optional[StrictInt] = Field(default=None, alias="AudioStreamIndex")
    media_source_id: Optional[StrictStr] = Field(default=None, alias="MediaSourceId")
    start_index: Optional[StrictInt] = Field(default=None, alias="StartIndex")
    __properties: ClassVar[List[str]] = ["ItemIds", "StartPositionTicks", "PlayCommand", "ControllingUserId", "SubtitleStreamIndex", "AudioStreamIndex", "MediaSourceId", "StartIndex"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlayRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if item_ids (nullable) is None
        # and model_fields_set contains the field
        if self.item_ids is None and "item_ids" in self.model_fields_set:
            _dict['ItemIds'] = None

        # set to None if start_position_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.start_position_ticks is None and "start_position_ticks" in self.model_fields_set:
            _dict['StartPositionTicks'] = None

        # set to None if subtitle_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_stream_index is None and "subtitle_stream_index" in self.model_fields_set:
            _dict['SubtitleStreamIndex'] = None

        # set to None if audio_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.audio_stream_index is None and "audio_stream_index" in self.model_fields_set:
            _dict['AudioStreamIndex'] = None

        # set to None if media_source_id (nullable) is None
        # and model_fields_set contains the field
        if self.media_source_id is None and "media_source_id" in self.model_fields_set:
            _dict['MediaSourceId'] = None

        # set to None if start_index (nullable) is None
        # and model_fields_set contains the field
        if self.start_index is None and "start_index" in self.model_fields_set:
            _dict['StartIndex'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlayRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ItemIds": obj.get("ItemIds"),
            "StartPositionTicks": obj.get("StartPositionTicks"),
            "PlayCommand": obj.get("PlayCommand"),
            "ControllingUserId": obj.get("ControllingUserId"),
            "SubtitleStreamIndex": obj.get("SubtitleStreamIndex"),
            "AudioStreamIndex": obj.get("AudioStreamIndex"),
            "MediaSourceId": obj.get("MediaSourceId"),
            "StartIndex": obj.get("StartIndex")
        })
        return _obj


