# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.media_source_info import MediaSourceInfo
from jellyfin.generated.api_10_10.models.playback_error_code import PlaybackErrorCode
from typing import Optional, Set
from typing_extensions import Self

class PlaybackInfoResponse(BaseModel):
    """
    Class PlaybackInfoResponse.
    """ # noqa: E501
    media_sources: Optional[List[MediaSourceInfo]] = Field(default=None, description="Gets or sets the media sources.", alias="MediaSources")
    play_session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the play session identifier.", alias="PlaySessionId")
    error_code: Optional[PlaybackErrorCode] = Field(default=None, alias="ErrorCode")
    __properties: ClassVar[List[str]] = ["MediaSources", "PlaySessionId", "ErrorCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaybackInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in media_sources (list)
        _items = []
        if self.media_sources:
            for _item_media_sources in self.media_sources:
                if _item_media_sources:
                    _items.append(_item_media_sources.to_dict())
            _dict['MediaSources'] = _items
        # set to None if play_session_id (nullable) is None
        # and model_fields_set contains the field
        if self.play_session_id is None and "play_session_id" in self.model_fields_set:
            _dict['PlaySessionId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaybackInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "MediaSources": [MediaSourceInfo.from_dict(_item) for _item in obj["MediaSources"]] if obj.get("MediaSources") is not None else None,
            "PlaySessionId": obj.get("PlaySessionId"),
            "ErrorCode": obj.get("ErrorCode")
        })
        return _obj


