# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_dto import BaseItemDto
from jellyfin.generated.api_10_10.models.play_method import PlayMethod
from jellyfin.generated.api_10_10.models.playback_order import PlaybackOrder
from jellyfin.generated.api_10_10.models.queue_item import QueueItem
from jellyfin.generated.api_10_10.models.repeat_mode import RepeatMode
from typing import Optional, Set
from typing_extensions import Self

class PlaybackProgressInfo(BaseModel):
    """
    Class PlaybackProgressInfo.
    """ # noqa: E501
    can_seek: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance can seek.", alias="CanSeek")
    item: Optional[BaseItemDto] = Field(default=None, alias="Item")
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the item identifier.", alias="ItemId")
    session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the session id.", alias="SessionId")
    media_source_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the media version identifier.", alias="MediaSourceId")
    audio_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the index of the audio stream.", alias="AudioStreamIndex")
    subtitle_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the index of the subtitle stream.", alias="SubtitleStreamIndex")
    is_paused: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is paused.", alias="IsPaused")
    is_muted: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is muted.", alias="IsMuted")
    position_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the position ticks.", alias="PositionTicks")
    playback_start_time_ticks: Optional[StrictInt] = Field(default=None, alias="PlaybackStartTimeTicks")
    volume_level: Optional[StrictInt] = Field(default=None, description="Gets or sets the volume level.", alias="VolumeLevel")
    brightness: Optional[StrictInt] = Field(default=None, alias="Brightness")
    aspect_ratio: Optional[StrictStr] = Field(default=None, alias="AspectRatio")
    play_method: Optional[PlayMethod] = Field(default=None, alias="PlayMethod")
    live_stream_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the live stream identifier.", alias="LiveStreamId")
    play_session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the play session identifier.", alias="PlaySessionId")
    repeat_mode: Optional[RepeatMode] = Field(default=None, alias="RepeatMode")
    playback_order: Optional[PlaybackOrder] = Field(default=None, alias="PlaybackOrder")
    now_playing_queue: Optional[List[QueueItem]] = Field(default=None, alias="NowPlayingQueue")
    playlist_item_id: Optional[StrictStr] = Field(default=None, alias="PlaylistItemId")
    __properties: ClassVar[List[str]] = ["CanSeek", "Item", "ItemId", "SessionId", "MediaSourceId", "AudioStreamIndex", "SubtitleStreamIndex", "IsPaused", "IsMuted", "PositionTicks", "PlaybackStartTimeTicks", "VolumeLevel", "Brightness", "AspectRatio", "PlayMethod", "LiveStreamId", "PlaySessionId", "RepeatMode", "PlaybackOrder", "NowPlayingQueue", "PlaylistItemId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaybackProgressInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of item
        if self.item:
            _dict['Item'] = self.item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in now_playing_queue (list)
        _items = []
        if self.now_playing_queue:
            for _item_now_playing_queue in self.now_playing_queue:
                if _item_now_playing_queue:
                    _items.append(_item_now_playing_queue.to_dict())
            _dict['NowPlayingQueue'] = _items
        # set to None if session_id (nullable) is None
        # and model_fields_set contains the field
        if self.session_id is None and "session_id" in self.model_fields_set:
            _dict['SessionId'] = None

        # set to None if media_source_id (nullable) is None
        # and model_fields_set contains the field
        if self.media_source_id is None and "media_source_id" in self.model_fields_set:
            _dict['MediaSourceId'] = None

        # set to None if audio_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.audio_stream_index is None and "audio_stream_index" in self.model_fields_set:
            _dict['AudioStreamIndex'] = None

        # set to None if subtitle_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_stream_index is None and "subtitle_stream_index" in self.model_fields_set:
            _dict['SubtitleStreamIndex'] = None

        # set to None if position_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.position_ticks is None and "position_ticks" in self.model_fields_set:
            _dict['PositionTicks'] = None

        # set to None if playback_start_time_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.playback_start_time_ticks is None and "playback_start_time_ticks" in self.model_fields_set:
            _dict['PlaybackStartTimeTicks'] = None

        # set to None if volume_level (nullable) is None
        # and model_fields_set contains the field
        if self.volume_level is None and "volume_level" in self.model_fields_set:
            _dict['VolumeLevel'] = None

        # set to None if brightness (nullable) is None
        # and model_fields_set contains the field
        if self.brightness is None and "brightness" in self.model_fields_set:
            _dict['Brightness'] = None

        # set to None if aspect_ratio (nullable) is None
        # and model_fields_set contains the field
        if self.aspect_ratio is None and "aspect_ratio" in self.model_fields_set:
            _dict['AspectRatio'] = None

        # set to None if live_stream_id (nullable) is None
        # and model_fields_set contains the field
        if self.live_stream_id is None and "live_stream_id" in self.model_fields_set:
            _dict['LiveStreamId'] = None

        # set to None if play_session_id (nullable) is None
        # and model_fields_set contains the field
        if self.play_session_id is None and "play_session_id" in self.model_fields_set:
            _dict['PlaySessionId'] = None

        # set to None if now_playing_queue (nullable) is None
        # and model_fields_set contains the field
        if self.now_playing_queue is None and "now_playing_queue" in self.model_fields_set:
            _dict['NowPlayingQueue'] = None

        # set to None if playlist_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.playlist_item_id is None and "playlist_item_id" in self.model_fields_set:
            _dict['PlaylistItemId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaybackProgressInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "CanSeek": obj.get("CanSeek"),
            "Item": BaseItemDto.from_dict(obj["Item"]) if obj.get("Item") is not None else None,
            "ItemId": obj.get("ItemId"),
            "SessionId": obj.get("SessionId"),
            "MediaSourceId": obj.get("MediaSourceId"),
            "AudioStreamIndex": obj.get("AudioStreamIndex"),
            "SubtitleStreamIndex": obj.get("SubtitleStreamIndex"),
            "IsPaused": obj.get("IsPaused"),
            "IsMuted": obj.get("IsMuted"),
            "PositionTicks": obj.get("PositionTicks"),
            "PlaybackStartTimeTicks": obj.get("PlaybackStartTimeTicks"),
            "VolumeLevel": obj.get("VolumeLevel"),
            "Brightness": obj.get("Brightness"),
            "AspectRatio": obj.get("AspectRatio"),
            "PlayMethod": obj.get("PlayMethod"),
            "LiveStreamId": obj.get("LiveStreamId"),
            "PlaySessionId": obj.get("PlaySessionId"),
            "RepeatMode": obj.get("RepeatMode"),
            "PlaybackOrder": obj.get("PlaybackOrder"),
            "NowPlayingQueue": [QueueItem.from_dict(_item) for _item in obj["NowPlayingQueue"]] if obj.get("NowPlayingQueue") is not None else None,
            "PlaylistItemId": obj.get("PlaylistItemId")
        })
        return _obj


