# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_dto import BaseItemDto
from jellyfin.generated.api_10_10.models.queue_item import QueueItem
from typing import Optional, Set
from typing_extensions import Self

class PlaybackStopInfo(BaseModel):
    """
    Class PlaybackStopInfo.
    """ # noqa: E501
    item: Optional[BaseItemDto] = Field(default=None, alias="Item")
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the item identifier.", alias="ItemId")
    session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the session id.", alias="SessionId")
    media_source_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the media version identifier.", alias="MediaSourceId")
    position_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the position ticks.", alias="PositionTicks")
    live_stream_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the live stream identifier.", alias="LiveStreamId")
    play_session_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the play session identifier.", alias="PlaySessionId")
    failed: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this MediaBrowser.Model.Session.PlaybackStopInfo is failed.", alias="Failed")
    next_media_type: Optional[StrictStr] = Field(default=None, alias="NextMediaType")
    playlist_item_id: Optional[StrictStr] = Field(default=None, alias="PlaylistItemId")
    now_playing_queue: Optional[List[QueueItem]] = Field(default=None, alias="NowPlayingQueue")
    __properties: ClassVar[List[str]] = ["Item", "ItemId", "SessionId", "MediaSourceId", "PositionTicks", "LiveStreamId", "PlaySessionId", "Failed", "NextMediaType", "PlaylistItemId", "NowPlayingQueue"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlaybackStopInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of item
        if self.item:
            _dict['Item'] = self.item.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in now_playing_queue (list)
        _items = []
        if self.now_playing_queue:
            for _item_now_playing_queue in self.now_playing_queue:
                if _item_now_playing_queue:
                    _items.append(_item_now_playing_queue.to_dict())
            _dict['NowPlayingQueue'] = _items
        # set to None if session_id (nullable) is None
        # and model_fields_set contains the field
        if self.session_id is None and "session_id" in self.model_fields_set:
            _dict['SessionId'] = None

        # set to None if media_source_id (nullable) is None
        # and model_fields_set contains the field
        if self.media_source_id is None and "media_source_id" in self.model_fields_set:
            _dict['MediaSourceId'] = None

        # set to None if position_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.position_ticks is None and "position_ticks" in self.model_fields_set:
            _dict['PositionTicks'] = None

        # set to None if live_stream_id (nullable) is None
        # and model_fields_set contains the field
        if self.live_stream_id is None and "live_stream_id" in self.model_fields_set:
            _dict['LiveStreamId'] = None

        # set to None if play_session_id (nullable) is None
        # and model_fields_set contains the field
        if self.play_session_id is None and "play_session_id" in self.model_fields_set:
            _dict['PlaySessionId'] = None

        # set to None if next_media_type (nullable) is None
        # and model_fields_set contains the field
        if self.next_media_type is None and "next_media_type" in self.model_fields_set:
            _dict['NextMediaType'] = None

        # set to None if playlist_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.playlist_item_id is None and "playlist_item_id" in self.model_fields_set:
            _dict['PlaylistItemId'] = None

        # set to None if now_playing_queue (nullable) is None
        # and model_fields_set contains the field
        if self.now_playing_queue is None and "now_playing_queue" in self.model_fields_set:
            _dict['NowPlayingQueue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlaybackStopInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Item": BaseItemDto.from_dict(obj["Item"]) if obj.get("Item") is not None else None,
            "ItemId": obj.get("ItemId"),
            "SessionId": obj.get("SessionId"),
            "MediaSourceId": obj.get("MediaSourceId"),
            "PositionTicks": obj.get("PositionTicks"),
            "LiveStreamId": obj.get("LiveStreamId"),
            "PlaySessionId": obj.get("PlaySessionId"),
            "Failed": obj.get("Failed"),
            "NextMediaType": obj.get("NextMediaType"),
            "PlaylistItemId": obj.get("PlaylistItemId"),
            "NowPlayingQueue": [QueueItem.from_dict(_item) for _item in obj["NowPlayingQueue"]] if obj.get("NowPlayingQueue") is not None else None
        })
        return _obj


