# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.play_method import PlayMethod
from jellyfin.generated.api_10_10.models.playback_order import PlaybackOrder
from jellyfin.generated.api_10_10.models.repeat_mode import RepeatMode
from typing import Optional, Set
from typing_extensions import Self

class PlayerStateInfo(BaseModel):
    """
    PlayerStateInfo
    """ # noqa: E501
    position_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the now playing position ticks.", alias="PositionTicks")
    can_seek: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance can seek.", alias="CanSeek")
    is_paused: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is paused.", alias="IsPaused")
    is_muted: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is muted.", alias="IsMuted")
    volume_level: Optional[StrictInt] = Field(default=None, description="Gets or sets the volume level.", alias="VolumeLevel")
    audio_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the index of the now playing audio stream.", alias="AudioStreamIndex")
    subtitle_stream_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the index of the now playing subtitle stream.", alias="SubtitleStreamIndex")
    media_source_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the now playing media version identifier.", alias="MediaSourceId")
    play_method: Optional[PlayMethod] = Field(default=None, alias="PlayMethod")
    repeat_mode: Optional[RepeatMode] = Field(default=None, alias="RepeatMode")
    playback_order: Optional[PlaybackOrder] = Field(default=None, alias="PlaybackOrder")
    live_stream_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the now playing live stream identifier.", alias="LiveStreamId")
    __properties: ClassVar[List[str]] = ["PositionTicks", "CanSeek", "IsPaused", "IsMuted", "VolumeLevel", "AudioStreamIndex", "SubtitleStreamIndex", "MediaSourceId", "PlayMethod", "RepeatMode", "PlaybackOrder", "LiveStreamId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PlayerStateInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if position_ticks (nullable) is None
        # and model_fields_set contains the field
        if self.position_ticks is None and "position_ticks" in self.model_fields_set:
            _dict['PositionTicks'] = None

        # set to None if volume_level (nullable) is None
        # and model_fields_set contains the field
        if self.volume_level is None and "volume_level" in self.model_fields_set:
            _dict['VolumeLevel'] = None

        # set to None if audio_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.audio_stream_index is None and "audio_stream_index" in self.model_fields_set:
            _dict['AudioStreamIndex'] = None

        # set to None if subtitle_stream_index (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_stream_index is None and "subtitle_stream_index" in self.model_fields_set:
            _dict['SubtitleStreamIndex'] = None

        # set to None if media_source_id (nullable) is None
        # and model_fields_set contains the field
        if self.media_source_id is None and "media_source_id" in self.model_fields_set:
            _dict['MediaSourceId'] = None

        # set to None if live_stream_id (nullable) is None
        # and model_fields_set contains the field
        if self.live_stream_id is None and "live_stream_id" in self.model_fields_set:
            _dict['LiveStreamId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PlayerStateInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PositionTicks": obj.get("PositionTicks"),
            "CanSeek": obj.get("CanSeek"),
            "IsPaused": obj.get("IsPaused"),
            "IsMuted": obj.get("IsMuted"),
            "VolumeLevel": obj.get("VolumeLevel"),
            "AudioStreamIndex": obj.get("AudioStreamIndex"),
            "SubtitleStreamIndex": obj.get("SubtitleStreamIndex"),
            "MediaSourceId": obj.get("MediaSourceId"),
            "PlayMethod": obj.get("PlayMethod"),
            "RepeatMode": obj.get("RepeatMode"),
            "PlaybackOrder": obj.get("PlaybackOrder"),
            "LiveStreamId": obj.get("LiveStreamId")
        })
        return _obj


