# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.base_item_dto import BaseItemDto
from jellyfin.generated.api_10_10.models.recommendation_type import RecommendationType
from typing import Optional, Set
from typing_extensions import Self

class RecommendationDto(BaseModel):
    """
    RecommendationDto
    """ # noqa: E501
    items: Optional[List[BaseItemDto]] = Field(default=None, alias="Items")
    recommendation_type: Optional[RecommendationType] = Field(default=None, alias="RecommendationType")
    baseline_item_name: Optional[StrictStr] = Field(default=None, alias="BaselineItemName")
    category_id: Optional[UUID] = Field(default=None, alias="CategoryId")
    __properties: ClassVar[List[str]] = ["Items", "RecommendationType", "BaselineItemName", "CategoryId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RecommendationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['Items'] = _items
        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['Items'] = None

        # set to None if baseline_item_name (nullable) is None
        # and model_fields_set contains the field
        if self.baseline_item_name is None and "baseline_item_name" in self.model_fields_set:
            _dict['BaselineItemName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RecommendationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Items": [BaseItemDto.from_dict(_item) for _item in obj["Items"]] if obj.get("Items") is not None else None,
            "RecommendationType": obj.get("RecommendationType"),
            "BaselineItemName": obj.get("BaselineItemName"),
            "CategoryId": obj.get("CategoryId")
        })
        return _obj


