# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.day_of_week import DayOfWeek
from jellyfin.generated.api_10_10.models.day_pattern import DayPattern
from jellyfin.generated.api_10_10.models.keep_until import KeepUntil
from typing import Optional, Set
from typing_extensions import Self

class SeriesTimerInfoDto(BaseModel):
    """
    Class SeriesTimerInfoDto.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the Id of the recording.", alias="Id")
    type: Optional[StrictStr] = Field(default=None, alias="Type")
    server_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the server identifier.", alias="ServerId")
    external_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the external identifier.", alias="ExternalId")
    channel_id: Optional[UUID] = Field(default=None, description="Gets or sets the channel id of the recording.", alias="ChannelId")
    external_channel_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the external channel identifier.", alias="ExternalChannelId")
    channel_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the channel name of the recording.", alias="ChannelName")
    channel_primary_image_tag: Optional[StrictStr] = Field(default=None, alias="ChannelPrimaryImageTag")
    program_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the program identifier.", alias="ProgramId")
    external_program_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the external program identifier.", alias="ExternalProgramId")
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the recording.", alias="Name")
    overview: Optional[StrictStr] = Field(default=None, description="Gets or sets the description of the recording.", alias="Overview")
    start_date: Optional[datetime] = Field(default=None, description="Gets or sets the start date of the recording, in UTC.", alias="StartDate")
    end_date: Optional[datetime] = Field(default=None, description="Gets or sets the end date of the recording, in UTC.", alias="EndDate")
    service_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the service.", alias="ServiceName")
    priority: Optional[StrictInt] = Field(default=None, description="Gets or sets the priority.", alias="Priority")
    pre_padding_seconds: Optional[StrictInt] = Field(default=None, description="Gets or sets the pre padding seconds.", alias="PrePaddingSeconds")
    post_padding_seconds: Optional[StrictInt] = Field(default=None, description="Gets or sets the post padding seconds.", alias="PostPaddingSeconds")
    is_pre_padding_required: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is pre padding required.", alias="IsPrePaddingRequired")
    parent_backdrop_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the Id of the Parent that has a backdrop if the item does not have one.", alias="ParentBackdropItemId")
    parent_backdrop_image_tags: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the parent backdrop image tags.", alias="ParentBackdropImageTags")
    is_post_padding_required: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is post padding required.", alias="IsPostPaddingRequired")
    keep_until: Optional[KeepUntil] = Field(default=None, alias="KeepUntil")
    record_any_time: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [record any time].", alias="RecordAnyTime")
    skip_episodes_in_library: Optional[StrictBool] = Field(default=None, alias="SkipEpisodesInLibrary")
    record_any_channel: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [record any channel].", alias="RecordAnyChannel")
    keep_up_to: Optional[StrictInt] = Field(default=None, alias="KeepUpTo")
    record_new_only: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [record new only].", alias="RecordNewOnly")
    days: Optional[List[DayOfWeek]] = Field(default=None, description="Gets or sets the days.", alias="Days")
    day_pattern: Optional[DayPattern] = Field(default=None, alias="DayPattern")
    image_tags: Optional[Dict[str, StrictStr]] = Field(default=None, description="Gets or sets the image tags.", alias="ImageTags")
    parent_thumb_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent thumb item id.", alias="ParentThumbItemId")
    parent_thumb_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent thumb image tag.", alias="ParentThumbImageTag")
    parent_primary_image_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent primary image item identifier.", alias="ParentPrimaryImageItemId")
    parent_primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the parent primary image tag.", alias="ParentPrimaryImageTag")
    __properties: ClassVar[List[str]] = ["Id", "Type", "ServerId", "ExternalId", "ChannelId", "ExternalChannelId", "ChannelName", "ChannelPrimaryImageTag", "ProgramId", "ExternalProgramId", "Name", "Overview", "StartDate", "EndDate", "ServiceName", "Priority", "PrePaddingSeconds", "PostPaddingSeconds", "IsPrePaddingRequired", "ParentBackdropItemId", "ParentBackdropImageTags", "IsPostPaddingRequired", "KeepUntil", "RecordAnyTime", "SkipEpisodesInLibrary", "RecordAnyChannel", "KeepUpTo", "RecordNewOnly", "Days", "DayPattern", "ImageTags", "ParentThumbItemId", "ParentThumbImageTag", "ParentPrimaryImageItemId", "ParentPrimaryImageTag"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SeriesTimerInfoDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['Type'] = None

        # set to None if server_id (nullable) is None
        # and model_fields_set contains the field
        if self.server_id is None and "server_id" in self.model_fields_set:
            _dict['ServerId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['ExternalId'] = None

        # set to None if external_channel_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_channel_id is None and "external_channel_id" in self.model_fields_set:
            _dict['ExternalChannelId'] = None

        # set to None if channel_name (nullable) is None
        # and model_fields_set contains the field
        if self.channel_name is None and "channel_name" in self.model_fields_set:
            _dict['ChannelName'] = None

        # set to None if channel_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.channel_primary_image_tag is None and "channel_primary_image_tag" in self.model_fields_set:
            _dict['ChannelPrimaryImageTag'] = None

        # set to None if program_id (nullable) is None
        # and model_fields_set contains the field
        if self.program_id is None and "program_id" in self.model_fields_set:
            _dict['ProgramId'] = None

        # set to None if external_program_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_program_id is None and "external_program_id" in self.model_fields_set:
            _dict['ExternalProgramId'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if overview (nullable) is None
        # and model_fields_set contains the field
        if self.overview is None and "overview" in self.model_fields_set:
            _dict['Overview'] = None

        # set to None if service_name (nullable) is None
        # and model_fields_set contains the field
        if self.service_name is None and "service_name" in self.model_fields_set:
            _dict['ServiceName'] = None

        # set to None if parent_backdrop_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_backdrop_item_id is None and "parent_backdrop_item_id" in self.model_fields_set:
            _dict['ParentBackdropItemId'] = None

        # set to None if parent_backdrop_image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.parent_backdrop_image_tags is None and "parent_backdrop_image_tags" in self.model_fields_set:
            _dict['ParentBackdropImageTags'] = None

        # set to None if days (nullable) is None
        # and model_fields_set contains the field
        if self.days is None and "days" in self.model_fields_set:
            _dict['Days'] = None

        # set to None if image_tags (nullable) is None
        # and model_fields_set contains the field
        if self.image_tags is None and "image_tags" in self.model_fields_set:
            _dict['ImageTags'] = None

        # set to None if parent_thumb_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_thumb_item_id is None and "parent_thumb_item_id" in self.model_fields_set:
            _dict['ParentThumbItemId'] = None

        # set to None if parent_thumb_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_thumb_image_tag is None and "parent_thumb_image_tag" in self.model_fields_set:
            _dict['ParentThumbImageTag'] = None

        # set to None if parent_primary_image_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_primary_image_item_id is None and "parent_primary_image_item_id" in self.model_fields_set:
            _dict['ParentPrimaryImageItemId'] = None

        # set to None if parent_primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.parent_primary_image_tag is None and "parent_primary_image_tag" in self.model_fields_set:
            _dict['ParentPrimaryImageTag'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SeriesTimerInfoDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Id": obj.get("Id"),
            "Type": obj.get("Type"),
            "ServerId": obj.get("ServerId"),
            "ExternalId": obj.get("ExternalId"),
            "ChannelId": obj.get("ChannelId"),
            "ExternalChannelId": obj.get("ExternalChannelId"),
            "ChannelName": obj.get("ChannelName"),
            "ChannelPrimaryImageTag": obj.get("ChannelPrimaryImageTag"),
            "ProgramId": obj.get("ProgramId"),
            "ExternalProgramId": obj.get("ExternalProgramId"),
            "Name": obj.get("Name"),
            "Overview": obj.get("Overview"),
            "StartDate": obj.get("StartDate"),
            "EndDate": obj.get("EndDate"),
            "ServiceName": obj.get("ServiceName"),
            "Priority": obj.get("Priority"),
            "PrePaddingSeconds": obj.get("PrePaddingSeconds"),
            "PostPaddingSeconds": obj.get("PostPaddingSeconds"),
            "IsPrePaddingRequired": obj.get("IsPrePaddingRequired"),
            "ParentBackdropItemId": obj.get("ParentBackdropItemId"),
            "ParentBackdropImageTags": obj.get("ParentBackdropImageTags"),
            "IsPostPaddingRequired": obj.get("IsPostPaddingRequired"),
            "KeepUntil": obj.get("KeepUntil"),
            "RecordAnyTime": obj.get("RecordAnyTime"),
            "SkipEpisodesInLibrary": obj.get("SkipEpisodesInLibrary"),
            "RecordAnyChannel": obj.get("RecordAnyChannel"),
            "KeepUpTo": obj.get("KeepUpTo"),
            "RecordNewOnly": obj.get("RecordNewOnly"),
            "Days": obj.get("Days"),
            "DayPattern": obj.get("DayPattern"),
            "ImageTags": obj.get("ImageTags"),
            "ParentThumbItemId": obj.get("ParentThumbItemId"),
            "ParentThumbImageTag": obj.get("ParentThumbImageTag"),
            "ParentPrimaryImageItemId": obj.get("ParentPrimaryImageItemId"),
            "ParentPrimaryImageTag": obj.get("ParentPrimaryImageTag")
        })
        return _obj


