# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.subtitle_delivery_method import SubtitleDeliveryMethod
from typing import Optional, Set
from typing_extensions import Self

class SubtitleProfile(BaseModel):
    """
    A class for subtitle profile information.
    """ # noqa: E501
    format: Optional[StrictStr] = Field(default=None, description="Gets or sets the format.", alias="Format")
    method: Optional[SubtitleDeliveryMethod] = Field(default=None, alias="Method")
    didl_mode: Optional[StrictStr] = Field(default=None, description="Gets or sets the DIDL mode.", alias="DidlMode")
    language: Optional[StrictStr] = Field(default=None, description="Gets or sets the language.", alias="Language")
    container: Optional[StrictStr] = Field(default=None, description="Gets or sets the container.", alias="Container")
    __properties: ClassVar[List[str]] = ["Format", "Method", "DidlMode", "Language", "Container"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubtitleProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if format (nullable) is None
        # and model_fields_set contains the field
        if self.format is None and "format" in self.model_fields_set:
            _dict['Format'] = None

        # set to None if didl_mode (nullable) is None
        # and model_fields_set contains the field
        if self.didl_mode is None and "didl_mode" in self.model_fields_set:
            _dict['DidlMode'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['Language'] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict['Container'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubtitleProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Format": obj.get("Format"),
            "Method": obj.get("Method"),
            "DidlMode": obj.get("DidlMode"),
            "Language": obj.get("Language"),
            "Container": obj.get("Container")
        })
        return _obj


