# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.cast_receiver_application import CastReceiverApplication
from jellyfin.generated.api_10_10.models.installation_info import InstallationInfo
from typing import Optional, Set
from typing_extensions import Self

class SystemInfo(BaseModel):
    """
    Class SystemInfo.
    """ # noqa: E501
    local_address: Optional[StrictStr] = Field(default=None, description="Gets or sets the local address.", alias="LocalAddress")
    server_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name of the server.", alias="ServerName")
    version: Optional[StrictStr] = Field(default=None, description="Gets or sets the server version.", alias="Version")
    product_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the product name. This is the AssemblyProduct name.", alias="ProductName")
    operating_system: Optional[StrictStr] = Field(default=None, description="Gets or sets the operating system.", alias="OperatingSystem")
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the id.", alias="Id")
    startup_wizard_completed: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether the startup wizard is completed.", alias="StartupWizardCompleted")
    operating_system_display_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the display name of the operating system.", alias="OperatingSystemDisplayName")
    package_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the package name.", alias="PackageName")
    has_pending_restart: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance has pending restart.", alias="HasPendingRestart")
    is_shutting_down: Optional[StrictBool] = Field(default=None, alias="IsShuttingDown")
    supports_library_monitor: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [supports library monitor].", alias="SupportsLibraryMonitor")
    web_socket_port_number: Optional[StrictInt] = Field(default=None, description="Gets or sets the web socket port number.", alias="WebSocketPortNumber")
    completed_installations: Optional[List[InstallationInfo]] = Field(default=None, description="Gets or sets the completed installations.", alias="CompletedInstallations")
    can_self_restart: Optional[StrictBool] = Field(default=True, description="Gets or sets a value indicating whether this instance can self restart.", alias="CanSelfRestart")
    can_launch_web_browser: Optional[StrictBool] = Field(default=False, alias="CanLaunchWebBrowser")
    program_data_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the program data path.", alias="ProgramDataPath")
    web_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the web UI resources path.", alias="WebPath")
    items_by_name_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the items by name path.", alias="ItemsByNamePath")
    cache_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the cache path.", alias="CachePath")
    log_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the log path.", alias="LogPath")
    internal_metadata_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the internal metadata path.", alias="InternalMetadataPath")
    transcoding_temp_path: Optional[StrictStr] = Field(default=None, description="Gets or sets the transcode path.", alias="TranscodingTempPath")
    cast_receiver_applications: Optional[List[CastReceiverApplication]] = Field(default=None, description="Gets or sets the list of cast receiver applications.", alias="CastReceiverApplications")
    has_update_available: Optional[StrictBool] = Field(default=False, description="Gets or sets a value indicating whether this instance has update available.", alias="HasUpdateAvailable")
    encoder_location: Optional[StrictStr] = Field(default='System', alias="EncoderLocation")
    system_architecture: Optional[StrictStr] = Field(default='X64', alias="SystemArchitecture")
    __properties: ClassVar[List[str]] = ["LocalAddress", "ServerName", "Version", "ProductName", "OperatingSystem", "Id", "StartupWizardCompleted", "OperatingSystemDisplayName", "PackageName", "HasPendingRestart", "IsShuttingDown", "SupportsLibraryMonitor", "WebSocketPortNumber", "CompletedInstallations", "CanSelfRestart", "CanLaunchWebBrowser", "ProgramDataPath", "WebPath", "ItemsByNamePath", "CachePath", "LogPath", "InternalMetadataPath", "TranscodingTempPath", "CastReceiverApplications", "HasUpdateAvailable", "EncoderLocation", "SystemArchitecture"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SystemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in completed_installations (list)
        _items = []
        if self.completed_installations:
            for _item_completed_installations in self.completed_installations:
                if _item_completed_installations:
                    _items.append(_item_completed_installations.to_dict())
            _dict['CompletedInstallations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cast_receiver_applications (list)
        _items = []
        if self.cast_receiver_applications:
            for _item_cast_receiver_applications in self.cast_receiver_applications:
                if _item_cast_receiver_applications:
                    _items.append(_item_cast_receiver_applications.to_dict())
            _dict['CastReceiverApplications'] = _items
        # set to None if local_address (nullable) is None
        # and model_fields_set contains the field
        if self.local_address is None and "local_address" in self.model_fields_set:
            _dict['LocalAddress'] = None

        # set to None if server_name (nullable) is None
        # and model_fields_set contains the field
        if self.server_name is None and "server_name" in self.model_fields_set:
            _dict['ServerName'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['Version'] = None

        # set to None if product_name (nullable) is None
        # and model_fields_set contains the field
        if self.product_name is None and "product_name" in self.model_fields_set:
            _dict['ProductName'] = None

        # set to None if operating_system (nullable) is None
        # and model_fields_set contains the field
        if self.operating_system is None and "operating_system" in self.model_fields_set:
            _dict['OperatingSystem'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if startup_wizard_completed (nullable) is None
        # and model_fields_set contains the field
        if self.startup_wizard_completed is None and "startup_wizard_completed" in self.model_fields_set:
            _dict['StartupWizardCompleted'] = None

        # set to None if operating_system_display_name (nullable) is None
        # and model_fields_set contains the field
        if self.operating_system_display_name is None and "operating_system_display_name" in self.model_fields_set:
            _dict['OperatingSystemDisplayName'] = None

        # set to None if package_name (nullable) is None
        # and model_fields_set contains the field
        if self.package_name is None and "package_name" in self.model_fields_set:
            _dict['PackageName'] = None

        # set to None if completed_installations (nullable) is None
        # and model_fields_set contains the field
        if self.completed_installations is None and "completed_installations" in self.model_fields_set:
            _dict['CompletedInstallations'] = None

        # set to None if program_data_path (nullable) is None
        # and model_fields_set contains the field
        if self.program_data_path is None and "program_data_path" in self.model_fields_set:
            _dict['ProgramDataPath'] = None

        # set to None if web_path (nullable) is None
        # and model_fields_set contains the field
        if self.web_path is None and "web_path" in self.model_fields_set:
            _dict['WebPath'] = None

        # set to None if items_by_name_path (nullable) is None
        # and model_fields_set contains the field
        if self.items_by_name_path is None and "items_by_name_path" in self.model_fields_set:
            _dict['ItemsByNamePath'] = None

        # set to None if cache_path (nullable) is None
        # and model_fields_set contains the field
        if self.cache_path is None and "cache_path" in self.model_fields_set:
            _dict['CachePath'] = None

        # set to None if log_path (nullable) is None
        # and model_fields_set contains the field
        if self.log_path is None and "log_path" in self.model_fields_set:
            _dict['LogPath'] = None

        # set to None if internal_metadata_path (nullable) is None
        # and model_fields_set contains the field
        if self.internal_metadata_path is None and "internal_metadata_path" in self.model_fields_set:
            _dict['InternalMetadataPath'] = None

        # set to None if transcoding_temp_path (nullable) is None
        # and model_fields_set contains the field
        if self.transcoding_temp_path is None and "transcoding_temp_path" in self.model_fields_set:
            _dict['TranscodingTempPath'] = None

        # set to None if cast_receiver_applications (nullable) is None
        # and model_fields_set contains the field
        if self.cast_receiver_applications is None and "cast_receiver_applications" in self.model_fields_set:
            _dict['CastReceiverApplications'] = None

        # set to None if encoder_location (nullable) is None
        # and model_fields_set contains the field
        if self.encoder_location is None and "encoder_location" in self.model_fields_set:
            _dict['EncoderLocation'] = None

        # set to None if system_architecture (nullable) is None
        # and model_fields_set contains the field
        if self.system_architecture is None and "system_architecture" in self.model_fields_set:
            _dict['SystemArchitecture'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SystemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "LocalAddress": obj.get("LocalAddress"),
            "ServerName": obj.get("ServerName"),
            "Version": obj.get("Version"),
            "ProductName": obj.get("ProductName"),
            "OperatingSystem": obj.get("OperatingSystem"),
            "Id": obj.get("Id"),
            "StartupWizardCompleted": obj.get("StartupWizardCompleted"),
            "OperatingSystemDisplayName": obj.get("OperatingSystemDisplayName"),
            "PackageName": obj.get("PackageName"),
            "HasPendingRestart": obj.get("HasPendingRestart"),
            "IsShuttingDown": obj.get("IsShuttingDown"),
            "SupportsLibraryMonitor": obj.get("SupportsLibraryMonitor"),
            "WebSocketPortNumber": obj.get("WebSocketPortNumber"),
            "CompletedInstallations": [InstallationInfo.from_dict(_item) for _item in obj["CompletedInstallations"]] if obj.get("CompletedInstallations") is not None else None,
            "CanSelfRestart": obj.get("CanSelfRestart") if obj.get("CanSelfRestart") is not None else True,
            "CanLaunchWebBrowser": obj.get("CanLaunchWebBrowser") if obj.get("CanLaunchWebBrowser") is not None else False,
            "ProgramDataPath": obj.get("ProgramDataPath"),
            "WebPath": obj.get("WebPath"),
            "ItemsByNamePath": obj.get("ItemsByNamePath"),
            "CachePath": obj.get("CachePath"),
            "LogPath": obj.get("LogPath"),
            "InternalMetadataPath": obj.get("InternalMetadataPath"),
            "TranscodingTempPath": obj.get("TranscodingTempPath"),
            "CastReceiverApplications": [CastReceiverApplication.from_dict(_item) for _item in obj["CastReceiverApplications"]] if obj.get("CastReceiverApplications") is not None else None,
            "HasUpdateAvailable": obj.get("HasUpdateAvailable") if obj.get("HasUpdateAvailable") is not None else False,
            "EncoderLocation": obj.get("EncoderLocation") if obj.get("EncoderLocation") is not None else 'System',
            "SystemArchitecture": obj.get("SystemArchitecture") if obj.get("SystemArchitecture") is not None else 'X64'
        })
        return _obj


