# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_10.models.task_result import TaskResult
from jellyfin.generated.api_10_10.models.task_state import TaskState
from jellyfin.generated.api_10_10.models.task_trigger_info import TaskTriggerInfo
from typing import Optional, Set
from typing_extensions import Self

class TaskInfo(BaseModel):
    """
    Class TaskInfo.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    state: Optional[TaskState] = Field(default=None, alias="State")
    current_progress_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the progress.", alias="CurrentProgressPercentage")
    id: Optional[StrictStr] = Field(default=None, description="Gets or sets the id.", alias="Id")
    last_execution_result: Optional[TaskResult] = Field(default=None, alias="LastExecutionResult")
    triggers: Optional[List[TaskTriggerInfo]] = Field(default=None, description="Gets or sets the triggers.", alias="Triggers")
    description: Optional[StrictStr] = Field(default=None, description="Gets or sets the description.", alias="Description")
    category: Optional[StrictStr] = Field(default=None, description="Gets or sets the category.", alias="Category")
    is_hidden: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is hidden.", alias="IsHidden")
    key: Optional[StrictStr] = Field(default=None, description="Gets or sets the key.", alias="Key")
    __properties: ClassVar[List[str]] = ["Name", "State", "CurrentProgressPercentage", "Id", "LastExecutionResult", "Triggers", "Description", "Category", "IsHidden", "Key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_execution_result
        if self.last_execution_result:
            _dict['LastExecutionResult'] = self.last_execution_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in triggers (list)
        _items = []
        if self.triggers:
            for _item_triggers in self.triggers:
                if _item_triggers:
                    _items.append(_item_triggers.to_dict())
            _dict['Triggers'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if current_progress_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.current_progress_percentage is None and "current_progress_percentage" in self.model_fields_set:
            _dict['CurrentProgressPercentage'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['Id'] = None

        # set to None if triggers (nullable) is None
        # and model_fields_set contains the field
        if self.triggers is None and "triggers" in self.model_fields_set:
            _dict['Triggers'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['Description'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['Category'] = None

        # set to None if key (nullable) is None
        # and model_fields_set contains the field
        if self.key is None and "key" in self.model_fields_set:
            _dict['Key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "State": obj.get("State"),
            "CurrentProgressPercentage": obj.get("CurrentProgressPercentage"),
            "Id": obj.get("Id"),
            "LastExecutionResult": TaskResult.from_dict(obj["LastExecutionResult"]) if obj.get("LastExecutionResult") is not None else None,
            "Triggers": [TaskTriggerInfo.from_dict(_item) for _item in obj["Triggers"]] if obj.get("Triggers") is not None else None,
            "Description": obj.get("Description"),
            "Category": obj.get("Category"),
            "IsHidden": obj.get("IsHidden"),
            "Key": obj.get("Key")
        })
        return _obj


