# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TrailerInfo(BaseModel):
    """
    TrailerInfo
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    original_title: Optional[StrictStr] = Field(default=None, description="Gets or sets the original title.", alias="OriginalTitle")
    path: Optional[StrictStr] = Field(default=None, description="Gets or sets the path.", alias="Path")
    metadata_language: Optional[StrictStr] = Field(default=None, description="Gets or sets the metadata language.", alias="MetadataLanguage")
    metadata_country_code: Optional[StrictStr] = Field(default=None, description="Gets or sets the metadata country code.", alias="MetadataCountryCode")
    provider_ids: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="Gets or sets the provider ids.", alias="ProviderIds")
    year: Optional[StrictInt] = Field(default=None, description="Gets or sets the year.", alias="Year")
    index_number: Optional[StrictInt] = Field(default=None, alias="IndexNumber")
    parent_index_number: Optional[StrictInt] = Field(default=None, alias="ParentIndexNumber")
    premiere_date: Optional[datetime] = Field(default=None, alias="PremiereDate")
    is_automated: Optional[StrictBool] = Field(default=None, alias="IsAutomated")
    __properties: ClassVar[List[str]] = ["Name", "OriginalTitle", "Path", "MetadataLanguage", "MetadataCountryCode", "ProviderIds", "Year", "IndexNumber", "ParentIndexNumber", "PremiereDate", "IsAutomated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrailerInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if original_title (nullable) is None
        # and model_fields_set contains the field
        if self.original_title is None and "original_title" in self.model_fields_set:
            _dict['OriginalTitle'] = None

        # set to None if path (nullable) is None
        # and model_fields_set contains the field
        if self.path is None and "path" in self.model_fields_set:
            _dict['Path'] = None

        # set to None if metadata_language (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_language is None and "metadata_language" in self.model_fields_set:
            _dict['MetadataLanguage'] = None

        # set to None if metadata_country_code (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_country_code is None and "metadata_country_code" in self.model_fields_set:
            _dict['MetadataCountryCode'] = None

        # set to None if provider_ids (nullable) is None
        # and model_fields_set contains the field
        if self.provider_ids is None and "provider_ids" in self.model_fields_set:
            _dict['ProviderIds'] = None

        # set to None if year (nullable) is None
        # and model_fields_set contains the field
        if self.year is None and "year" in self.model_fields_set:
            _dict['Year'] = None

        # set to None if index_number (nullable) is None
        # and model_fields_set contains the field
        if self.index_number is None and "index_number" in self.model_fields_set:
            _dict['IndexNumber'] = None

        # set to None if parent_index_number (nullable) is None
        # and model_fields_set contains the field
        if self.parent_index_number is None and "parent_index_number" in self.model_fields_set:
            _dict['ParentIndexNumber'] = None

        # set to None if premiere_date (nullable) is None
        # and model_fields_set contains the field
        if self.premiere_date is None and "premiere_date" in self.model_fields_set:
            _dict['PremiereDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrailerInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "OriginalTitle": obj.get("OriginalTitle"),
            "Path": obj.get("Path"),
            "MetadataLanguage": obj.get("MetadataLanguage"),
            "MetadataCountryCode": obj.get("MetadataCountryCode"),
            "ProviderIds": obj.get("ProviderIds"),
            "Year": obj.get("Year"),
            "IndexNumber": obj.get("IndexNumber"),
            "ParentIndexNumber": obj.get("ParentIndexNumber"),
            "PremiereDate": obj.get("PremiereDate"),
            "IsAutomated": obj.get("IsAutomated")
        })
        return _obj


