# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_10.models.process_priority_class import ProcessPriorityClass
from jellyfin.generated.api_10_10.models.trickplay_scan_behavior import TrickplayScanBehavior
from typing import Optional, Set
from typing_extensions import Self

class TrickplayOptions(BaseModel):
    """
    Class TrickplayOptions.
    """ # noqa: E501
    enable_hw_acceleration: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether or not to use HW acceleration.", alias="EnableHwAcceleration")
    enable_hw_encoding: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether or not to use HW accelerated MJPEG encoding.", alias="EnableHwEncoding")
    enable_key_frame_only_extraction: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether to only extract key frames.  Significantly faster, but is not compatible with all decoders and/or video files.", alias="EnableKeyFrameOnlyExtraction")
    scan_behavior: Optional[TrickplayScanBehavior] = Field(default=None, alias="ScanBehavior")
    process_priority: Optional[ProcessPriorityClass] = Field(default=None, alias="ProcessPriority")
    interval: Optional[StrictInt] = Field(default=None, description="Gets or sets the interval, in ms, between each new trickplay image.", alias="Interval")
    width_resolutions: Optional[List[StrictInt]] = Field(default=None, description="Gets or sets the target width resolutions, in px, to generates preview images for.", alias="WidthResolutions")
    tile_width: Optional[StrictInt] = Field(default=None, description="Gets or sets number of tile images to allow in X dimension.", alias="TileWidth")
    tile_height: Optional[StrictInt] = Field(default=None, description="Gets or sets number of tile images to allow in Y dimension.", alias="TileHeight")
    qscale: Optional[StrictInt] = Field(default=None, description="Gets or sets the ffmpeg output quality level.", alias="Qscale")
    jpeg_quality: Optional[StrictInt] = Field(default=None, description="Gets or sets the jpeg quality to use for image tiles.", alias="JpegQuality")
    process_threads: Optional[StrictInt] = Field(default=None, description="Gets or sets the number of threads to be used by ffmpeg.", alias="ProcessThreads")
    __properties: ClassVar[List[str]] = ["EnableHwAcceleration", "EnableHwEncoding", "EnableKeyFrameOnlyExtraction", "ScanBehavior", "ProcessPriority", "Interval", "WidthResolutions", "TileWidth", "TileHeight", "Qscale", "JpegQuality", "ProcessThreads"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrickplayOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrickplayOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "EnableHwAcceleration": obj.get("EnableHwAcceleration"),
            "EnableHwEncoding": obj.get("EnableHwEncoding"),
            "EnableKeyFrameOnlyExtraction": obj.get("EnableKeyFrameOnlyExtraction"),
            "ScanBehavior": obj.get("ScanBehavior"),
            "ProcessPriority": obj.get("ProcessPriority"),
            "Interval": obj.get("Interval"),
            "WidthResolutions": obj.get("WidthResolutions"),
            "TileWidth": obj.get("TileWidth"),
            "TileHeight": obj.get("TileHeight"),
            "Qscale": obj.get("Qscale"),
            "JpegQuality": obj.get("JpegQuality"),
            "ProcessThreads": obj.get("ProcessThreads")
        })
        return _obj


