# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_10.models.subtitle_playback_mode import SubtitlePlaybackMode
from typing import Optional, Set
from typing_extensions import Self

class UserConfiguration(BaseModel):
    """
    Class UserConfiguration.
    """ # noqa: E501
    audio_language_preference: Optional[StrictStr] = Field(default=None, description="Gets or sets the audio language preference.", alias="AudioLanguagePreference")
    play_default_audio_track: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [play default audio track].", alias="PlayDefaultAudioTrack")
    subtitle_language_preference: Optional[StrictStr] = Field(default=None, description="Gets or sets the subtitle language preference.", alias="SubtitleLanguagePreference")
    display_missing_episodes: Optional[StrictBool] = Field(default=None, alias="DisplayMissingEpisodes")
    grouped_folders: Optional[List[UUID]] = Field(default=None, alias="GroupedFolders")
    subtitle_mode: Optional[SubtitlePlaybackMode] = Field(default=None, alias="SubtitleMode")
    display_collections_view: Optional[StrictBool] = Field(default=None, alias="DisplayCollectionsView")
    enable_local_password: Optional[StrictBool] = Field(default=None, alias="EnableLocalPassword")
    ordered_views: Optional[List[UUID]] = Field(default=None, alias="OrderedViews")
    latest_items_excludes: Optional[List[UUID]] = Field(default=None, alias="LatestItemsExcludes")
    my_media_excludes: Optional[List[UUID]] = Field(default=None, alias="MyMediaExcludes")
    hide_played_in_latest: Optional[StrictBool] = Field(default=None, alias="HidePlayedInLatest")
    remember_audio_selections: Optional[StrictBool] = Field(default=None, alias="RememberAudioSelections")
    remember_subtitle_selections: Optional[StrictBool] = Field(default=None, alias="RememberSubtitleSelections")
    enable_next_episode_auto_play: Optional[StrictBool] = Field(default=None, alias="EnableNextEpisodeAutoPlay")
    cast_receiver_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the id of the selected cast receiver.", alias="CastReceiverId")
    __properties: ClassVar[List[str]] = ["AudioLanguagePreference", "PlayDefaultAudioTrack", "SubtitleLanguagePreference", "DisplayMissingEpisodes", "GroupedFolders", "SubtitleMode", "DisplayCollectionsView", "EnableLocalPassword", "OrderedViews", "LatestItemsExcludes", "MyMediaExcludes", "HidePlayedInLatest", "RememberAudioSelections", "RememberSubtitleSelections", "EnableNextEpisodeAutoPlay", "CastReceiverId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if audio_language_preference (nullable) is None
        # and model_fields_set contains the field
        if self.audio_language_preference is None and "audio_language_preference" in self.model_fields_set:
            _dict['AudioLanguagePreference'] = None

        # set to None if subtitle_language_preference (nullable) is None
        # and model_fields_set contains the field
        if self.subtitle_language_preference is None and "subtitle_language_preference" in self.model_fields_set:
            _dict['SubtitleLanguagePreference'] = None

        # set to None if cast_receiver_id (nullable) is None
        # and model_fields_set contains the field
        if self.cast_receiver_id is None and "cast_receiver_id" in self.model_fields_set:
            _dict['CastReceiverId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AudioLanguagePreference": obj.get("AudioLanguagePreference"),
            "PlayDefaultAudioTrack": obj.get("PlayDefaultAudioTrack"),
            "SubtitleLanguagePreference": obj.get("SubtitleLanguagePreference"),
            "DisplayMissingEpisodes": obj.get("DisplayMissingEpisodes"),
            "GroupedFolders": obj.get("GroupedFolders"),
            "SubtitleMode": obj.get("SubtitleMode"),
            "DisplayCollectionsView": obj.get("DisplayCollectionsView"),
            "EnableLocalPassword": obj.get("EnableLocalPassword"),
            "OrderedViews": obj.get("OrderedViews"),
            "LatestItemsExcludes": obj.get("LatestItemsExcludes"),
            "MyMediaExcludes": obj.get("MyMediaExcludes"),
            "HidePlayedInLatest": obj.get("HidePlayedInLatest"),
            "RememberAudioSelections": obj.get("RememberAudioSelections"),
            "RememberSubtitleSelections": obj.get("RememberSubtitleSelections"),
            "EnableNextEpisodeAutoPlay": obj.get("EnableNextEpisodeAutoPlay"),
            "CastReceiverId": obj.get("CastReceiverId")
        })
        return _obj


