# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class UserItemDataDto(BaseModel):
    """
    Class UserItemDataDto.
    """ # noqa: E501
    rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the rating.", alias="Rating")
    played_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Gets or sets the played percentage.", alias="PlayedPercentage")
    unplayed_item_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the unplayed item count.", alias="UnplayedItemCount")
    playback_position_ticks: Optional[StrictInt] = Field(default=None, description="Gets or sets the playback position ticks.", alias="PlaybackPositionTicks")
    play_count: Optional[StrictInt] = Field(default=None, description="Gets or sets the play count.", alias="PlayCount")
    is_favorite: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance is favorite.", alias="IsFavorite")
    likes: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this MediaBrowser.Model.Dto.UserItemDataDto is likes.", alias="Likes")
    last_played_date: Optional[datetime] = Field(default=None, description="Gets or sets the last played date.", alias="LastPlayedDate")
    played: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this MediaBrowser.Model.Dto.UserItemDataDto is played.", alias="Played")
    key: Optional[StrictStr] = Field(default=None, description="Gets or sets the key.", alias="Key")
    item_id: Optional[UUID] = Field(default=None, description="Gets or sets the item identifier.", alias="ItemId")
    __properties: ClassVar[List[str]] = ["Rating", "PlayedPercentage", "UnplayedItemCount", "PlaybackPositionTicks", "PlayCount", "IsFavorite", "Likes", "LastPlayedDate", "Played", "Key", "ItemId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserItemDataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['Rating'] = None

        # set to None if played_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.played_percentage is None and "played_percentage" in self.model_fields_set:
            _dict['PlayedPercentage'] = None

        # set to None if unplayed_item_count (nullable) is None
        # and model_fields_set contains the field
        if self.unplayed_item_count is None and "unplayed_item_count" in self.model_fields_set:
            _dict['UnplayedItemCount'] = None

        # set to None if likes (nullable) is None
        # and model_fields_set contains the field
        if self.likes is None and "likes" in self.model_fields_set:
            _dict['Likes'] = None

        # set to None if last_played_date (nullable) is None
        # and model_fields_set contains the field
        if self.last_played_date is None and "last_played_date" in self.model_fields_set:
            _dict['LastPlayedDate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserItemDataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Rating": obj.get("Rating"),
            "PlayedPercentage": obj.get("PlayedPercentage"),
            "UnplayedItemCount": obj.get("UnplayedItemCount"),
            "PlaybackPositionTicks": obj.get("PlaybackPositionTicks"),
            "PlayCount": obj.get("PlayCount"),
            "IsFavorite": obj.get("IsFavorite"),
            "Likes": obj.get("Likes"),
            "LastPlayedDate": obj.get("LastPlayedDate"),
            "Played": obj.get("Played"),
            "Key": obj.get("Key"),
            "ItemId": obj.get("ItemId")
        })
        return _obj


