# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class VersionInfo(BaseModel):
    """
    Defines the MediaBrowser.Model.Updates.VersionInfo class.
    """ # noqa: E501
    version: Optional[StrictStr] = Field(default=None, description="Gets or sets the version.")
    version_number: Optional[StrictStr] = Field(default=None, description="Gets the version as a System.Version.", alias="VersionNumber")
    changelog: Optional[StrictStr] = Field(default=None, description="Gets or sets the changelog for this version.")
    target_abi: Optional[StrictStr] = Field(default=None, description="Gets or sets the ABI that this version was built against.", alias="targetAbi")
    source_url: Optional[StrictStr] = Field(default=None, description="Gets or sets the source URL.", alias="sourceUrl")
    checksum: Optional[StrictStr] = Field(default=None, description="Gets or sets a checksum for the binary.")
    timestamp: Optional[StrictStr] = Field(default=None, description="Gets or sets a timestamp of when the binary was built.")
    repository_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the repository name.", alias="repositoryName")
    repository_url: Optional[StrictStr] = Field(default=None, description="Gets or sets the repository url.", alias="repositoryUrl")
    __properties: ClassVar[List[str]] = ["version", "VersionNumber", "changelog", "targetAbi", "sourceUrl", "checksum", "timestamp", "repositoryName", "repositoryUrl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VersionInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "version_number",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if changelog (nullable) is None
        # and model_fields_set contains the field
        if self.changelog is None and "changelog" in self.model_fields_set:
            _dict['changelog'] = None

        # set to None if target_abi (nullable) is None
        # and model_fields_set contains the field
        if self.target_abi is None and "target_abi" in self.model_fields_set:
            _dict['targetAbi'] = None

        # set to None if source_url (nullable) is None
        # and model_fields_set contains the field
        if self.source_url is None and "source_url" in self.model_fields_set:
            _dict['sourceUrl'] = None

        # set to None if checksum (nullable) is None
        # and model_fields_set contains the field
        if self.checksum is None and "checksum" in self.model_fields_set:
            _dict['checksum'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VersionInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "VersionNumber": obj.get("VersionNumber"),
            "changelog": obj.get("changelog"),
            "targetAbi": obj.get("targetAbi"),
            "sourceUrl": obj.get("sourceUrl"),
            "checksum": obj.get("checksum"),
            "timestamp": obj.get("timestamp"),
            "repositoryName": obj.get("repositoryName"),
            "repositoryUrl": obj.get("repositoryUrl")
        })
        return _obj


