# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.10.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from jellyfin.generated.api_10_10.models.collection_type_options import CollectionTypeOptions
from jellyfin.generated.api_10_10.models.library_options import LibraryOptions
from typing import Optional, Set
from typing_extensions import Self

class VirtualFolderInfo(BaseModel):
    """
    Used to hold information about a user's list of configured virtual folders.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    locations: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the locations.", alias="Locations")
    collection_type: Optional[CollectionTypeOptions] = Field(default=None, alias="CollectionType")
    library_options: Optional[LibraryOptions] = Field(default=None, alias="LibraryOptions")
    item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the item identifier.", alias="ItemId")
    primary_image_item_id: Optional[StrictStr] = Field(default=None, description="Gets or sets the primary image item identifier.", alias="PrimaryImageItemId")
    refresh_progress: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="RefreshProgress")
    refresh_status: Optional[StrictStr] = Field(default=None, alias="RefreshStatus")
    __properties: ClassVar[List[str]] = ["Name", "Locations", "CollectionType", "LibraryOptions", "ItemId", "PrimaryImageItemId", "RefreshProgress", "RefreshStatus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VirtualFolderInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of library_options
        if self.library_options:
            _dict['LibraryOptions'] = self.library_options.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if locations (nullable) is None
        # and model_fields_set contains the field
        if self.locations is None and "locations" in self.model_fields_set:
            _dict['Locations'] = None

        # set to None if item_id (nullable) is None
        # and model_fields_set contains the field
        if self.item_id is None and "item_id" in self.model_fields_set:
            _dict['ItemId'] = None

        # set to None if primary_image_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.primary_image_item_id is None and "primary_image_item_id" in self.model_fields_set:
            _dict['PrimaryImageItemId'] = None

        # set to None if refresh_progress (nullable) is None
        # and model_fields_set contains the field
        if self.refresh_progress is None and "refresh_progress" in self.model_fields_set:
            _dict['RefreshProgress'] = None

        # set to None if refresh_status (nullable) is None
        # and model_fields_set contains the field
        if self.refresh_status is None and "refresh_status" in self.model_fields_set:
            _dict['RefreshStatus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VirtualFolderInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Locations": obj.get("Locations"),
            "CollectionType": obj.get("CollectionType"),
            "LibraryOptions": LibraryOptions.from_dict(obj["LibraryOptions"]) if obj.get("LibraryOptions") is not None else None,
            "ItemId": obj.get("ItemId"),
            "PrimaryImageItemId": obj.get("PrimaryImageItemId"),
            "RefreshProgress": obj.get("RefreshProgress"),
            "RefreshStatus": obj.get("RefreshStatus")
        })
        return _obj


