# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Dict, Optional, Tuple, Union
from typing_extensions import Annotated
from uuid import UUID

from jellyfin.generated.api_10_11.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_11.api_response import ApiResponse
from jellyfin.generated.api_10_11.rest import RESTResponseType


class AudioApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_audio_stream(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_audio_stream_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_audio_stream_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_audio_stream_serialize(
        self,
        item_id,
        container,
        static,
        params,
        tag,
        device_profile_id,
        play_session_id,
        segment_container,
        segment_length,
        min_segments,
        media_source_id,
        device_id,
        audio_codec,
        enable_auto_stream_copy,
        allow_video_stream_copy,
        allow_audio_stream_copy,
        break_on_non_key_frames,
        audio_sample_rate,
        max_audio_bit_depth,
        audio_bit_rate,
        audio_channels,
        max_audio_channels,
        profile,
        level,
        framerate,
        max_framerate,
        copy_timestamps,
        start_time_ticks,
        width,
        height,
        video_bit_rate,
        subtitle_stream_index,
        subtitle_method,
        max_ref_frames,
        max_video_bit_depth,
        require_avc,
        de_interlace,
        require_non_anamorphic,
        transcoding_max_audio_channels,
        cpu_core_limit,
        live_stream_id,
        enable_mpegts_m2_ts_mode,
        video_codec,
        subtitle_codec,
        transcode_reasons,
        audio_stream_index,
        video_stream_index,
        context,
        stream_options,
        enable_audio_vbr_encoding,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if container is not None:
            
            _query_params.append(('container', container))
            
        if static is not None:
            
            _query_params.append(('static', static))
            
        if params is not None:
            
            _query_params.append(('params', params))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if device_profile_id is not None:
            
            _query_params.append(('deviceProfileId', device_profile_id))
            
        if play_session_id is not None:
            
            _query_params.append(('playSessionId', play_session_id))
            
        if segment_container is not None:
            
            _query_params.append(('segmentContainer', segment_container))
            
        if segment_length is not None:
            
            _query_params.append(('segmentLength', segment_length))
            
        if min_segments is not None:
            
            _query_params.append(('minSegments', min_segments))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if enable_auto_stream_copy is not None:
            
            _query_params.append(('enableAutoStreamCopy', enable_auto_stream_copy))
            
        if allow_video_stream_copy is not None:
            
            _query_params.append(('allowVideoStreamCopy', allow_video_stream_copy))
            
        if allow_audio_stream_copy is not None:
            
            _query_params.append(('allowAudioStreamCopy', allow_audio_stream_copy))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if audio_sample_rate is not None:
            
            _query_params.append(('audioSampleRate', audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if audio_channels is not None:
            
            _query_params.append(('audioChannels', audio_channels))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if profile is not None:
            
            _query_params.append(('profile', profile))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if framerate is not None:
            
            _query_params.append(('framerate', framerate))
            
        if max_framerate is not None:
            
            _query_params.append(('maxFramerate', max_framerate))
            
        if copy_timestamps is not None:
            
            _query_params.append(('copyTimestamps', copy_timestamps))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if video_bit_rate is not None:
            
            _query_params.append(('videoBitRate', video_bit_rate))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if subtitle_method is not None:
            
            _query_params.append(('subtitleMethod', subtitle_method.value))
            
        if max_ref_frames is not None:
            
            _query_params.append(('maxRefFrames', max_ref_frames))
            
        if max_video_bit_depth is not None:
            
            _query_params.append(('maxVideoBitDepth', max_video_bit_depth))
            
        if require_avc is not None:
            
            _query_params.append(('requireAvc', require_avc))
            
        if de_interlace is not None:
            
            _query_params.append(('deInterlace', de_interlace))
            
        if require_non_anamorphic is not None:
            
            _query_params.append(('requireNonAnamorphic', require_non_anamorphic))
            
        if transcoding_max_audio_channels is not None:
            
            _query_params.append(('transcodingMaxAudioChannels', transcoding_max_audio_channels))
            
        if cpu_core_limit is not None:
            
            _query_params.append(('cpuCoreLimit', cpu_core_limit))
            
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        if enable_mpegts_m2_ts_mode is not None:
            
            _query_params.append(('enableMpegtsM2TsMode', enable_mpegts_m2_ts_mode))
            
        if video_codec is not None:
            
            _query_params.append(('videoCodec', video_codec))
            
        if subtitle_codec is not None:
            
            _query_params.append(('subtitleCodec', subtitle_codec))
            
        if transcode_reasons is not None:
            
            _query_params.append(('transcodeReasons', transcode_reasons))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if video_stream_index is not None:
            
            _query_params.append(('videoStreamIndex', video_stream_index))
            
        if context is not None:
            
            _query_params.append(('context', context.value))
            
        if stream_options is not None:
            
            _query_params.append(('streamOptions', stream_options))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Audio/{itemId}/stream',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_audio_stream_by_container(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_audio_stream_by_container_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_audio_stream_by_container_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_audio_stream_by_container_serialize(
        self,
        item_id,
        container,
        static,
        params,
        tag,
        device_profile_id,
        play_session_id,
        segment_container,
        segment_length,
        min_segments,
        media_source_id,
        device_id,
        audio_codec,
        enable_auto_stream_copy,
        allow_video_stream_copy,
        allow_audio_stream_copy,
        break_on_non_key_frames,
        audio_sample_rate,
        max_audio_bit_depth,
        audio_bit_rate,
        audio_channels,
        max_audio_channels,
        profile,
        level,
        framerate,
        max_framerate,
        copy_timestamps,
        start_time_ticks,
        width,
        height,
        video_bit_rate,
        subtitle_stream_index,
        subtitle_method,
        max_ref_frames,
        max_video_bit_depth,
        require_avc,
        de_interlace,
        require_non_anamorphic,
        transcoding_max_audio_channels,
        cpu_core_limit,
        live_stream_id,
        enable_mpegts_m2_ts_mode,
        video_codec,
        subtitle_codec,
        transcode_reasons,
        audio_stream_index,
        video_stream_index,
        context,
        stream_options,
        enable_audio_vbr_encoding,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if container is not None:
            _path_params['container'] = container
        # process the query parameters
        if static is not None:
            
            _query_params.append(('static', static))
            
        if params is not None:
            
            _query_params.append(('params', params))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if device_profile_id is not None:
            
            _query_params.append(('deviceProfileId', device_profile_id))
            
        if play_session_id is not None:
            
            _query_params.append(('playSessionId', play_session_id))
            
        if segment_container is not None:
            
            _query_params.append(('segmentContainer', segment_container))
            
        if segment_length is not None:
            
            _query_params.append(('segmentLength', segment_length))
            
        if min_segments is not None:
            
            _query_params.append(('minSegments', min_segments))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if enable_auto_stream_copy is not None:
            
            _query_params.append(('enableAutoStreamCopy', enable_auto_stream_copy))
            
        if allow_video_stream_copy is not None:
            
            _query_params.append(('allowVideoStreamCopy', allow_video_stream_copy))
            
        if allow_audio_stream_copy is not None:
            
            _query_params.append(('allowAudioStreamCopy', allow_audio_stream_copy))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if audio_sample_rate is not None:
            
            _query_params.append(('audioSampleRate', audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if audio_channels is not None:
            
            _query_params.append(('audioChannels', audio_channels))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if profile is not None:
            
            _query_params.append(('profile', profile))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if framerate is not None:
            
            _query_params.append(('framerate', framerate))
            
        if max_framerate is not None:
            
            _query_params.append(('maxFramerate', max_framerate))
            
        if copy_timestamps is not None:
            
            _query_params.append(('copyTimestamps', copy_timestamps))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if video_bit_rate is not None:
            
            _query_params.append(('videoBitRate', video_bit_rate))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if subtitle_method is not None:
            
            _query_params.append(('subtitleMethod', subtitle_method.value))
            
        if max_ref_frames is not None:
            
            _query_params.append(('maxRefFrames', max_ref_frames))
            
        if max_video_bit_depth is not None:
            
            _query_params.append(('maxVideoBitDepth', max_video_bit_depth))
            
        if require_avc is not None:
            
            _query_params.append(('requireAvc', require_avc))
            
        if de_interlace is not None:
            
            _query_params.append(('deInterlace', de_interlace))
            
        if require_non_anamorphic is not None:
            
            _query_params.append(('requireNonAnamorphic', require_non_anamorphic))
            
        if transcoding_max_audio_channels is not None:
            
            _query_params.append(('transcodingMaxAudioChannels', transcoding_max_audio_channels))
            
        if cpu_core_limit is not None:
            
            _query_params.append(('cpuCoreLimit', cpu_core_limit))
            
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        if enable_mpegts_m2_ts_mode is not None:
            
            _query_params.append(('enableMpegtsM2TsMode', enable_mpegts_m2_ts_mode))
            
        if video_codec is not None:
            
            _query_params.append(('videoCodec', video_codec))
            
        if subtitle_codec is not None:
            
            _query_params.append(('subtitleCodec', subtitle_codec))
            
        if transcode_reasons is not None:
            
            _query_params.append(('transcodeReasons', transcode_reasons))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if video_stream_index is not None:
            
            _query_params.append(('videoStreamIndex', video_stream_index))
            
        if context is not None:
            
            _query_params.append(('context', context.value))
            
        if stream_options is not None:
            
            _query_params.append(('streamOptions', stream_options))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Audio/{itemId}/stream.{container}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_audio_stream(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_audio_stream_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_audio_stream_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The audio container.")] = None,
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container.
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_audio_stream_serialize(
        self,
        item_id,
        container,
        static,
        params,
        tag,
        device_profile_id,
        play_session_id,
        segment_container,
        segment_length,
        min_segments,
        media_source_id,
        device_id,
        audio_codec,
        enable_auto_stream_copy,
        allow_video_stream_copy,
        allow_audio_stream_copy,
        break_on_non_key_frames,
        audio_sample_rate,
        max_audio_bit_depth,
        audio_bit_rate,
        audio_channels,
        max_audio_channels,
        profile,
        level,
        framerate,
        max_framerate,
        copy_timestamps,
        start_time_ticks,
        width,
        height,
        video_bit_rate,
        subtitle_stream_index,
        subtitle_method,
        max_ref_frames,
        max_video_bit_depth,
        require_avc,
        de_interlace,
        require_non_anamorphic,
        transcoding_max_audio_channels,
        cpu_core_limit,
        live_stream_id,
        enable_mpegts_m2_ts_mode,
        video_codec,
        subtitle_codec,
        transcode_reasons,
        audio_stream_index,
        video_stream_index,
        context,
        stream_options,
        enable_audio_vbr_encoding,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if container is not None:
            
            _query_params.append(('container', container))
            
        if static is not None:
            
            _query_params.append(('static', static))
            
        if params is not None:
            
            _query_params.append(('params', params))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if device_profile_id is not None:
            
            _query_params.append(('deviceProfileId', device_profile_id))
            
        if play_session_id is not None:
            
            _query_params.append(('playSessionId', play_session_id))
            
        if segment_container is not None:
            
            _query_params.append(('segmentContainer', segment_container))
            
        if segment_length is not None:
            
            _query_params.append(('segmentLength', segment_length))
            
        if min_segments is not None:
            
            _query_params.append(('minSegments', min_segments))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if enable_auto_stream_copy is not None:
            
            _query_params.append(('enableAutoStreamCopy', enable_auto_stream_copy))
            
        if allow_video_stream_copy is not None:
            
            _query_params.append(('allowVideoStreamCopy', allow_video_stream_copy))
            
        if allow_audio_stream_copy is not None:
            
            _query_params.append(('allowAudioStreamCopy', allow_audio_stream_copy))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if audio_sample_rate is not None:
            
            _query_params.append(('audioSampleRate', audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if audio_channels is not None:
            
            _query_params.append(('audioChannels', audio_channels))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if profile is not None:
            
            _query_params.append(('profile', profile))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if framerate is not None:
            
            _query_params.append(('framerate', framerate))
            
        if max_framerate is not None:
            
            _query_params.append(('maxFramerate', max_framerate))
            
        if copy_timestamps is not None:
            
            _query_params.append(('copyTimestamps', copy_timestamps))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if video_bit_rate is not None:
            
            _query_params.append(('videoBitRate', video_bit_rate))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if subtitle_method is not None:
            
            _query_params.append(('subtitleMethod', subtitle_method.value))
            
        if max_ref_frames is not None:
            
            _query_params.append(('maxRefFrames', max_ref_frames))
            
        if max_video_bit_depth is not None:
            
            _query_params.append(('maxVideoBitDepth', max_video_bit_depth))
            
        if require_avc is not None:
            
            _query_params.append(('requireAvc', require_avc))
            
        if de_interlace is not None:
            
            _query_params.append(('deInterlace', de_interlace))
            
        if require_non_anamorphic is not None:
            
            _query_params.append(('requireNonAnamorphic', require_non_anamorphic))
            
        if transcoding_max_audio_channels is not None:
            
            _query_params.append(('transcodingMaxAudioChannels', transcoding_max_audio_channels))
            
        if cpu_core_limit is not None:
            
            _query_params.append(('cpuCoreLimit', cpu_core_limit))
            
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        if enable_mpegts_m2_ts_mode is not None:
            
            _query_params.append(('enableMpegtsM2TsMode', enable_mpegts_m2_ts_mode))
            
        if video_codec is not None:
            
            _query_params.append(('videoCodec', video_codec))
            
        if subtitle_codec is not None:
            
            _query_params.append(('subtitleCodec', subtitle_codec))
            
        if transcode_reasons is not None:
            
            _query_params.append(('transcodeReasons', transcode_reasons))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if video_stream_index is not None:
            
            _query_params.append(('videoStreamIndex', video_stream_index))
            
        if context is not None:
            
            _query_params.append(('context', context.value))
            
        if stream_options is not None:
            
            _query_params.append(('streamOptions', stream_options))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Audio/{itemId}/stream',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_audio_stream_by_container(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_audio_stream_by_container_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_audio_stream_by_container_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[str, Field(strict=True, description="The audio container.")],
        static: Annotated[Optional[StrictBool], Field(description="Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.")] = None,
        params: Annotated[Optional[StrictStr], Field(description="The streaming parameters.")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="The tag.")] = None,
        device_profile_id: Annotated[Optional[StrictStr], Field(description="Optional. The dlna device profile id to utilize.")] = None,
        play_session_id: Annotated[Optional[StrictStr], Field(description="The play session id.")] = None,
        segment_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="The segment container.")] = None,
        segment_length: Annotated[Optional[StrictInt], Field(description="The segment length.")] = None,
        min_segments: Annotated[Optional[StrictInt], Field(description="The minimum number of segments.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.")] = None,
        enable_auto_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.")] = None,
        allow_video_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the video stream url.")] = None,
        allow_audio_stream_copy: Annotated[Optional[StrictBool], Field(description="Whether or not to allow copying of the audio stream url.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific audio sample rate, e.g. 44100.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a specific number of audio channels to encode to, e.g. 2.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. Specify a maximum number of audio channels to encode to, e.g. 2.")] = None,
        profile: Annotated[Optional[StrictStr], Field(description="Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.")] = None,
        level: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.")] = None,
        framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        max_framerate: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.")] = None,
        copy_timestamps: Annotated[Optional[StrictBool], Field(description="Whether or not to copy timestamps when transcoding with an offset. Defaults to false.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        width: Annotated[Optional[StrictInt], Field(description="Optional. The fixed horizontal resolution of the encoded video.")] = None,
        height: Annotated[Optional[StrictInt], Field(description="Optional. The fixed vertical resolution of the encoded video.")] = None,
        video_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.")] = None,
        subtitle_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.")] = None,
        subtitle_method: Annotated[Optional[StrictStr], Field(description="Optional. Specify the subtitle delivery method.")] = None,
        max_ref_frames: Annotated[Optional[StrictInt], Field(description="Optional.")] = None,
        max_video_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum video bit depth.")] = None,
        require_avc: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require avc.")] = None,
        de_interlace: Annotated[Optional[StrictBool], Field(description="Optional. Whether to deinterlace the video.")] = None,
        require_non_anamorphic: Annotated[Optional[StrictBool], Field(description="Optional. Whether to require a non anamorphic stream.")] = None,
        transcoding_max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels to transcode.")] = None,
        cpu_core_limit: Annotated[Optional[StrictInt], Field(description="Optional. The limit of how many cpu cores to use.")] = None,
        live_stream_id: Annotated[Optional[StrictStr], Field(description="The live stream id.")] = None,
        enable_mpegts_m2_ts_mode: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable the MpegtsM2Ts mode.")] = None,
        video_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.")] = None,
        subtitle_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. Specify a subtitle codec to encode to.")] = None,
        transcode_reasons: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding reason.")] = None,
        audio_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the audio stream to use. If omitted the first audio stream will be used.")] = None,
        video_stream_index: Annotated[Optional[StrictInt], Field(description="Optional. The index of the video stream to use. If omitted the first video stream will be used.")] = None,
        context: Annotated[Optional[StrictStr], Field(description="Optional. The MediaBrowser.Model.Dlna.EncodingContext.")] = None,
        stream_options: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="Optional. The streaming options.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: The audio container. (required)
        :type container: str
        :param static: Optional. If true, the original file will be streamed statically without any encoding. Use either no url extension or the original file extension. true/false.
        :type static: bool
        :param params: The streaming parameters.
        :type params: str
        :param tag: The tag.
        :type tag: str
        :param device_profile_id: Optional. The dlna device profile id to utilize.
        :type device_profile_id: str
        :param play_session_id: The play session id.
        :type play_session_id: str
        :param segment_container: The segment container.
        :type segment_container: str
        :param segment_length: The segment length.
        :type segment_length: int
        :param min_segments: The minimum number of segments.
        :type min_segments: int
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param audio_codec: Optional. Specify an audio codec to encode to, e.g. mp3. If omitted the server will auto-select using the url's extension.
        :type audio_codec: str
        :param enable_auto_stream_copy: Whether or not to allow automatic stream copy if requested values match the original source. Defaults to true.
        :type enable_auto_stream_copy: bool
        :param allow_video_stream_copy: Whether or not to allow copying of the video stream url.
        :type allow_video_stream_copy: bool
        :param allow_audio_stream_copy: Whether or not to allow copying of the audio stream url.
        :type allow_audio_stream_copy: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param audio_sample_rate: Optional. Specify a specific audio sample rate, e.g. 44100.
        :type audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param audio_channels: Optional. Specify a specific number of audio channels to encode to, e.g. 2.
        :type audio_channels: int
        :param max_audio_channels: Optional. Specify a maximum number of audio channels to encode to, e.g. 2.
        :type max_audio_channels: int
        :param profile: Optional. Specify a specific an encoder profile (varies by encoder), e.g. main, baseline, high.
        :type profile: str
        :param level: Optional. Specify a level for the encoder profile (varies by encoder), e.g. 3, 3.1.
        :type level: str
        :param framerate: Optional. A specific video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type framerate: float
        :param max_framerate: Optional. A specific maximum video framerate to encode to, e.g. 23.976. Generally this should be omitted unless the device has specific requirements.
        :type max_framerate: float
        :param copy_timestamps: Whether or not to copy timestamps when transcoding with an offset. Defaults to false.
        :type copy_timestamps: bool
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param width: Optional. The fixed horizontal resolution of the encoded video.
        :type width: int
        :param height: Optional. The fixed vertical resolution of the encoded video.
        :type height: int
        :param video_bit_rate: Optional. Specify a video bitrate to encode to, e.g. 500000. If omitted this will be left to encoder defaults.
        :type video_bit_rate: int
        :param subtitle_stream_index: Optional. The index of the subtitle stream to use. If omitted no subtitles will be used.
        :type subtitle_stream_index: int
        :param subtitle_method: Optional. Specify the subtitle delivery method.
        :type subtitle_method: SubtitleDeliveryMethod
        :param max_ref_frames: Optional.
        :type max_ref_frames: int
        :param max_video_bit_depth: Optional. The maximum video bit depth.
        :type max_video_bit_depth: int
        :param require_avc: Optional. Whether to require avc.
        :type require_avc: bool
        :param de_interlace: Optional. Whether to deinterlace the video.
        :type de_interlace: bool
        :param require_non_anamorphic: Optional. Whether to require a non anamorphic stream.
        :type require_non_anamorphic: bool
        :param transcoding_max_audio_channels: Optional. The maximum number of audio channels to transcode.
        :type transcoding_max_audio_channels: int
        :param cpu_core_limit: Optional. The limit of how many cpu cores to use.
        :type cpu_core_limit: int
        :param live_stream_id: The live stream id.
        :type live_stream_id: str
        :param enable_mpegts_m2_ts_mode: Optional. Whether to enable the MpegtsM2Ts mode.
        :type enable_mpegts_m2_ts_mode: bool
        :param video_codec: Optional. Specify a video codec to encode to, e.g. h264. If omitted the server will auto-select using the url's extension.
        :type video_codec: str
        :param subtitle_codec: Optional. Specify a subtitle codec to encode to.
        :type subtitle_codec: str
        :param transcode_reasons: Optional. The transcoding reason.
        :type transcode_reasons: str
        :param audio_stream_index: Optional. The index of the audio stream to use. If omitted the first audio stream will be used.
        :type audio_stream_index: int
        :param video_stream_index: Optional. The index of the video stream to use. If omitted the first video stream will be used.
        :type video_stream_index: int
        :param context: Optional. The MediaBrowser.Model.Dlna.EncodingContext.
        :type context: EncodingContext
        :param stream_options: Optional. The streaming options.
        :type stream_options: Dict[str, Optional[str]]
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_audio_stream_by_container_serialize(
            item_id=item_id,
            container=container,
            static=static,
            params=params,
            tag=tag,
            device_profile_id=device_profile_id,
            play_session_id=play_session_id,
            segment_container=segment_container,
            segment_length=segment_length,
            min_segments=min_segments,
            media_source_id=media_source_id,
            device_id=device_id,
            audio_codec=audio_codec,
            enable_auto_stream_copy=enable_auto_stream_copy,
            allow_video_stream_copy=allow_video_stream_copy,
            allow_audio_stream_copy=allow_audio_stream_copy,
            break_on_non_key_frames=break_on_non_key_frames,
            audio_sample_rate=audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            audio_bit_rate=audio_bit_rate,
            audio_channels=audio_channels,
            max_audio_channels=max_audio_channels,
            profile=profile,
            level=level,
            framerate=framerate,
            max_framerate=max_framerate,
            copy_timestamps=copy_timestamps,
            start_time_ticks=start_time_ticks,
            width=width,
            height=height,
            video_bit_rate=video_bit_rate,
            subtitle_stream_index=subtitle_stream_index,
            subtitle_method=subtitle_method,
            max_ref_frames=max_ref_frames,
            max_video_bit_depth=max_video_bit_depth,
            require_avc=require_avc,
            de_interlace=de_interlace,
            require_non_anamorphic=require_non_anamorphic,
            transcoding_max_audio_channels=transcoding_max_audio_channels,
            cpu_core_limit=cpu_core_limit,
            live_stream_id=live_stream_id,
            enable_mpegts_m2_ts_mode=enable_mpegts_m2_ts_mode,
            video_codec=video_codec,
            subtitle_codec=subtitle_codec,
            transcode_reasons=transcode_reasons,
            audio_stream_index=audio_stream_index,
            video_stream_index=video_stream_index,
            context=context,
            stream_options=stream_options,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '503': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_audio_stream_by_container_serialize(
        self,
        item_id,
        container,
        static,
        params,
        tag,
        device_profile_id,
        play_session_id,
        segment_container,
        segment_length,
        min_segments,
        media_source_id,
        device_id,
        audio_codec,
        enable_auto_stream_copy,
        allow_video_stream_copy,
        allow_audio_stream_copy,
        break_on_non_key_frames,
        audio_sample_rate,
        max_audio_bit_depth,
        audio_bit_rate,
        audio_channels,
        max_audio_channels,
        profile,
        level,
        framerate,
        max_framerate,
        copy_timestamps,
        start_time_ticks,
        width,
        height,
        video_bit_rate,
        subtitle_stream_index,
        subtitle_method,
        max_ref_frames,
        max_video_bit_depth,
        require_avc,
        de_interlace,
        require_non_anamorphic,
        transcoding_max_audio_channels,
        cpu_core_limit,
        live_stream_id,
        enable_mpegts_m2_ts_mode,
        video_codec,
        subtitle_codec,
        transcode_reasons,
        audio_stream_index,
        video_stream_index,
        context,
        stream_options,
        enable_audio_vbr_encoding,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        if container is not None:
            _path_params['container'] = container
        # process the query parameters
        if static is not None:
            
            _query_params.append(('static', static))
            
        if params is not None:
            
            _query_params.append(('params', params))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if device_profile_id is not None:
            
            _query_params.append(('deviceProfileId', device_profile_id))
            
        if play_session_id is not None:
            
            _query_params.append(('playSessionId', play_session_id))
            
        if segment_container is not None:
            
            _query_params.append(('segmentContainer', segment_container))
            
        if segment_length is not None:
            
            _query_params.append(('segmentLength', segment_length))
            
        if min_segments is not None:
            
            _query_params.append(('minSegments', min_segments))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if enable_auto_stream_copy is not None:
            
            _query_params.append(('enableAutoStreamCopy', enable_auto_stream_copy))
            
        if allow_video_stream_copy is not None:
            
            _query_params.append(('allowVideoStreamCopy', allow_video_stream_copy))
            
        if allow_audio_stream_copy is not None:
            
            _query_params.append(('allowAudioStreamCopy', allow_audio_stream_copy))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if audio_sample_rate is not None:
            
            _query_params.append(('audioSampleRate', audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if audio_channels is not None:
            
            _query_params.append(('audioChannels', audio_channels))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if profile is not None:
            
            _query_params.append(('profile', profile))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if framerate is not None:
            
            _query_params.append(('framerate', framerate))
            
        if max_framerate is not None:
            
            _query_params.append(('maxFramerate', max_framerate))
            
        if copy_timestamps is not None:
            
            _query_params.append(('copyTimestamps', copy_timestamps))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if width is not None:
            
            _query_params.append(('width', width))
            
        if height is not None:
            
            _query_params.append(('height', height))
            
        if video_bit_rate is not None:
            
            _query_params.append(('videoBitRate', video_bit_rate))
            
        if subtitle_stream_index is not None:
            
            _query_params.append(('subtitleStreamIndex', subtitle_stream_index))
            
        if subtitle_method is not None:
            
            _query_params.append(('subtitleMethod', subtitle_method.value))
            
        if max_ref_frames is not None:
            
            _query_params.append(('maxRefFrames', max_ref_frames))
            
        if max_video_bit_depth is not None:
            
            _query_params.append(('maxVideoBitDepth', max_video_bit_depth))
            
        if require_avc is not None:
            
            _query_params.append(('requireAvc', require_avc))
            
        if de_interlace is not None:
            
            _query_params.append(('deInterlace', de_interlace))
            
        if require_non_anamorphic is not None:
            
            _query_params.append(('requireNonAnamorphic', require_non_anamorphic))
            
        if transcoding_max_audio_channels is not None:
            
            _query_params.append(('transcodingMaxAudioChannels', transcoding_max_audio_channels))
            
        if cpu_core_limit is not None:
            
            _query_params.append(('cpuCoreLimit', cpu_core_limit))
            
        if live_stream_id is not None:
            
            _query_params.append(('liveStreamId', live_stream_id))
            
        if enable_mpegts_m2_ts_mode is not None:
            
            _query_params.append(('enableMpegtsM2TsMode', enable_mpegts_m2_ts_mode))
            
        if video_codec is not None:
            
            _query_params.append(('videoCodec', video_codec))
            
        if subtitle_codec is not None:
            
            _query_params.append(('subtitleCodec', subtitle_codec))
            
        if transcode_reasons is not None:
            
            _query_params.append(('transcodeReasons', transcode_reasons))
            
        if audio_stream_index is not None:
            
            _query_params.append(('audioStreamIndex', audio_stream_index))
            
        if video_stream_index is not None:
            
            _query_params.append(('videoStreamIndex', video_stream_index))
            
        if context is not None:
            
            _query_params.append(('context', context.value))
            
        if stream_options is not None:
            
            _query_params.append(('streamOptions', stream_options))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Audio/{itemId}/stream.{container}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


