# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_11.models.media_type import MediaType
from jellyfin.generated.api_10_11.models.query_filters import QueryFilters
from jellyfin.generated.api_10_11.models.query_filters_legacy import QueryFiltersLegacy

from jellyfin.generated.api_10_11.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_11.api_response import ApiResponse
from jellyfin.generated.api_10_11.rest import RESTResponseType


class FilterApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_query_filters(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_airing: Annotated[Optional[StrictBool], Field(description="Optional. Is item airing.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional. Is item movie.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional. Is item sports.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional. Is item kids.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional. Is item news.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional. Is item series.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="Optional. Search recursive.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> QueryFilters:
        """Gets query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_airing: Optional. Is item airing.
        :type is_airing: bool
        :param is_movie: Optional. Is item movie.
        :type is_movie: bool
        :param is_sports: Optional. Is item sports.
        :type is_sports: bool
        :param is_kids: Optional. Is item kids.
        :type is_kids: bool
        :param is_news: Optional. Is item news.
        :type is_news: bool
        :param is_series: Optional. Is item series.
        :type is_series: bool
        :param recursive: Optional. Search recursive.
        :type recursive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            is_airing=is_airing,
            is_movie=is_movie,
            is_sports=is_sports,
            is_kids=is_kids,
            is_news=is_news,
            is_series=is_series,
            recursive=recursive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFilters",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_query_filters_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_airing: Annotated[Optional[StrictBool], Field(description="Optional. Is item airing.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional. Is item movie.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional. Is item sports.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional. Is item kids.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional. Is item news.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional. Is item series.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="Optional. Search recursive.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[QueryFilters]:
        """Gets query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_airing: Optional. Is item airing.
        :type is_airing: bool
        :param is_movie: Optional. Is item movie.
        :type is_movie: bool
        :param is_sports: Optional. Is item sports.
        :type is_sports: bool
        :param is_kids: Optional. Is item kids.
        :type is_kids: bool
        :param is_news: Optional. Is item news.
        :type is_news: bool
        :param is_series: Optional. Is item series.
        :type is_series: bool
        :param recursive: Optional. Search recursive.
        :type recursive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            is_airing=is_airing,
            is_movie=is_movie,
            is_sports=is_sports,
            is_kids=is_kids,
            is_news=is_news,
            is_series=is_series,
            recursive=recursive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFilters",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_query_filters_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        is_airing: Annotated[Optional[StrictBool], Field(description="Optional. Is item airing.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional. Is item movie.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional. Is item sports.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional. Is item kids.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional. Is item news.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional. Is item series.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="Optional. Search recursive.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param is_airing: Optional. Is item airing.
        :type is_airing: bool
        :param is_movie: Optional. Is item movie.
        :type is_movie: bool
        :param is_sports: Optional. Is item sports.
        :type is_sports: bool
        :param is_kids: Optional. Is item kids.
        :type is_kids: bool
        :param is_news: Optional. Is item news.
        :type is_news: bool
        :param is_series: Optional. Is item series.
        :type is_series: bool
        :param recursive: Optional. Search recursive.
        :type recursive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            is_airing=is_airing,
            is_movie=is_movie,
            is_sports=is_sports,
            is_kids=is_kids,
            is_news=is_news,
            is_series=is_series,
            recursive=recursive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFilters",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_query_filters_serialize(
        self,
        user_id,
        parent_id,
        include_item_types,
        is_airing,
        is_movie,
        is_sports,
        is_kids,
        is_news,
        is_series,
        recursive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'includeItemTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if include_item_types is not None:
            
            _query_params.append(('includeItemTypes', include_item_types))
            
        if is_airing is not None:
            
            _query_params.append(('isAiring', is_airing))
            
        if is_movie is not None:
            
            _query_params.append(('isMovie', is_movie))
            
        if is_sports is not None:
            
            _query_params.append(('isSports', is_sports))
            
        if is_kids is not None:
            
            _query_params.append(('isKids', is_kids))
            
        if is_news is not None:
            
            _query_params.append(('isNews', is_news))
            
        if is_series is not None:
            
            _query_params.append(('isSeries', is_series))
            
        if recursive is not None:
            
            _query_params.append(('recursive', recursive))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/Filters2',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_query_filters_legacy(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Parent id.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional. Filter by MediaType. Allows multiple, comma delimited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> QueryFiltersLegacy:
        """Gets legacy query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Parent id.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param media_types: Optional. Filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_legacy_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            media_types=media_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFiltersLegacy",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_query_filters_legacy_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Parent id.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional. Filter by MediaType. Allows multiple, comma delimited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[QueryFiltersLegacy]:
        """Gets legacy query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Parent id.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param media_types: Optional. Filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_legacy_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            media_types=media_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFiltersLegacy",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_query_filters_legacy_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="Optional. User id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Parent id.")] = None,
        include_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional. Filter by MediaType. Allows multiple, comma delimited.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets legacy query filters.


        :param user_id: Optional. User id.
        :type user_id: str
        :param parent_id: Optional. Parent id.
        :type parent_id: str
        :param include_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type include_item_types: List[BaseItemKind]
        :param media_types: Optional. Filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_query_filters_legacy_serialize(
            user_id=user_id,
            parent_id=parent_id,
            include_item_types=include_item_types,
            media_types=media_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "QueryFiltersLegacy",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_query_filters_legacy_serialize(
        self,
        user_id,
        parent_id,
        include_item_types,
        media_types,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'includeItemTypes': 'multi',
            'mediaTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if include_item_types is not None:
            
            _query_params.append(('includeItemTypes', include_item_types))
            
        if media_types is not None:
            
            _query_params.append(('mediaTypes', media_types))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Items/Filters',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


