# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_dto_query_result import BaseItemDtoQueryResult
from jellyfin.generated.api_10_11.models.base_item_kind import BaseItemKind
from jellyfin.generated.api_10_11.models.image_type import ImageType
from jellyfin.generated.api_10_11.models.item_fields import ItemFields
from jellyfin.generated.api_10_11.models.item_filter import ItemFilter
from jellyfin.generated.api_10_11.models.item_sort_by import ItemSortBy
from jellyfin.generated.api_10_11.models.location_type import LocationType
from jellyfin.generated.api_10_11.models.media_type import MediaType
from jellyfin.generated.api_10_11.models.series_status import SeriesStatus
from jellyfin.generated.api_10_11.models.sort_order import SortOrder
from jellyfin.generated.api_10_11.models.video_type import VideoType

from jellyfin.generated.api_10_11.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_11.api_response import ApiResponse
from jellyfin.generated.api_10_11.rest import RESTResponseType


class TrailersApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_trailers(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id supplied as query parameter; this is required when not using an API key.")] = None,
        max_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).")] = None,
        has_theme_song: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme songs.")] = None,
        has_theme_video: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme videos.")] = None,
        has_subtitles: Annotated[Optional[StrictBool], Field(description="Optional filter by items with subtitles.")] = None,
        has_special_feature: Annotated[Optional[StrictBool], Field(description="Optional filter by items with special features.")] = None,
        has_trailer: Annotated[Optional[StrictBool], Field(description="Optional filter by items with trailers.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        parent_index_number: Annotated[Optional[StrictInt], Field(description="Optional filter by parent index number.")] = None,
        has_parental_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have or do not have a parental rating.")] = None,
        is_hd: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are HD or not.")] = None,
        is4_k: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 4K or not.")] = None,
        location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.")] = None,
        exclude_location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are missing episodes or not.")] = None,
        is_unaired: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are unaired episodes or not.")] = None,
        min_community_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum community rating.")] = None,
        min_critic_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum critic rating.")] = None,
        min_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The minimum premiere date. Format = ISO.")] = None,
        min_date_last_saved: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date. Format = ISO.")] = None,
        min_date_last_saved_for_user: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date for the current user. Format = ISO.")] = None,
        max_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The maximum premiere date. Format = ISO.")] = None,
        has_overview: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an overview or not.")] = None,
        has_imdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an IMDb id or not.")] = None,
        has_tmdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TMDb id or not.")] = None,
        has_tvdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TVDb id or not.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv sports.")] = None,
        exclude_item_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="When searching within folders, this determines whether or not the search will be recursive. true/false.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Filter based on a search term.")] = None,
        sort_order: Annotated[Optional[List[SortOrder]], Field(description="Sort Order - Ascending, Descending.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        filters: Annotated[Optional[List[ItemFilter]], Field(description="Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional filter by MediaType. Allows multiple, comma delimited.")] = None,
        image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.")] = None,
        sort_by: Annotated[Optional[List[ItemSortBy]], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        is_played: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are played, or not.")] = None,
        genres: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.")] = None,
        official_ratings: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.")] = None,
        years: Annotated[Optional[List[StrictInt]], Field(description="Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        person: Annotated[Optional[StrictStr], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person.")] = None,
        person_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person id.")] = None,
        person_types: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.")] = None,
        studios: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.")] = None,
        artists: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.")] = None,
        exclude_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.")] = None,
        artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified artist id.")] = None,
        album_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified album artist id.")] = None,
        contributing_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.")] = None,
        albums: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.")] = None,
        album_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.")] = None,
        ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.")] = None,
        video_types: Annotated[Optional[List[VideoType]], Field(description="Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.")] = None,
        min_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).")] = None,
        is_locked: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are locked.")] = None,
        is_place_holder: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are placeholders.")] = None,
        has_official_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have official ratings.")] = None,
        collapse_box_set_items: Annotated[Optional[StrictBool], Field(description="Whether or not to hide items behind their boxsets.")] = None,
        min_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum width of the item.")] = None,
        min_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum height of the item.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum width of the item.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum height of the item.")] = None,
        is3_d: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 3D, or not.")] = None,
        series_status: Annotated[Optional[List[SeriesStatus]], Field(description="Optional filter by Series Status. Allows multiple, comma delimited.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        studio_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.")] = None,
        genre_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Optional. Enable the total record count.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Finds movies and trailers similar to a given trailer.


        :param user_id: The user id supplied as query parameter; this is required when not using an API key.
        :type user_id: str
        :param max_official_rating: Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).
        :type max_official_rating: str
        :param has_theme_song: Optional filter by items with theme songs.
        :type has_theme_song: bool
        :param has_theme_video: Optional filter by items with theme videos.
        :type has_theme_video: bool
        :param has_subtitles: Optional filter by items with subtitles.
        :type has_subtitles: bool
        :param has_special_feature: Optional filter by items with special features.
        :type has_special_feature: bool
        :param has_trailer: Optional filter by items with trailers.
        :type has_trailer: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param parent_index_number: Optional filter by parent index number.
        :type parent_index_number: int
        :param has_parental_rating: Optional filter by items that have or do not have a parental rating.
        :type has_parental_rating: bool
        :param is_hd: Optional filter by items that are HD or not.
        :type is_hd: bool
        :param is4_k: Optional filter by items that are 4K or not.
        :type is4_k: bool
        :param location_types: Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.
        :type location_types: List[LocationType]
        :param exclude_location_types: Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.
        :type exclude_location_types: List[LocationType]
        :param is_missing: Optional filter by items that are missing episodes or not.
        :type is_missing: bool
        :param is_unaired: Optional filter by items that are unaired episodes or not.
        :type is_unaired: bool
        :param min_community_rating: Optional filter by minimum community rating.
        :type min_community_rating: float
        :param min_critic_rating: Optional filter by minimum critic rating.
        :type min_critic_rating: float
        :param min_premiere_date: Optional. The minimum premiere date. Format = ISO.
        :type min_premiere_date: datetime
        :param min_date_last_saved: Optional. The minimum last saved date. Format = ISO.
        :type min_date_last_saved: datetime
        :param min_date_last_saved_for_user: Optional. The minimum last saved date for the current user. Format = ISO.
        :type min_date_last_saved_for_user: datetime
        :param max_premiere_date: Optional. The maximum premiere date. Format = ISO.
        :type max_premiere_date: datetime
        :param has_overview: Optional filter by items that have an overview or not.
        :type has_overview: bool
        :param has_imdb_id: Optional filter by items that have an IMDb id or not.
        :type has_imdb_id: bool
        :param has_tmdb_id: Optional filter by items that have a TMDb id or not.
        :type has_tmdb_id: bool
        :param has_tvdb_id: Optional filter by items that have a TVDb id or not.
        :type has_tvdb_id: bool
        :param is_movie: Optional filter for live tv movies.
        :type is_movie: bool
        :param is_series: Optional filter for live tv series.
        :type is_series: bool
        :param is_news: Optional filter for live tv news.
        :type is_news: bool
        :param is_kids: Optional filter for live tv kids.
        :type is_kids: bool
        :param is_sports: Optional filter for live tv sports.
        :type is_sports: bool
        :param exclude_item_ids: Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.
        :type exclude_item_ids: List[str]
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param recursive: When searching within folders, this determines whether or not the search will be recursive. true/false.
        :type recursive: bool
        :param search_term: Optional. Filter based on a search term.
        :type search_term: str
        :param sort_order: Sort Order - Ascending, Descending.
        :type sort_order: List[SortOrder]
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param filters: Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.
        :type filters: List[ItemFilter]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param media_types: Optional filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param image_types: Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.
        :type image_types: List[ImageType]
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: List[ItemSortBy]
        :param is_played: Optional filter by items that are played, or not.
        :type is_played: bool
        :param genres: Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.
        :type genres: List[str]
        :param official_ratings: Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.
        :type official_ratings: List[str]
        :param tags: Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.
        :type tags: List[str]
        :param years: Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.
        :type years: List[int]
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param person: Optional. If specified, results will be filtered to include only those containing the specified person.
        :type person: str
        :param person_ids: Optional. If specified, results will be filtered to include only those containing the specified person id.
        :type person_ids: List[str]
        :param person_types: Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.
        :type person_types: List[str]
        :param studios: Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.
        :type studios: List[str]
        :param artists: Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.
        :type artists: List[str]
        :param exclude_artist_ids: Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.
        :type exclude_artist_ids: List[str]
        :param artist_ids: Optional. If specified, results will be filtered to include only those containing the specified artist id.
        :type artist_ids: List[str]
        :param album_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified album artist id.
        :type album_artist_ids: List[str]
        :param contributing_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.
        :type contributing_artist_ids: List[str]
        :param albums: Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.
        :type albums: List[str]
        :param album_ids: Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.
        :type album_ids: List[str]
        :param ids: Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.
        :type ids: List[str]
        :param video_types: Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.
        :type video_types: List[VideoType]
        :param min_official_rating: Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).
        :type min_official_rating: str
        :param is_locked: Optional filter by items that are locked.
        :type is_locked: bool
        :param is_place_holder: Optional filter by items that are placeholders.
        :type is_place_holder: bool
        :param has_official_rating: Optional filter by items that have official ratings.
        :type has_official_rating: bool
        :param collapse_box_set_items: Whether or not to hide items behind their boxsets.
        :type collapse_box_set_items: bool
        :param min_width: Optional. Filter by the minimum width of the item.
        :type min_width: int
        :param min_height: Optional. Filter by the minimum height of the item.
        :type min_height: int
        :param max_width: Optional. Filter by the maximum width of the item.
        :type max_width: int
        :param max_height: Optional. Filter by the maximum height of the item.
        :type max_height: int
        :param is3_d: Optional filter by items that are 3D, or not.
        :type is3_d: bool
        :param series_status: Optional filter by Series Status. Allows multiple, comma delimited.
        :type series_status: List[SeriesStatus]
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param studio_ids: Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.
        :type studio_ids: List[str]
        :param genre_ids: Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.
        :type genre_ids: List[str]
        :param enable_total_record_count: Optional. Enable the total record count.
        :type enable_total_record_count: bool
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trailers_serialize(
            user_id=user_id,
            max_official_rating=max_official_rating,
            has_theme_song=has_theme_song,
            has_theme_video=has_theme_video,
            has_subtitles=has_subtitles,
            has_special_feature=has_special_feature,
            has_trailer=has_trailer,
            adjacent_to=adjacent_to,
            parent_index_number=parent_index_number,
            has_parental_rating=has_parental_rating,
            is_hd=is_hd,
            is4_k=is4_k,
            location_types=location_types,
            exclude_location_types=exclude_location_types,
            is_missing=is_missing,
            is_unaired=is_unaired,
            min_community_rating=min_community_rating,
            min_critic_rating=min_critic_rating,
            min_premiere_date=min_premiere_date,
            min_date_last_saved=min_date_last_saved,
            min_date_last_saved_for_user=min_date_last_saved_for_user,
            max_premiere_date=max_premiere_date,
            has_overview=has_overview,
            has_imdb_id=has_imdb_id,
            has_tmdb_id=has_tmdb_id,
            has_tvdb_id=has_tvdb_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            exclude_item_ids=exclude_item_ids,
            start_index=start_index,
            limit=limit,
            recursive=recursive,
            search_term=search_term,
            sort_order=sort_order,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            filters=filters,
            is_favorite=is_favorite,
            media_types=media_types,
            image_types=image_types,
            sort_by=sort_by,
            is_played=is_played,
            genres=genres,
            official_ratings=official_ratings,
            tags=tags,
            years=years,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            person=person,
            person_ids=person_ids,
            person_types=person_types,
            studios=studios,
            artists=artists,
            exclude_artist_ids=exclude_artist_ids,
            artist_ids=artist_ids,
            album_artist_ids=album_artist_ids,
            contributing_artist_ids=contributing_artist_ids,
            albums=albums,
            album_ids=album_ids,
            ids=ids,
            video_types=video_types,
            min_official_rating=min_official_rating,
            is_locked=is_locked,
            is_place_holder=is_place_holder,
            has_official_rating=has_official_rating,
            collapse_box_set_items=collapse_box_set_items,
            min_width=min_width,
            min_height=min_height,
            max_width=max_width,
            max_height=max_height,
            is3_d=is3_d,
            series_status=series_status,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            studio_ids=studio_ids,
            genre_ids=genre_ids,
            enable_total_record_count=enable_total_record_count,
            enable_images=enable_images,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_trailers_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id supplied as query parameter; this is required when not using an API key.")] = None,
        max_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).")] = None,
        has_theme_song: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme songs.")] = None,
        has_theme_video: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme videos.")] = None,
        has_subtitles: Annotated[Optional[StrictBool], Field(description="Optional filter by items with subtitles.")] = None,
        has_special_feature: Annotated[Optional[StrictBool], Field(description="Optional filter by items with special features.")] = None,
        has_trailer: Annotated[Optional[StrictBool], Field(description="Optional filter by items with trailers.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        parent_index_number: Annotated[Optional[StrictInt], Field(description="Optional filter by parent index number.")] = None,
        has_parental_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have or do not have a parental rating.")] = None,
        is_hd: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are HD or not.")] = None,
        is4_k: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 4K or not.")] = None,
        location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.")] = None,
        exclude_location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are missing episodes or not.")] = None,
        is_unaired: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are unaired episodes or not.")] = None,
        min_community_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum community rating.")] = None,
        min_critic_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum critic rating.")] = None,
        min_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The minimum premiere date. Format = ISO.")] = None,
        min_date_last_saved: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date. Format = ISO.")] = None,
        min_date_last_saved_for_user: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date for the current user. Format = ISO.")] = None,
        max_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The maximum premiere date. Format = ISO.")] = None,
        has_overview: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an overview or not.")] = None,
        has_imdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an IMDb id or not.")] = None,
        has_tmdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TMDb id or not.")] = None,
        has_tvdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TVDb id or not.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv sports.")] = None,
        exclude_item_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="When searching within folders, this determines whether or not the search will be recursive. true/false.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Filter based on a search term.")] = None,
        sort_order: Annotated[Optional[List[SortOrder]], Field(description="Sort Order - Ascending, Descending.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        filters: Annotated[Optional[List[ItemFilter]], Field(description="Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional filter by MediaType. Allows multiple, comma delimited.")] = None,
        image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.")] = None,
        sort_by: Annotated[Optional[List[ItemSortBy]], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        is_played: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are played, or not.")] = None,
        genres: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.")] = None,
        official_ratings: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.")] = None,
        years: Annotated[Optional[List[StrictInt]], Field(description="Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        person: Annotated[Optional[StrictStr], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person.")] = None,
        person_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person id.")] = None,
        person_types: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.")] = None,
        studios: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.")] = None,
        artists: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.")] = None,
        exclude_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.")] = None,
        artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified artist id.")] = None,
        album_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified album artist id.")] = None,
        contributing_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.")] = None,
        albums: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.")] = None,
        album_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.")] = None,
        ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.")] = None,
        video_types: Annotated[Optional[List[VideoType]], Field(description="Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.")] = None,
        min_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).")] = None,
        is_locked: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are locked.")] = None,
        is_place_holder: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are placeholders.")] = None,
        has_official_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have official ratings.")] = None,
        collapse_box_set_items: Annotated[Optional[StrictBool], Field(description="Whether or not to hide items behind their boxsets.")] = None,
        min_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum width of the item.")] = None,
        min_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum height of the item.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum width of the item.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum height of the item.")] = None,
        is3_d: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 3D, or not.")] = None,
        series_status: Annotated[Optional[List[SeriesStatus]], Field(description="Optional filter by Series Status. Allows multiple, comma delimited.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        studio_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.")] = None,
        genre_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Optional. Enable the total record count.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Finds movies and trailers similar to a given trailer.


        :param user_id: The user id supplied as query parameter; this is required when not using an API key.
        :type user_id: str
        :param max_official_rating: Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).
        :type max_official_rating: str
        :param has_theme_song: Optional filter by items with theme songs.
        :type has_theme_song: bool
        :param has_theme_video: Optional filter by items with theme videos.
        :type has_theme_video: bool
        :param has_subtitles: Optional filter by items with subtitles.
        :type has_subtitles: bool
        :param has_special_feature: Optional filter by items with special features.
        :type has_special_feature: bool
        :param has_trailer: Optional filter by items with trailers.
        :type has_trailer: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param parent_index_number: Optional filter by parent index number.
        :type parent_index_number: int
        :param has_parental_rating: Optional filter by items that have or do not have a parental rating.
        :type has_parental_rating: bool
        :param is_hd: Optional filter by items that are HD or not.
        :type is_hd: bool
        :param is4_k: Optional filter by items that are 4K or not.
        :type is4_k: bool
        :param location_types: Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.
        :type location_types: List[LocationType]
        :param exclude_location_types: Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.
        :type exclude_location_types: List[LocationType]
        :param is_missing: Optional filter by items that are missing episodes or not.
        :type is_missing: bool
        :param is_unaired: Optional filter by items that are unaired episodes or not.
        :type is_unaired: bool
        :param min_community_rating: Optional filter by minimum community rating.
        :type min_community_rating: float
        :param min_critic_rating: Optional filter by minimum critic rating.
        :type min_critic_rating: float
        :param min_premiere_date: Optional. The minimum premiere date. Format = ISO.
        :type min_premiere_date: datetime
        :param min_date_last_saved: Optional. The minimum last saved date. Format = ISO.
        :type min_date_last_saved: datetime
        :param min_date_last_saved_for_user: Optional. The minimum last saved date for the current user. Format = ISO.
        :type min_date_last_saved_for_user: datetime
        :param max_premiere_date: Optional. The maximum premiere date. Format = ISO.
        :type max_premiere_date: datetime
        :param has_overview: Optional filter by items that have an overview or not.
        :type has_overview: bool
        :param has_imdb_id: Optional filter by items that have an IMDb id or not.
        :type has_imdb_id: bool
        :param has_tmdb_id: Optional filter by items that have a TMDb id or not.
        :type has_tmdb_id: bool
        :param has_tvdb_id: Optional filter by items that have a TVDb id or not.
        :type has_tvdb_id: bool
        :param is_movie: Optional filter for live tv movies.
        :type is_movie: bool
        :param is_series: Optional filter for live tv series.
        :type is_series: bool
        :param is_news: Optional filter for live tv news.
        :type is_news: bool
        :param is_kids: Optional filter for live tv kids.
        :type is_kids: bool
        :param is_sports: Optional filter for live tv sports.
        :type is_sports: bool
        :param exclude_item_ids: Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.
        :type exclude_item_ids: List[str]
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param recursive: When searching within folders, this determines whether or not the search will be recursive. true/false.
        :type recursive: bool
        :param search_term: Optional. Filter based on a search term.
        :type search_term: str
        :param sort_order: Sort Order - Ascending, Descending.
        :type sort_order: List[SortOrder]
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param filters: Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.
        :type filters: List[ItemFilter]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param media_types: Optional filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param image_types: Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.
        :type image_types: List[ImageType]
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: List[ItemSortBy]
        :param is_played: Optional filter by items that are played, or not.
        :type is_played: bool
        :param genres: Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.
        :type genres: List[str]
        :param official_ratings: Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.
        :type official_ratings: List[str]
        :param tags: Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.
        :type tags: List[str]
        :param years: Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.
        :type years: List[int]
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param person: Optional. If specified, results will be filtered to include only those containing the specified person.
        :type person: str
        :param person_ids: Optional. If specified, results will be filtered to include only those containing the specified person id.
        :type person_ids: List[str]
        :param person_types: Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.
        :type person_types: List[str]
        :param studios: Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.
        :type studios: List[str]
        :param artists: Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.
        :type artists: List[str]
        :param exclude_artist_ids: Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.
        :type exclude_artist_ids: List[str]
        :param artist_ids: Optional. If specified, results will be filtered to include only those containing the specified artist id.
        :type artist_ids: List[str]
        :param album_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified album artist id.
        :type album_artist_ids: List[str]
        :param contributing_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.
        :type contributing_artist_ids: List[str]
        :param albums: Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.
        :type albums: List[str]
        :param album_ids: Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.
        :type album_ids: List[str]
        :param ids: Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.
        :type ids: List[str]
        :param video_types: Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.
        :type video_types: List[VideoType]
        :param min_official_rating: Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).
        :type min_official_rating: str
        :param is_locked: Optional filter by items that are locked.
        :type is_locked: bool
        :param is_place_holder: Optional filter by items that are placeholders.
        :type is_place_holder: bool
        :param has_official_rating: Optional filter by items that have official ratings.
        :type has_official_rating: bool
        :param collapse_box_set_items: Whether or not to hide items behind their boxsets.
        :type collapse_box_set_items: bool
        :param min_width: Optional. Filter by the minimum width of the item.
        :type min_width: int
        :param min_height: Optional. Filter by the minimum height of the item.
        :type min_height: int
        :param max_width: Optional. Filter by the maximum width of the item.
        :type max_width: int
        :param max_height: Optional. Filter by the maximum height of the item.
        :type max_height: int
        :param is3_d: Optional filter by items that are 3D, or not.
        :type is3_d: bool
        :param series_status: Optional filter by Series Status. Allows multiple, comma delimited.
        :type series_status: List[SeriesStatus]
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param studio_ids: Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.
        :type studio_ids: List[str]
        :param genre_ids: Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.
        :type genre_ids: List[str]
        :param enable_total_record_count: Optional. Enable the total record count.
        :type enable_total_record_count: bool
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trailers_serialize(
            user_id=user_id,
            max_official_rating=max_official_rating,
            has_theme_song=has_theme_song,
            has_theme_video=has_theme_video,
            has_subtitles=has_subtitles,
            has_special_feature=has_special_feature,
            has_trailer=has_trailer,
            adjacent_to=adjacent_to,
            parent_index_number=parent_index_number,
            has_parental_rating=has_parental_rating,
            is_hd=is_hd,
            is4_k=is4_k,
            location_types=location_types,
            exclude_location_types=exclude_location_types,
            is_missing=is_missing,
            is_unaired=is_unaired,
            min_community_rating=min_community_rating,
            min_critic_rating=min_critic_rating,
            min_premiere_date=min_premiere_date,
            min_date_last_saved=min_date_last_saved,
            min_date_last_saved_for_user=min_date_last_saved_for_user,
            max_premiere_date=max_premiere_date,
            has_overview=has_overview,
            has_imdb_id=has_imdb_id,
            has_tmdb_id=has_tmdb_id,
            has_tvdb_id=has_tvdb_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            exclude_item_ids=exclude_item_ids,
            start_index=start_index,
            limit=limit,
            recursive=recursive,
            search_term=search_term,
            sort_order=sort_order,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            filters=filters,
            is_favorite=is_favorite,
            media_types=media_types,
            image_types=image_types,
            sort_by=sort_by,
            is_played=is_played,
            genres=genres,
            official_ratings=official_ratings,
            tags=tags,
            years=years,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            person=person,
            person_ids=person_ids,
            person_types=person_types,
            studios=studios,
            artists=artists,
            exclude_artist_ids=exclude_artist_ids,
            artist_ids=artist_ids,
            album_artist_ids=album_artist_ids,
            contributing_artist_ids=contributing_artist_ids,
            albums=albums,
            album_ids=album_ids,
            ids=ids,
            video_types=video_types,
            min_official_rating=min_official_rating,
            is_locked=is_locked,
            is_place_holder=is_place_holder,
            has_official_rating=has_official_rating,
            collapse_box_set_items=collapse_box_set_items,
            min_width=min_width,
            min_height=min_height,
            max_width=max_width,
            max_height=max_height,
            is3_d=is3_d,
            series_status=series_status,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            studio_ids=studio_ids,
            genre_ids=genre_ids,
            enable_total_record_count=enable_total_record_count,
            enable_images=enable_images,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_trailers_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id supplied as query parameter; this is required when not using an API key.")] = None,
        max_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).")] = None,
        has_theme_song: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme songs.")] = None,
        has_theme_video: Annotated[Optional[StrictBool], Field(description="Optional filter by items with theme videos.")] = None,
        has_subtitles: Annotated[Optional[StrictBool], Field(description="Optional filter by items with subtitles.")] = None,
        has_special_feature: Annotated[Optional[StrictBool], Field(description="Optional filter by items with special features.")] = None,
        has_trailer: Annotated[Optional[StrictBool], Field(description="Optional filter by items with trailers.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        parent_index_number: Annotated[Optional[StrictInt], Field(description="Optional filter by parent index number.")] = None,
        has_parental_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have or do not have a parental rating.")] = None,
        is_hd: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are HD or not.")] = None,
        is4_k: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 4K or not.")] = None,
        location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.")] = None,
        exclude_location_types: Annotated[Optional[List[LocationType]], Field(description="Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are missing episodes or not.")] = None,
        is_unaired: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are unaired episodes or not.")] = None,
        min_community_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum community rating.")] = None,
        min_critic_rating: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Optional filter by minimum critic rating.")] = None,
        min_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The minimum premiere date. Format = ISO.")] = None,
        min_date_last_saved: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date. Format = ISO.")] = None,
        min_date_last_saved_for_user: Annotated[Optional[datetime], Field(description="Optional. The minimum last saved date for the current user. Format = ISO.")] = None,
        max_premiere_date: Annotated[Optional[datetime], Field(description="Optional. The maximum premiere date. Format = ISO.")] = None,
        has_overview: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an overview or not.")] = None,
        has_imdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have an IMDb id or not.")] = None,
        has_tmdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TMDb id or not.")] = None,
        has_tvdb_id: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have a TVDb id or not.")] = None,
        is_movie: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv movies.")] = None,
        is_series: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv series.")] = None,
        is_news: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv news.")] = None,
        is_kids: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv kids.")] = None,
        is_sports: Annotated[Optional[StrictBool], Field(description="Optional filter for live tv sports.")] = None,
        exclude_item_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        recursive: Annotated[Optional[StrictBool], Field(description="When searching within folders, this determines whether or not the search will be recursive. true/false.")] = None,
        search_term: Annotated[Optional[StrictStr], Field(description="Optional. Filter based on a search term.")] = None,
        sort_order: Annotated[Optional[List[SortOrder]], Field(description="Sort Order - Ascending, Descending.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.")] = None,
        exclude_item_types: Annotated[Optional[List[BaseItemKind]], Field(description="Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.")] = None,
        filters: Annotated[Optional[List[ItemFilter]], Field(description="Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.")] = None,
        is_favorite: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are marked as favorite, or not.")] = None,
        media_types: Annotated[Optional[List[MediaType]], Field(description="Optional filter by MediaType. Allows multiple, comma delimited.")] = None,
        image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.")] = None,
        sort_by: Annotated[Optional[List[ItemSortBy]], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        is_played: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are played, or not.")] = None,
        genres: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.")] = None,
        official_ratings: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.")] = None,
        years: Annotated[Optional[List[StrictInt]], Field(description="Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional, include user data.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        person: Annotated[Optional[StrictStr], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person.")] = None,
        person_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified person id.")] = None,
        person_types: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.")] = None,
        studios: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.")] = None,
        artists: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.")] = None,
        exclude_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.")] = None,
        artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified artist id.")] = None,
        album_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified album artist id.")] = None,
        contributing_artist_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.")] = None,
        albums: Annotated[Optional[List[StrictStr]], Field(description="Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.")] = None,
        album_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.")] = None,
        ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.")] = None,
        video_types: Annotated[Optional[List[VideoType]], Field(description="Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.")] = None,
        min_official_rating: Annotated[Optional[StrictStr], Field(description="Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).")] = None,
        is_locked: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are locked.")] = None,
        is_place_holder: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are placeholders.")] = None,
        has_official_rating: Annotated[Optional[StrictBool], Field(description="Optional filter by items that have official ratings.")] = None,
        collapse_box_set_items: Annotated[Optional[StrictBool], Field(description="Whether or not to hide items behind their boxsets.")] = None,
        min_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum width of the item.")] = None,
        min_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the minimum height of the item.")] = None,
        max_width: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum width of the item.")] = None,
        max_height: Annotated[Optional[StrictInt], Field(description="Optional. Filter by the maximum height of the item.")] = None,
        is3_d: Annotated[Optional[StrictBool], Field(description="Optional filter by items that are 3D, or not.")] = None,
        series_status: Annotated[Optional[List[SeriesStatus]], Field(description="Optional filter by Series Status. Allows multiple, comma delimited.")] = None,
        name_starts_with_or_greater: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally or greater than a given input string.")] = None,
        name_starts_with: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is sorted equally than a given input string.")] = None,
        name_less_than: Annotated[Optional[StrictStr], Field(description="Optional filter by items whose name is equally or lesser than a given input string.")] = None,
        studio_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.")] = None,
        genre_ids: Annotated[Optional[List[UUID]], Field(description="Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Optional. Enable the total record count.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Finds movies and trailers similar to a given trailer.


        :param user_id: The user id supplied as query parameter; this is required when not using an API key.
        :type user_id: str
        :param max_official_rating: Optional filter by maximum official rating (PG, PG-13, TV-MA, etc).
        :type max_official_rating: str
        :param has_theme_song: Optional filter by items with theme songs.
        :type has_theme_song: bool
        :param has_theme_video: Optional filter by items with theme videos.
        :type has_theme_video: bool
        :param has_subtitles: Optional filter by items with subtitles.
        :type has_subtitles: bool
        :param has_special_feature: Optional filter by items with special features.
        :type has_special_feature: bool
        :param has_trailer: Optional filter by items with trailers.
        :type has_trailer: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param parent_index_number: Optional filter by parent index number.
        :type parent_index_number: int
        :param has_parental_rating: Optional filter by items that have or do not have a parental rating.
        :type has_parental_rating: bool
        :param is_hd: Optional filter by items that are HD or not.
        :type is_hd: bool
        :param is4_k: Optional filter by items that are 4K or not.
        :type is4_k: bool
        :param location_types: Optional. If specified, results will be filtered based on LocationType. This allows multiple, comma delimited.
        :type location_types: List[LocationType]
        :param exclude_location_types: Optional. If specified, results will be filtered based on the LocationType. This allows multiple, comma delimited.
        :type exclude_location_types: List[LocationType]
        :param is_missing: Optional filter by items that are missing episodes or not.
        :type is_missing: bool
        :param is_unaired: Optional filter by items that are unaired episodes or not.
        :type is_unaired: bool
        :param min_community_rating: Optional filter by minimum community rating.
        :type min_community_rating: float
        :param min_critic_rating: Optional filter by minimum critic rating.
        :type min_critic_rating: float
        :param min_premiere_date: Optional. The minimum premiere date. Format = ISO.
        :type min_premiere_date: datetime
        :param min_date_last_saved: Optional. The minimum last saved date. Format = ISO.
        :type min_date_last_saved: datetime
        :param min_date_last_saved_for_user: Optional. The minimum last saved date for the current user. Format = ISO.
        :type min_date_last_saved_for_user: datetime
        :param max_premiere_date: Optional. The maximum premiere date. Format = ISO.
        :type max_premiere_date: datetime
        :param has_overview: Optional filter by items that have an overview or not.
        :type has_overview: bool
        :param has_imdb_id: Optional filter by items that have an IMDb id or not.
        :type has_imdb_id: bool
        :param has_tmdb_id: Optional filter by items that have a TMDb id or not.
        :type has_tmdb_id: bool
        :param has_tvdb_id: Optional filter by items that have a TVDb id or not.
        :type has_tvdb_id: bool
        :param is_movie: Optional filter for live tv movies.
        :type is_movie: bool
        :param is_series: Optional filter for live tv series.
        :type is_series: bool
        :param is_news: Optional filter for live tv news.
        :type is_news: bool
        :param is_kids: Optional filter for live tv kids.
        :type is_kids: bool
        :param is_sports: Optional filter for live tv sports.
        :type is_sports: bool
        :param exclude_item_ids: Optional. If specified, results will be filtered by excluding item ids. This allows multiple, comma delimited.
        :type exclude_item_ids: List[str]
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param recursive: When searching within folders, this determines whether or not the search will be recursive. true/false.
        :type recursive: bool
        :param search_term: Optional. Filter based on a search term.
        :type search_term: str
        :param sort_order: Sort Order - Ascending, Descending.
        :type sort_order: List[SortOrder]
        :param parent_id: Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines.
        :type fields: List[ItemFields]
        :param exclude_item_types: Optional. If specified, results will be filtered based on item type. This allows multiple, comma delimited.
        :type exclude_item_types: List[BaseItemKind]
        :param filters: Optional. Specify additional filters to apply. This allows multiple, comma delimited. Options: IsFolder, IsNotFolder, IsUnplayed, IsPlayed, IsFavorite, IsResumable, Likes, Dislikes.
        :type filters: List[ItemFilter]
        :param is_favorite: Optional filter by items that are marked as favorite, or not.
        :type is_favorite: bool
        :param media_types: Optional filter by MediaType. Allows multiple, comma delimited.
        :type media_types: List[MediaType]
        :param image_types: Optional. If specified, results will be filtered based on those containing image types. This allows multiple, comma delimited.
        :type image_types: List[ImageType]
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: List[ItemSortBy]
        :param is_played: Optional filter by items that are played, or not.
        :type is_played: bool
        :param genres: Optional. If specified, results will be filtered based on genre. This allows multiple, pipe delimited.
        :type genres: List[str]
        :param official_ratings: Optional. If specified, results will be filtered based on OfficialRating. This allows multiple, pipe delimited.
        :type official_ratings: List[str]
        :param tags: Optional. If specified, results will be filtered based on tag. This allows multiple, pipe delimited.
        :type tags: List[str]
        :param years: Optional. If specified, results will be filtered based on production year. This allows multiple, comma delimited.
        :type years: List[int]
        :param enable_user_data: Optional, include user data.
        :type enable_user_data: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param person: Optional. If specified, results will be filtered to include only those containing the specified person.
        :type person: str
        :param person_ids: Optional. If specified, results will be filtered to include only those containing the specified person id.
        :type person_ids: List[str]
        :param person_types: Optional. If specified, along with Person, results will be filtered to include only those containing the specified person and PersonType. Allows multiple, comma-delimited.
        :type person_types: List[str]
        :param studios: Optional. If specified, results will be filtered based on studio. This allows multiple, pipe delimited.
        :type studios: List[str]
        :param artists: Optional. If specified, results will be filtered based on artists. This allows multiple, pipe delimited.
        :type artists: List[str]
        :param exclude_artist_ids: Optional. If specified, results will be filtered based on artist id. This allows multiple, pipe delimited.
        :type exclude_artist_ids: List[str]
        :param artist_ids: Optional. If specified, results will be filtered to include only those containing the specified artist id.
        :type artist_ids: List[str]
        :param album_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified album artist id.
        :type album_artist_ids: List[str]
        :param contributing_artist_ids: Optional. If specified, results will be filtered to include only those containing the specified contributing artist id.
        :type contributing_artist_ids: List[str]
        :param albums: Optional. If specified, results will be filtered based on album. This allows multiple, pipe delimited.
        :type albums: List[str]
        :param album_ids: Optional. If specified, results will be filtered based on album id. This allows multiple, pipe delimited.
        :type album_ids: List[str]
        :param ids: Optional. If specific items are needed, specify a list of item id's to retrieve. This allows multiple, comma delimited.
        :type ids: List[str]
        :param video_types: Optional filter by VideoType (videofile, dvd, bluray, iso). Allows multiple, comma delimited.
        :type video_types: List[VideoType]
        :param min_official_rating: Optional filter by minimum official rating (PG, PG-13, TV-MA, etc).
        :type min_official_rating: str
        :param is_locked: Optional filter by items that are locked.
        :type is_locked: bool
        :param is_place_holder: Optional filter by items that are placeholders.
        :type is_place_holder: bool
        :param has_official_rating: Optional filter by items that have official ratings.
        :type has_official_rating: bool
        :param collapse_box_set_items: Whether or not to hide items behind their boxsets.
        :type collapse_box_set_items: bool
        :param min_width: Optional. Filter by the minimum width of the item.
        :type min_width: int
        :param min_height: Optional. Filter by the minimum height of the item.
        :type min_height: int
        :param max_width: Optional. Filter by the maximum width of the item.
        :type max_width: int
        :param max_height: Optional. Filter by the maximum height of the item.
        :type max_height: int
        :param is3_d: Optional filter by items that are 3D, or not.
        :type is3_d: bool
        :param series_status: Optional filter by Series Status. Allows multiple, comma delimited.
        :type series_status: List[SeriesStatus]
        :param name_starts_with_or_greater: Optional filter by items whose name is sorted equally or greater than a given input string.
        :type name_starts_with_or_greater: str
        :param name_starts_with: Optional filter by items whose name is sorted equally than a given input string.
        :type name_starts_with: str
        :param name_less_than: Optional filter by items whose name is equally or lesser than a given input string.
        :type name_less_than: str
        :param studio_ids: Optional. If specified, results will be filtered based on studio id. This allows multiple, pipe delimited.
        :type studio_ids: List[str]
        :param genre_ids: Optional. If specified, results will be filtered based on genre id. This allows multiple, pipe delimited.
        :type genre_ids: List[str]
        :param enable_total_record_count: Optional. Enable the total record count.
        :type enable_total_record_count: bool
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trailers_serialize(
            user_id=user_id,
            max_official_rating=max_official_rating,
            has_theme_song=has_theme_song,
            has_theme_video=has_theme_video,
            has_subtitles=has_subtitles,
            has_special_feature=has_special_feature,
            has_trailer=has_trailer,
            adjacent_to=adjacent_to,
            parent_index_number=parent_index_number,
            has_parental_rating=has_parental_rating,
            is_hd=is_hd,
            is4_k=is4_k,
            location_types=location_types,
            exclude_location_types=exclude_location_types,
            is_missing=is_missing,
            is_unaired=is_unaired,
            min_community_rating=min_community_rating,
            min_critic_rating=min_critic_rating,
            min_premiere_date=min_premiere_date,
            min_date_last_saved=min_date_last_saved,
            min_date_last_saved_for_user=min_date_last_saved_for_user,
            max_premiere_date=max_premiere_date,
            has_overview=has_overview,
            has_imdb_id=has_imdb_id,
            has_tmdb_id=has_tmdb_id,
            has_tvdb_id=has_tvdb_id,
            is_movie=is_movie,
            is_series=is_series,
            is_news=is_news,
            is_kids=is_kids,
            is_sports=is_sports,
            exclude_item_ids=exclude_item_ids,
            start_index=start_index,
            limit=limit,
            recursive=recursive,
            search_term=search_term,
            sort_order=sort_order,
            parent_id=parent_id,
            fields=fields,
            exclude_item_types=exclude_item_types,
            filters=filters,
            is_favorite=is_favorite,
            media_types=media_types,
            image_types=image_types,
            sort_by=sort_by,
            is_played=is_played,
            genres=genres,
            official_ratings=official_ratings,
            tags=tags,
            years=years,
            enable_user_data=enable_user_data,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            person=person,
            person_ids=person_ids,
            person_types=person_types,
            studios=studios,
            artists=artists,
            exclude_artist_ids=exclude_artist_ids,
            artist_ids=artist_ids,
            album_artist_ids=album_artist_ids,
            contributing_artist_ids=contributing_artist_ids,
            albums=albums,
            album_ids=album_ids,
            ids=ids,
            video_types=video_types,
            min_official_rating=min_official_rating,
            is_locked=is_locked,
            is_place_holder=is_place_holder,
            has_official_rating=has_official_rating,
            collapse_box_set_items=collapse_box_set_items,
            min_width=min_width,
            min_height=min_height,
            max_width=max_width,
            max_height=max_height,
            is3_d=is3_d,
            series_status=series_status,
            name_starts_with_or_greater=name_starts_with_or_greater,
            name_starts_with=name_starts_with,
            name_less_than=name_less_than,
            studio_ids=studio_ids,
            genre_ids=genre_ids,
            enable_total_record_count=enable_total_record_count,
            enable_images=enable_images,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trailers_serialize(
        self,
        user_id,
        max_official_rating,
        has_theme_song,
        has_theme_video,
        has_subtitles,
        has_special_feature,
        has_trailer,
        adjacent_to,
        parent_index_number,
        has_parental_rating,
        is_hd,
        is4_k,
        location_types,
        exclude_location_types,
        is_missing,
        is_unaired,
        min_community_rating,
        min_critic_rating,
        min_premiere_date,
        min_date_last_saved,
        min_date_last_saved_for_user,
        max_premiere_date,
        has_overview,
        has_imdb_id,
        has_tmdb_id,
        has_tvdb_id,
        is_movie,
        is_series,
        is_news,
        is_kids,
        is_sports,
        exclude_item_ids,
        start_index,
        limit,
        recursive,
        search_term,
        sort_order,
        parent_id,
        fields,
        exclude_item_types,
        filters,
        is_favorite,
        media_types,
        image_types,
        sort_by,
        is_played,
        genres,
        official_ratings,
        tags,
        years,
        enable_user_data,
        image_type_limit,
        enable_image_types,
        person,
        person_ids,
        person_types,
        studios,
        artists,
        exclude_artist_ids,
        artist_ids,
        album_artist_ids,
        contributing_artist_ids,
        albums,
        album_ids,
        ids,
        video_types,
        min_official_rating,
        is_locked,
        is_place_holder,
        has_official_rating,
        collapse_box_set_items,
        min_width,
        min_height,
        max_width,
        max_height,
        is3_d,
        series_status,
        name_starts_with_or_greater,
        name_starts_with,
        name_less_than,
        studio_ids,
        genre_ids,
        enable_total_record_count,
        enable_images,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'locationTypes': 'multi',
            'excludeLocationTypes': 'multi',
            'excludeItemIds': 'multi',
            'sortOrder': 'multi',
            'fields': 'multi',
            'excludeItemTypes': 'multi',
            'filters': 'multi',
            'mediaTypes': 'multi',
            'imageTypes': 'multi',
            'sortBy': 'multi',
            'genres': 'multi',
            'officialRatings': 'multi',
            'tags': 'multi',
            'years': 'multi',
            'enableImageTypes': 'multi',
            'personIds': 'multi',
            'personTypes': 'multi',
            'studios': 'multi',
            'artists': 'multi',
            'excludeArtistIds': 'multi',
            'artistIds': 'multi',
            'albumArtistIds': 'multi',
            'contributingArtistIds': 'multi',
            'albums': 'multi',
            'albumIds': 'multi',
            'ids': 'multi',
            'videoTypes': 'multi',
            'seriesStatus': 'multi',
            'studioIds': 'multi',
            'genreIds': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if max_official_rating is not None:
            
            _query_params.append(('maxOfficialRating', max_official_rating))
            
        if has_theme_song is not None:
            
            _query_params.append(('hasThemeSong', has_theme_song))
            
        if has_theme_video is not None:
            
            _query_params.append(('hasThemeVideo', has_theme_video))
            
        if has_subtitles is not None:
            
            _query_params.append(('hasSubtitles', has_subtitles))
            
        if has_special_feature is not None:
            
            _query_params.append(('hasSpecialFeature', has_special_feature))
            
        if has_trailer is not None:
            
            _query_params.append(('hasTrailer', has_trailer))
            
        if adjacent_to is not None:
            
            _query_params.append(('adjacentTo', adjacent_to))
            
        if parent_index_number is not None:
            
            _query_params.append(('parentIndexNumber', parent_index_number))
            
        if has_parental_rating is not None:
            
            _query_params.append(('hasParentalRating', has_parental_rating))
            
        if is_hd is not None:
            
            _query_params.append(('isHd', is_hd))
            
        if is4_k is not None:
            
            _query_params.append(('is4K', is4_k))
            
        if location_types is not None:
            
            _query_params.append(('locationTypes', location_types))
            
        if exclude_location_types is not None:
            
            _query_params.append(('excludeLocationTypes', exclude_location_types))
            
        if is_missing is not None:
            
            _query_params.append(('isMissing', is_missing))
            
        if is_unaired is not None:
            
            _query_params.append(('isUnaired', is_unaired))
            
        if min_community_rating is not None:
            
            _query_params.append(('minCommunityRating', min_community_rating))
            
        if min_critic_rating is not None:
            
            _query_params.append(('minCriticRating', min_critic_rating))
            
        if min_premiere_date is not None:
            if isinstance(min_premiere_date, datetime):
                _query_params.append(
                    (
                        'minPremiereDate',
                        min_premiere_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minPremiereDate', min_premiere_date))
            
        if min_date_last_saved is not None:
            if isinstance(min_date_last_saved, datetime):
                _query_params.append(
                    (
                        'minDateLastSaved',
                        min_date_last_saved.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minDateLastSaved', min_date_last_saved))
            
        if min_date_last_saved_for_user is not None:
            if isinstance(min_date_last_saved_for_user, datetime):
                _query_params.append(
                    (
                        'minDateLastSavedForUser',
                        min_date_last_saved_for_user.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('minDateLastSavedForUser', min_date_last_saved_for_user))
            
        if max_premiere_date is not None:
            if isinstance(max_premiere_date, datetime):
                _query_params.append(
                    (
                        'maxPremiereDate',
                        max_premiere_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('maxPremiereDate', max_premiere_date))
            
        if has_overview is not None:
            
            _query_params.append(('hasOverview', has_overview))
            
        if has_imdb_id is not None:
            
            _query_params.append(('hasImdbId', has_imdb_id))
            
        if has_tmdb_id is not None:
            
            _query_params.append(('hasTmdbId', has_tmdb_id))
            
        if has_tvdb_id is not None:
            
            _query_params.append(('hasTvdbId', has_tvdb_id))
            
        if is_movie is not None:
            
            _query_params.append(('isMovie', is_movie))
            
        if is_series is not None:
            
            _query_params.append(('isSeries', is_series))
            
        if is_news is not None:
            
            _query_params.append(('isNews', is_news))
            
        if is_kids is not None:
            
            _query_params.append(('isKids', is_kids))
            
        if is_sports is not None:
            
            _query_params.append(('isSports', is_sports))
            
        if exclude_item_ids is not None:
            
            _query_params.append(('excludeItemIds', exclude_item_ids))
            
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if recursive is not None:
            
            _query_params.append(('recursive', recursive))
            
        if search_term is not None:
            
            _query_params.append(('searchTerm', search_term))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_item_types is not None:
            
            _query_params.append(('excludeItemTypes', exclude_item_types))
            
        if filters is not None:
            
            _query_params.append(('filters', filters))
            
        if is_favorite is not None:
            
            _query_params.append(('isFavorite', is_favorite))
            
        if media_types is not None:
            
            _query_params.append(('mediaTypes', media_types))
            
        if image_types is not None:
            
            _query_params.append(('imageTypes', image_types))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by))
            
        if is_played is not None:
            
            _query_params.append(('isPlayed', is_played))
            
        if genres is not None:
            
            _query_params.append(('genres', genres))
            
        if official_ratings is not None:
            
            _query_params.append(('officialRatings', official_ratings))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if years is not None:
            
            _query_params.append(('years', years))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if person is not None:
            
            _query_params.append(('person', person))
            
        if person_ids is not None:
            
            _query_params.append(('personIds', person_ids))
            
        if person_types is not None:
            
            _query_params.append(('personTypes', person_types))
            
        if studios is not None:
            
            _query_params.append(('studios', studios))
            
        if artists is not None:
            
            _query_params.append(('artists', artists))
            
        if exclude_artist_ids is not None:
            
            _query_params.append(('excludeArtistIds', exclude_artist_ids))
            
        if artist_ids is not None:
            
            _query_params.append(('artistIds', artist_ids))
            
        if album_artist_ids is not None:
            
            _query_params.append(('albumArtistIds', album_artist_ids))
            
        if contributing_artist_ids is not None:
            
            _query_params.append(('contributingArtistIds', contributing_artist_ids))
            
        if albums is not None:
            
            _query_params.append(('albums', albums))
            
        if album_ids is not None:
            
            _query_params.append(('albumIds', album_ids))
            
        if ids is not None:
            
            _query_params.append(('ids', ids))
            
        if video_types is not None:
            
            _query_params.append(('videoTypes', video_types))
            
        if min_official_rating is not None:
            
            _query_params.append(('minOfficialRating', min_official_rating))
            
        if is_locked is not None:
            
            _query_params.append(('isLocked', is_locked))
            
        if is_place_holder is not None:
            
            _query_params.append(('isPlaceHolder', is_place_holder))
            
        if has_official_rating is not None:
            
            _query_params.append(('hasOfficialRating', has_official_rating))
            
        if collapse_box_set_items is not None:
            
            _query_params.append(('collapseBoxSetItems', collapse_box_set_items))
            
        if min_width is not None:
            
            _query_params.append(('minWidth', min_width))
            
        if min_height is not None:
            
            _query_params.append(('minHeight', min_height))
            
        if max_width is not None:
            
            _query_params.append(('maxWidth', max_width))
            
        if max_height is not None:
            
            _query_params.append(('maxHeight', max_height))
            
        if is3_d is not None:
            
            _query_params.append(('is3D', is3_d))
            
        if series_status is not None:
            
            _query_params.append(('seriesStatus', series_status))
            
        if name_starts_with_or_greater is not None:
            
            _query_params.append(('nameStartsWithOrGreater', name_starts_with_or_greater))
            
        if name_starts_with is not None:
            
            _query_params.append(('nameStartsWith', name_starts_with))
            
        if name_less_than is not None:
            
            _query_params.append(('nameLessThan', name_less_than))
            
        if studio_ids is not None:
            
            _query_params.append(('studioIds', studio_ids))
            
        if genre_ids is not None:
            
            _query_params.append(('genreIds', genre_ids))
            
        if enable_total_record_count is not None:
            
            _query_params.append(('enableTotalRecordCount', enable_total_record_count))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Trailers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


