# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_dto_query_result import BaseItemDtoQueryResult
from jellyfin.generated.api_10_11.models.image_type import ImageType
from jellyfin.generated.api_10_11.models.item_fields import ItemFields

from jellyfin.generated.api_10_11.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_11.api_response import ApiResponse
from jellyfin.generated.api_10_11.rest import RESTResponseType


class TvShowsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_episodes(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        season: Annotated[Optional[StrictInt], Field(description="Optional filter by season number.")] = None,
        season_id: Annotated[Optional[UUID], Field(description="Optional. Filter by season id.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        start_item_id: Annotated[Optional[UUID], Field(description="Optional. Skip through the list until a given item is found.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Gets episodes for a tv season.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param season: Optional filter by season number.
        :type season: int
        :param season_id: Optional. Filter by season id.
        :type season_id: str
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param start_item_id: Optional. Skip through the list until a given item is found.
        :type start_item_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: ItemSortBy
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_episodes_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            season=season,
            season_id=season_id,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            start_item_id=start_item_id,
            start_index=start_index,
            limit=limit,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            sort_by=sort_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_episodes_with_http_info(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        season: Annotated[Optional[StrictInt], Field(description="Optional filter by season number.")] = None,
        season_id: Annotated[Optional[UUID], Field(description="Optional. Filter by season id.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        start_item_id: Annotated[Optional[UUID], Field(description="Optional. Skip through the list until a given item is found.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Gets episodes for a tv season.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param season: Optional filter by season number.
        :type season: int
        :param season_id: Optional. Filter by season id.
        :type season_id: str
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param start_item_id: Optional. Skip through the list until a given item is found.
        :type start_item_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: ItemSortBy
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_episodes_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            season=season,
            season_id=season_id,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            start_item_id=start_item_id,
            start_index=start_index,
            limit=limit,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            sort_by=sort_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_episodes_without_preload_content(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        season: Annotated[Optional[StrictInt], Field(description="Optional filter by season number.")] = None,
        season_id: Annotated[Optional[UUID], Field(description="Optional. Filter by season id.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        start_item_id: Annotated[Optional[UUID], Field(description="Optional. Skip through the list until a given item is found.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional, include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional, the max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets episodes for a tv season.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param season: Optional filter by season number.
        :type season: int
        :param season_id: Optional. Filter by season id.
        :type season_id: str
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param start_item_id: Optional. Skip through the list until a given item is found.
        :type start_item_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param enable_images: Optional, include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional, the max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param sort_by: Optional. Specify one or more sort orders, comma delimited. Options: Album, AlbumArtist, Artist, Budget, CommunityRating, CriticRating, DateCreated, DatePlayed, PlayCount, PremiereDate, ProductionYear, SortName, Random, Revenue, Runtime.
        :type sort_by: ItemSortBy
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_episodes_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            season=season,
            season_id=season_id,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            start_item_id=start_item_id,
            start_index=start_index,
            limit=limit,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            sort_by=sort_by,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_episodes_serialize(
        self,
        series_id,
        user_id,
        fields,
        season,
        season_id,
        is_missing,
        adjacent_to,
        start_item_id,
        start_index,
        limit,
        enable_images,
        image_type_limit,
        enable_image_types,
        enable_user_data,
        sort_by,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields': 'multi',
            'enableImageTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if series_id is not None:
            _path_params['seriesId'] = series_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if season is not None:
            
            _query_params.append(('season', season))
            
        if season_id is not None:
            
            _query_params.append(('seasonId', season_id))
            
        if is_missing is not None:
            
            _query_params.append(('isMissing', is_missing))
            
        if adjacent_to is not None:
            
            _query_params.append(('adjacentTo', adjacent_to))
            
        if start_item_id is not None:
            
            _query_params.append(('startItemId', start_item_id))
            
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Shows/{seriesId}/Episodes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_next_up(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the next up episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        series_id: Annotated[Optional[UUID], Field(description="Optional. Filter by series id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        next_up_date_cutoff: Annotated[Optional[datetime], Field(description="Optional. Starting date of shows to show in Next Up section.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Whether to enable the total records count. Defaults to true.")] = None,
        disable_first_episode: Annotated[Optional[StrictBool], Field(description="Whether to disable sending the first episode in a series as next up.")] = None,
        enable_resumable: Annotated[Optional[StrictBool], Field(description="Whether to include resumable episodes in next up results.")] = None,
        enable_rewatching: Annotated[Optional[StrictBool], Field(description="Whether to include watched episodes in next up results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Gets a list of next up episodes.


        :param user_id: The user id of the user to get the next up episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param series_id: Optional. Filter by series id.
        :type series_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param next_up_date_cutoff: Optional. Starting date of shows to show in Next Up section.
        :type next_up_date_cutoff: datetime
        :param enable_total_record_count: Whether to enable the total records count. Defaults to true.
        :type enable_total_record_count: bool
        :param disable_first_episode: Whether to disable sending the first episode in a series as next up.
        :type disable_first_episode: bool
        :param enable_resumable: Whether to include resumable episodes in next up results.
        :type enable_resumable: bool
        :param enable_rewatching: Whether to include watched episodes in next up results.
        :type enable_rewatching: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_next_up_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            series_id=series_id,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            next_up_date_cutoff=next_up_date_cutoff,
            enable_total_record_count=enable_total_record_count,
            disable_first_episode=disable_first_episode,
            enable_resumable=enable_resumable,
            enable_rewatching=enable_rewatching,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_next_up_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the next up episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        series_id: Annotated[Optional[UUID], Field(description="Optional. Filter by series id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        next_up_date_cutoff: Annotated[Optional[datetime], Field(description="Optional. Starting date of shows to show in Next Up section.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Whether to enable the total records count. Defaults to true.")] = None,
        disable_first_episode: Annotated[Optional[StrictBool], Field(description="Whether to disable sending the first episode in a series as next up.")] = None,
        enable_resumable: Annotated[Optional[StrictBool], Field(description="Whether to include resumable episodes in next up results.")] = None,
        enable_rewatching: Annotated[Optional[StrictBool], Field(description="Whether to include watched episodes in next up results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Gets a list of next up episodes.


        :param user_id: The user id of the user to get the next up episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param series_id: Optional. Filter by series id.
        :type series_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param next_up_date_cutoff: Optional. Starting date of shows to show in Next Up section.
        :type next_up_date_cutoff: datetime
        :param enable_total_record_count: Whether to enable the total records count. Defaults to true.
        :type enable_total_record_count: bool
        :param disable_first_episode: Whether to disable sending the first episode in a series as next up.
        :type disable_first_episode: bool
        :param enable_resumable: Whether to include resumable episodes in next up results.
        :type enable_resumable: bool
        :param enable_rewatching: Whether to include watched episodes in next up results.
        :type enable_rewatching: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_next_up_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            series_id=series_id,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            next_up_date_cutoff=next_up_date_cutoff,
            enable_total_record_count=enable_total_record_count,
            disable_first_episode=disable_first_episode,
            enable_resumable=enable_resumable,
            enable_rewatching=enable_rewatching,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_next_up_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the next up episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        series_id: Annotated[Optional[UUID], Field(description="Optional. Filter by series id.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        next_up_date_cutoff: Annotated[Optional[datetime], Field(description="Optional. Starting date of shows to show in Next Up section.")] = None,
        enable_total_record_count: Annotated[Optional[StrictBool], Field(description="Whether to enable the total records count. Defaults to true.")] = None,
        disable_first_episode: Annotated[Optional[StrictBool], Field(description="Whether to disable sending the first episode in a series as next up.")] = None,
        enable_resumable: Annotated[Optional[StrictBool], Field(description="Whether to include resumable episodes in next up results.")] = None,
        enable_rewatching: Annotated[Optional[StrictBool], Field(description="Whether to include watched episodes in next up results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets a list of next up episodes.


        :param user_id: The user id of the user to get the next up episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param series_id: Optional. Filter by series id.
        :type series_id: str
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param next_up_date_cutoff: Optional. Starting date of shows to show in Next Up section.
        :type next_up_date_cutoff: datetime
        :param enable_total_record_count: Whether to enable the total records count. Defaults to true.
        :type enable_total_record_count: bool
        :param disable_first_episode: Whether to disable sending the first episode in a series as next up.
        :type disable_first_episode: bool
        :param enable_resumable: Whether to include resumable episodes in next up results.
        :type enable_resumable: bool
        :param enable_rewatching: Whether to include watched episodes in next up results.
        :type enable_rewatching: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_next_up_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            series_id=series_id,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            next_up_date_cutoff=next_up_date_cutoff,
            enable_total_record_count=enable_total_record_count,
            disable_first_episode=disable_first_episode,
            enable_resumable=enable_resumable,
            enable_rewatching=enable_rewatching,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_next_up_serialize(
        self,
        user_id,
        start_index,
        limit,
        fields,
        series_id,
        parent_id,
        enable_images,
        image_type_limit,
        enable_image_types,
        enable_user_data,
        next_up_date_cutoff,
        enable_total_record_count,
        disable_first_episode,
        enable_resumable,
        enable_rewatching,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields': 'multi',
            'enableImageTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if series_id is not None:
            
            _query_params.append(('seriesId', series_id))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        if next_up_date_cutoff is not None:
            if isinstance(next_up_date_cutoff, datetime):
                _query_params.append(
                    (
                        'nextUpDateCutoff',
                        next_up_date_cutoff.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('nextUpDateCutoff', next_up_date_cutoff))
            
        if enable_total_record_count is not None:
            
            _query_params.append(('enableTotalRecordCount', enable_total_record_count))
            
        if disable_first_episode is not None:
            
            _query_params.append(('disableFirstEpisode', disable_first_episode))
            
        if enable_resumable is not None:
            
            _query_params.append(('enableResumable', enable_resumable))
            
        if enable_rewatching is not None:
            
            _query_params.append(('enableRewatching', enable_rewatching))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Shows/NextUp',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_seasons(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        is_special_season: Annotated[Optional[StrictBool], Field(description="Optional. Filter by special season.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Gets seasons for a tv series.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param is_special_season: Optional. Filter by special season.
        :type is_special_season: bool
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_seasons_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            is_special_season=is_special_season,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_seasons_with_http_info(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        is_special_season: Annotated[Optional[StrictBool], Field(description="Optional. Filter by special season.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Gets seasons for a tv series.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param is_special_season: Optional. Filter by special season.
        :type is_special_season: bool
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_seasons_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            is_special_season=is_special_season,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_seasons_without_preload_content(
        self,
        series_id: Annotated[UUID, Field(description="The series id.")],
        user_id: Annotated[Optional[UUID], Field(description="The user id.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.")] = None,
        is_special_season: Annotated[Optional[StrictBool], Field(description="Optional. Filter by special season.")] = None,
        is_missing: Annotated[Optional[StrictBool], Field(description="Optional. Filter by items that are missing episodes or not.")] = None,
        adjacent_to: Annotated[Optional[UUID], Field(description="Optional. Return items that are siblings of a supplied item.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets seasons for a tv series.


        :param series_id: The series id. (required)
        :type series_id: str
        :param user_id: The user id.
        :type user_id: str
        :param fields: Optional. Specify additional fields of information to return in the output. This allows multiple, comma delimited. Options: Budget, Chapters, DateCreated, Genres, HomePageUrl, IndexOptions, MediaStreams, Overview, ParentId, Path, People, ProviderIds, PrimaryImageAspectRatio, Revenue, SortName, Studios, Taglines, TrailerUrls.
        :type fields: List[ItemFields]
        :param is_special_season: Optional. Filter by special season.
        :type is_special_season: bool
        :param is_missing: Optional. Filter by items that are missing episodes or not.
        :type is_missing: bool
        :param adjacent_to: Optional. Return items that are siblings of a supplied item.
        :type adjacent_to: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_seasons_serialize(
            series_id=series_id,
            user_id=user_id,
            fields=fields,
            is_special_season=is_special_season,
            is_missing=is_missing,
            adjacent_to=adjacent_to,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_seasons_serialize(
        self,
        series_id,
        user_id,
        fields,
        is_special_season,
        is_missing,
        adjacent_to,
        enable_images,
        image_type_limit,
        enable_image_types,
        enable_user_data,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields': 'multi',
            'enableImageTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if series_id is not None:
            _path_params['seriesId'] = series_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if is_special_season is not None:
            
            _query_params.append(('isSpecialSeason', is_special_season))
            
        if is_missing is not None:
            
            _query_params.append(('isMissing', is_missing))
            
        if adjacent_to is not None:
            
            _query_params.append(('adjacentTo', adjacent_to))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Shows/{seriesId}/Seasons',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_upcoming_episodes(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the upcoming episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseItemDtoQueryResult:
        """Gets a list of upcoming episodes.


        :param user_id: The user id of the user to get the upcoming episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_upcoming_episodes_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_upcoming_episodes_with_http_info(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the upcoming episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseItemDtoQueryResult]:
        """Gets a list of upcoming episodes.


        :param user_id: The user id of the user to get the upcoming episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_upcoming_episodes_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_upcoming_episodes_without_preload_content(
        self,
        user_id: Annotated[Optional[UUID], Field(description="The user id of the user to get the upcoming episodes for.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="Optional. The record index to start at. All items with a lower index will be dropped from the results.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of records to return.")] = None,
        fields: Annotated[Optional[List[ItemFields]], Field(description="Optional. Specify additional fields of information to return in the output.")] = None,
        parent_id: Annotated[Optional[UUID], Field(description="Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.")] = None,
        enable_images: Annotated[Optional[StrictBool], Field(description="Optional. Include image information in output.")] = None,
        image_type_limit: Annotated[Optional[StrictInt], Field(description="Optional. The max number of images to return, per image type.")] = None,
        enable_image_types: Annotated[Optional[List[ImageType]], Field(description="Optional. The image types to include in the output.")] = None,
        enable_user_data: Annotated[Optional[StrictBool], Field(description="Optional. Include user data.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets a list of upcoming episodes.


        :param user_id: The user id of the user to get the upcoming episodes for.
        :type user_id: str
        :param start_index: Optional. The record index to start at. All items with a lower index will be dropped from the results.
        :type start_index: int
        :param limit: Optional. The maximum number of records to return.
        :type limit: int
        :param fields: Optional. Specify additional fields of information to return in the output.
        :type fields: List[ItemFields]
        :param parent_id: Optional. Specify this to localize the search to a specific item or folder. Omit to use the root.
        :type parent_id: str
        :param enable_images: Optional. Include image information in output.
        :type enable_images: bool
        :param image_type_limit: Optional. The max number of images to return, per image type.
        :type image_type_limit: int
        :param enable_image_types: Optional. The image types to include in the output.
        :type enable_image_types: List[ImageType]
        :param enable_user_data: Optional. Include user data.
        :type enable_user_data: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_upcoming_episodes_serialize(
            user_id=user_id,
            start_index=start_index,
            limit=limit,
            fields=fields,
            parent_id=parent_id,
            enable_images=enable_images,
            image_type_limit=image_type_limit,
            enable_image_types=enable_image_types,
            enable_user_data=enable_user_data,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseItemDtoQueryResult",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_upcoming_episodes_serialize(
        self,
        user_id,
        start_index,
        limit,
        fields,
        parent_id,
        enable_images,
        image_type_limit,
        enable_image_types,
        enable_user_data,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields': 'multi',
            'enableImageTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if parent_id is not None:
            
            _query_params.append(('parentId', parent_id))
            
        if enable_images is not None:
            
            _query_params.append(('enableImages', enable_images))
            
        if image_type_limit is not None:
            
            _query_params.append(('imageTypeLimit', image_type_limit))
            
        if enable_image_types is not None:
            
            _query_params.append(('enableImageTypes', enable_image_types))
            
        if enable_user_data is not None:
            
            _query_params.append(('enableUserData', enable_user_data))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Shows/Upcoming',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


