# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr, field_validator
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from uuid import UUID

from jellyfin.generated.api_10_11.api_client import ApiClient, RequestSerialized
from jellyfin.generated.api_10_11.api_response import ApiResponse
from jellyfin.generated.api_10_11.rest import RESTResponseType


class UniversalAudioApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_universal_audio_stream(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_universal_audio_stream_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_universal_audio_stream_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_universal_audio_stream_serialize(
        self,
        item_id,
        container,
        media_source_id,
        device_id,
        user_id,
        audio_codec,
        max_audio_channels,
        transcoding_audio_channels,
        max_streaming_bitrate,
        audio_bit_rate,
        start_time_ticks,
        transcoding_container,
        transcoding_protocol,
        max_audio_sample_rate,
        max_audio_bit_depth,
        enable_remote_media,
        enable_audio_vbr_encoding,
        break_on_non_key_frames,
        enable_redirection,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'container': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if container is not None:
            
            _query_params.append(('container', container))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if transcoding_audio_channels is not None:
            
            _query_params.append(('transcodingAudioChannels', transcoding_audio_channels))
            
        if max_streaming_bitrate is not None:
            
            _query_params.append(('maxStreamingBitrate', max_streaming_bitrate))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if transcoding_container is not None:
            
            _query_params.append(('transcodingContainer', transcoding_container))
            
        if transcoding_protocol is not None:
            
            _query_params.append(('transcodingProtocol', transcoding_protocol.value))
            
        if max_audio_sample_rate is not None:
            
            _query_params.append(('maxAudioSampleRate', max_audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if enable_remote_media is not None:
            
            _query_params.append(('enableRemoteMedia', enable_remote_media))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if enable_redirection is not None:
            
            _query_params.append(('enableRedirection', enable_redirection))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/Audio/{itemId}/universal',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def head_universal_audio_stream(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def head_universal_audio_stream_with_http_info(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def head_universal_audio_stream_without_preload_content(
        self,
        item_id: Annotated[UUID, Field(description="The item id.")],
        container: Annotated[Optional[List[StrictStr]], Field(description="Optional. The audio container.")] = None,
        media_source_id: Annotated[Optional[StrictStr], Field(description="The media version id, if playing an alternate version.")] = None,
        device_id: Annotated[Optional[StrictStr], Field(description="The device id of the client requesting. Used to stop encoding processes when needed.")] = None,
        user_id: Annotated[Optional[UUID], Field(description="Optional. The user id.")] = None,
        audio_codec: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The audio codec to transcode to.")] = None,
        max_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The maximum number of audio channels.")] = None,
        transcoding_audio_channels: Annotated[Optional[StrictInt], Field(description="Optional. The number of how many audio channels to transcode to.")] = None,
        max_streaming_bitrate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum streaming bitrate.")] = None,
        audio_bit_rate: Annotated[Optional[StrictInt], Field(description="Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.")] = None,
        start_time_ticks: Annotated[Optional[StrictInt], Field(description="Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.")] = None,
        transcoding_container: Annotated[Optional[Annotated[str, Field(strict=True)]], Field(description="Optional. The container to transcode to.")] = None,
        transcoding_protocol: Annotated[Optional[StrictStr], Field(description="Optional. The transcoding protocol.")] = None,
        max_audio_sample_rate: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio sample rate.")] = None,
        max_audio_bit_depth: Annotated[Optional[StrictInt], Field(description="Optional. The maximum audio bit depth.")] = None,
        enable_remote_media: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable remote media.")] = None,
        enable_audio_vbr_encoding: Annotated[Optional[StrictBool], Field(description="Optional. Whether to enable Audio Encoding.")] = None,
        break_on_non_key_frames: Annotated[Optional[StrictBool], Field(description="Optional. Whether to break on non key frames.")] = None,
        enable_redirection: Annotated[Optional[StrictBool], Field(description="Whether to enable redirection. Defaults to true.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets an audio stream.


        :param item_id: The item id. (required)
        :type item_id: str
        :param container: Optional. The audio container.
        :type container: List[str]
        :param media_source_id: The media version id, if playing an alternate version.
        :type media_source_id: str
        :param device_id: The device id of the client requesting. Used to stop encoding processes when needed.
        :type device_id: str
        :param user_id: Optional. The user id.
        :type user_id: str
        :param audio_codec: Optional. The audio codec to transcode to.
        :type audio_codec: str
        :param max_audio_channels: Optional. The maximum number of audio channels.
        :type max_audio_channels: int
        :param transcoding_audio_channels: Optional. The number of how many audio channels to transcode to.
        :type transcoding_audio_channels: int
        :param max_streaming_bitrate: Optional. The maximum streaming bitrate.
        :type max_streaming_bitrate: int
        :param audio_bit_rate: Optional. Specify an audio bitrate to encode to, e.g. 128000. If omitted this will be left to encoder defaults.
        :type audio_bit_rate: int
        :param start_time_ticks: Optional. Specify a starting offset, in ticks. 1 tick = 10000 ms.
        :type start_time_ticks: int
        :param transcoding_container: Optional. The container to transcode to.
        :type transcoding_container: str
        :param transcoding_protocol: Optional. The transcoding protocol.
        :type transcoding_protocol: MediaStreamProtocol
        :param max_audio_sample_rate: Optional. The maximum audio sample rate.
        :type max_audio_sample_rate: int
        :param max_audio_bit_depth: Optional. The maximum audio bit depth.
        :type max_audio_bit_depth: int
        :param enable_remote_media: Optional. Whether to enable remote media.
        :type enable_remote_media: bool
        :param enable_audio_vbr_encoding: Optional. Whether to enable Audio Encoding.
        :type enable_audio_vbr_encoding: bool
        :param break_on_non_key_frames: Optional. Whether to break on non key frames.
        :type break_on_non_key_frames: bool
        :param enable_redirection: Whether to enable redirection. Defaults to true.
        :type enable_redirection: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._head_universal_audio_stream_serialize(
            item_id=item_id,
            container=container,
            media_source_id=media_source_id,
            device_id=device_id,
            user_id=user_id,
            audio_codec=audio_codec,
            max_audio_channels=max_audio_channels,
            transcoding_audio_channels=transcoding_audio_channels,
            max_streaming_bitrate=max_streaming_bitrate,
            audio_bit_rate=audio_bit_rate,
            start_time_ticks=start_time_ticks,
            transcoding_container=transcoding_container,
            transcoding_protocol=transcoding_protocol,
            max_audio_sample_rate=max_audio_sample_rate,
            max_audio_bit_depth=max_audio_bit_depth,
            enable_remote_media=enable_remote_media,
            enable_audio_vbr_encoding=enable_audio_vbr_encoding,
            break_on_non_key_frames=break_on_non_key_frames,
            enable_redirection=enable_redirection,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '302': None,
            '404': "ProblemDetails",
            '503': None,
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _head_universal_audio_stream_serialize(
        self,
        item_id,
        container,
        media_source_id,
        device_id,
        user_id,
        audio_codec,
        max_audio_channels,
        transcoding_audio_channels,
        max_streaming_bitrate,
        audio_bit_rate,
        start_time_ticks,
        transcoding_container,
        transcoding_protocol,
        max_audio_sample_rate,
        max_audio_bit_depth,
        enable_remote_media,
        enable_audio_vbr_encoding,
        break_on_non_key_frames,
        enable_redirection,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'container': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if item_id is not None:
            _path_params['itemId'] = item_id
        # process the query parameters
        if container is not None:
            
            _query_params.append(('container', container))
            
        if media_source_id is not None:
            
            _query_params.append(('mediaSourceId', media_source_id))
            
        if device_id is not None:
            
            _query_params.append(('deviceId', device_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if audio_codec is not None:
            
            _query_params.append(('audioCodec', audio_codec))
            
        if max_audio_channels is not None:
            
            _query_params.append(('maxAudioChannels', max_audio_channels))
            
        if transcoding_audio_channels is not None:
            
            _query_params.append(('transcodingAudioChannels', transcoding_audio_channels))
            
        if max_streaming_bitrate is not None:
            
            _query_params.append(('maxStreamingBitrate', max_streaming_bitrate))
            
        if audio_bit_rate is not None:
            
            _query_params.append(('audioBitRate', audio_bit_rate))
            
        if start_time_ticks is not None:
            
            _query_params.append(('startTimeTicks', start_time_ticks))
            
        if transcoding_container is not None:
            
            _query_params.append(('transcodingContainer', transcoding_container))
            
        if transcoding_protocol is not None:
            
            _query_params.append(('transcodingProtocol', transcoding_protocol.value))
            
        if max_audio_sample_rate is not None:
            
            _query_params.append(('maxAudioSampleRate', max_audio_sample_rate))
            
        if max_audio_bit_depth is not None:
            
            _query_params.append(('maxAudioBitDepth', max_audio_bit_depth))
            
        if enable_remote_media is not None:
            
            _query_params.append(('enableRemoteMedia', enable_remote_media))
            
        if enable_audio_vbr_encoding is not None:
            
            _query_params.append(('enableAudioVbrEncoding', enable_audio_vbr_encoding))
            
        if break_on_non_key_frames is not None:
            
            _query_params.append(('breakOnNonKeyFrames', break_on_non_key_frames))
            
        if enable_redirection is not None:
            
            _query_params.append(('enableRedirection', enable_redirection))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'audio/*', 
                    'application/json', 
                    'application/json; profile="CamelCase"', 
                    'application/json; profile="PascalCase"', 
                    'text/html'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'CustomAuthentication'
        ]

        return self.api_client.param_serialize(
            method='HEAD',
            resource_path='/Audio/{itemId}/universal',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


