# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.base_item_person_image_blur_hashes import BaseItemPersonImageBlurHashes
from jellyfin.generated.api_10_11.models.person_kind import PersonKind
from typing import Optional, Set
from typing_extensions import Self

class BaseItemPerson(BaseModel):
    """
    This is used by the api to get information about a Person within a BaseItem.
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    id: Optional[UUID] = Field(default=None, description="Gets or sets the identifier.", alias="Id")
    role: Optional[StrictStr] = Field(default=None, description="Gets or sets the role.", alias="Role")
    type: Optional[PersonKind] = Field(default=PersonKind.UNKNOWN, description="The person kind.", alias="Type")
    primary_image_tag: Optional[StrictStr] = Field(default=None, description="Gets or sets the primary image tag.", alias="PrimaryImageTag")
    image_blur_hashes: Optional[BaseItemPersonImageBlurHashes] = Field(default=None, alias="ImageBlurHashes")
    __properties: ClassVar[List[str]] = ["Name", "Id", "Role", "Type", "PrimaryImageTag", "ImageBlurHashes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseItemPerson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_blur_hashes
        if self.image_blur_hashes:
            _dict['ImageBlurHashes'] = self.image_blur_hashes.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['Name'] = None

        # set to None if role (nullable) is None
        # and model_fields_set contains the field
        if self.role is None and "role" in self.model_fields_set:
            _dict['Role'] = None

        # set to None if primary_image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.primary_image_tag is None and "primary_image_tag" in self.model_fields_set:
            _dict['PrimaryImageTag'] = None

        # set to None if image_blur_hashes (nullable) is None
        # and model_fields_set contains the field
        if self.image_blur_hashes is None and "image_blur_hashes" in self.model_fields_set:
            _dict['ImageBlurHashes'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseItemPerson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Id": obj.get("Id"),
            "Role": obj.get("Role"),
            "Type": obj.get("Type") if obj.get("Type") is not None else PersonKind.UNKNOWN,
            "PrimaryImageTag": obj.get("PrimaryImageTag"),
            "ImageBlurHashes": BaseItemPersonImageBlurHashes.from_dict(obj["ImageBlurHashes"]) if obj.get("ImageBlurHashes") is not None else None
        })
        return _obj


