# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.channel_item_sort_field import ChannelItemSortField
from jellyfin.generated.api_10_11.models.channel_media_content_type import ChannelMediaContentType
from jellyfin.generated.api_10_11.models.channel_media_type import ChannelMediaType
from typing import Optional, Set
from typing_extensions import Self

class ChannelFeatures(BaseModel):
    """
    ChannelFeatures
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Gets or sets the name.", alias="Name")
    id: Optional[UUID] = Field(default=None, description="Gets or sets the identifier.", alias="Id")
    can_search: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance can search.", alias="CanSearch")
    media_types: Optional[List[ChannelMediaType]] = Field(default=None, description="Gets or sets the media types.", alias="MediaTypes")
    content_types: Optional[List[ChannelMediaContentType]] = Field(default=None, description="Gets or sets the content types.", alias="ContentTypes")
    max_page_size: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum number of records the channel allows retrieving at a time.", alias="MaxPageSize")
    auto_refresh_levels: Optional[StrictInt] = Field(default=None, description="Gets or sets the automatic refresh levels.", alias="AutoRefreshLevels")
    default_sort_fields: Optional[List[ChannelItemSortField]] = Field(default=None, description="Gets or sets the default sort orders.", alias="DefaultSortFields")
    supports_sort_order_toggle: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether a sort ascending/descending toggle is supported.", alias="SupportsSortOrderToggle")
    supports_latest_media: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [supports latest media].", alias="SupportsLatestMedia")
    can_filter: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether this instance can filter.", alias="CanFilter")
    supports_content_downloading: Optional[StrictBool] = Field(default=None, description="Gets or sets a value indicating whether [supports content downloading].", alias="SupportsContentDownloading")
    __properties: ClassVar[List[str]] = ["Name", "Id", "CanSearch", "MediaTypes", "ContentTypes", "MaxPageSize", "AutoRefreshLevels", "DefaultSortFields", "SupportsSortOrderToggle", "SupportsLatestMedia", "CanFilter", "SupportsContentDownloading"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChannelFeatures from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if max_page_size (nullable) is None
        # and model_fields_set contains the field
        if self.max_page_size is None and "max_page_size" in self.model_fields_set:
            _dict['MaxPageSize'] = None

        # set to None if auto_refresh_levels (nullable) is None
        # and model_fields_set contains the field
        if self.auto_refresh_levels is None and "auto_refresh_levels" in self.model_fields_set:
            _dict['AutoRefreshLevels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChannelFeatures from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Name": obj.get("Name"),
            "Id": obj.get("Id"),
            "CanSearch": obj.get("CanSearch"),
            "MediaTypes": obj.get("MediaTypes"),
            "ContentTypes": obj.get("ContentTypes"),
            "MaxPageSize": obj.get("MaxPageSize"),
            "AutoRefreshLevels": obj.get("AutoRefreshLevels"),
            "DefaultSortFields": obj.get("DefaultSortFields"),
            "SupportsSortOrderToggle": obj.get("SupportsSortOrderToggle"),
            "SupportsLatestMedia": obj.get("SupportsLatestMedia"),
            "CanFilter": obj.get("CanFilter"),
            "SupportsContentDownloading": obj.get("SupportsContentDownloading")
        })
        return _obj


