# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.codec_type import CodecType
from jellyfin.generated.api_10_11.models.profile_condition import ProfileCondition
from typing import Optional, Set
from typing_extensions import Self

class CodecProfile(BaseModel):
    """
    Defines the MediaBrowser.Model.Dlna.CodecProfile.
    """ # noqa: E501
    type: Optional[CodecType] = Field(default=None, description="Gets or sets the MediaBrowser.Model.Dlna.CodecType which this container must meet.", alias="Type")
    conditions: Optional[List[ProfileCondition]] = Field(default=None, description="Gets or sets the list of MediaBrowser.Model.Dlna.ProfileCondition which this profile must meet.", alias="Conditions")
    apply_conditions: Optional[List[ProfileCondition]] = Field(default=None, description="Gets or sets the list of MediaBrowser.Model.Dlna.ProfileCondition to apply if this profile is met.", alias="ApplyConditions")
    codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the codec(s) that this profile applies to.", alias="Codec")
    container: Optional[StrictStr] = Field(default=None, description="Gets or sets the container(s) which this profile will be applied to.", alias="Container")
    sub_container: Optional[StrictStr] = Field(default=None, description="Gets or sets the sub-container(s) which this profile will be applied to.", alias="SubContainer")
    __properties: ClassVar[List[str]] = ["Type", "Conditions", "ApplyConditions", "Codec", "Container", "SubContainer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CodecProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['Conditions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in apply_conditions (list)
        _items = []
        if self.apply_conditions:
            for _item_apply_conditions in self.apply_conditions:
                if _item_apply_conditions:
                    _items.append(_item_apply_conditions.to_dict())
            _dict['ApplyConditions'] = _items
        # set to None if codec (nullable) is None
        # and model_fields_set contains the field
        if self.codec is None and "codec" in self.model_fields_set:
            _dict['Codec'] = None

        # set to None if container (nullable) is None
        # and model_fields_set contains the field
        if self.container is None and "container" in self.model_fields_set:
            _dict['Container'] = None

        # set to None if sub_container (nullable) is None
        # and model_fields_set contains the field
        if self.sub_container is None and "sub_container" in self.model_fields_set:
            _dict['SubContainer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CodecProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "Conditions": [ProfileCondition.from_dict(_item) for _item in obj["Conditions"]] if obj.get("Conditions") is not None else None,
            "ApplyConditions": [ProfileCondition.from_dict(_item) for _item in obj["ApplyConditions"]] if obj.get("ApplyConditions") is not None else None,
            "Codec": obj.get("Codec"),
            "Container": obj.get("Container"),
            "SubContainer": obj.get("SubContainer")
        })
        return _obj


