# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.custom_database_option import CustomDatabaseOption
from typing import Optional, Set
from typing_extensions import Self

class CustomDatabaseOptions(BaseModel):
    """
    Defines the options for a custom database connector.
    """ # noqa: E501
    plugin_name: Optional[StrictStr] = Field(default=None, description="Gets or sets the Plugin name to search for database providers.", alias="PluginName")
    plugin_assembly: Optional[StrictStr] = Field(default=None, description="Gets or sets the plugin assembly to search for providers.", alias="PluginAssembly")
    connection_string: Optional[StrictStr] = Field(default=None, description="Gets or sets the connection string for the custom database provider.", alias="ConnectionString")
    options: Optional[List[CustomDatabaseOption]] = Field(default=None, description="Gets or sets the list of extra options for the custom provider.", alias="Options")
    __properties: ClassVar[List[str]] = ["PluginName", "PluginAssembly", "ConnectionString", "Options"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomDatabaseOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in options (list)
        _items = []
        if self.options:
            for _item_options in self.options:
                if _item_options:
                    _items.append(_item_options.to_dict())
            _dict['Options'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomDatabaseOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "PluginName": obj.get("PluginName"),
            "PluginAssembly": obj.get("PluginAssembly"),
            "ConnectionString": obj.get("ConnectionString"),
            "Options": [CustomDatabaseOption.from_dict(_item) for _item in obj["Options"]] if obj.get("Options") is not None else None
        })
        return _obj


