# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.dlna_profile_type import DlnaProfileType
from typing import Optional, Set
from typing_extensions import Self

class DirectPlayProfile(BaseModel):
    """
    Defines the MediaBrowser.Model.Dlna.DirectPlayProfile.
    """ # noqa: E501
    container: Optional[StrictStr] = Field(default=None, description="Gets or sets the container.", alias="Container")
    audio_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the audio codec.", alias="AudioCodec")
    video_codec: Optional[StrictStr] = Field(default=None, description="Gets or sets the video codec.", alias="VideoCodec")
    type: Optional[DlnaProfileType] = Field(default=None, description="Gets or sets the Dlna profile type.", alias="Type")
    __properties: ClassVar[List[str]] = ["Container", "AudioCodec", "VideoCodec", "Type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DirectPlayProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if audio_codec (nullable) is None
        # and model_fields_set contains the field
        if self.audio_codec is None and "audio_codec" in self.model_fields_set:
            _dict['AudioCodec'] = None

        # set to None if video_codec (nullable) is None
        # and model_fields_set contains the field
        if self.video_codec is None and "video_codec" in self.model_fields_set:
            _dict['VideoCodec'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DirectPlayProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Container": obj.get("Container"),
            "AudioCodec": obj.get("AudioCodec"),
            "VideoCodec": obj.get("VideoCodec"),
            "Type": obj.get("Type")
        })
        return _obj


