# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class FolderStorageDto(BaseModel):
    """
    Contains information about a specific folder.
    """ # noqa: E501
    path: Optional[StrictStr] = Field(default=None, description="Gets the path of the folder in question.", alias="Path")
    free_space: Optional[StrictInt] = Field(default=None, description="Gets the free space of the underlying storage device of the Jellyfin.Api.Models.SystemInfoDtos.FolderStorageDto.Path.", alias="FreeSpace")
    used_space: Optional[StrictInt] = Field(default=None, description="Gets the used space of the underlying storage device of the Jellyfin.Api.Models.SystemInfoDtos.FolderStorageDto.Path.", alias="UsedSpace")
    storage_type: Optional[StrictStr] = Field(default=None, description="Gets the kind of storage device of the Jellyfin.Api.Models.SystemInfoDtos.FolderStorageDto.Path.", alias="StorageType")
    device_id: Optional[StrictStr] = Field(default=None, description="Gets the Device Identifier.", alias="DeviceId")
    __properties: ClassVar[List[str]] = ["Path", "FreeSpace", "UsedSpace", "StorageType", "DeviceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FolderStorageDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['StorageType'] = None

        # set to None if device_id (nullable) is None
        # and model_fields_set contains the field
        if self.device_id is None and "device_id" in self.model_fields_set:
            _dict['DeviceId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FolderStorageDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Path": obj.get("Path"),
            "FreeSpace": obj.get("FreeSpace"),
            "UsedSpace": obj.get("UsedSpace"),
            "StorageType": obj.get("StorageType"),
            "DeviceId": obj.get("DeviceId")
        })
        return _obj


