# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from jellyfin.generated.api_10_11.models.image_type import ImageType
from jellyfin.generated.api_10_11.models.item_fields import ItemFields
from jellyfin.generated.api_10_11.models.item_sort_by import ItemSortBy
from jellyfin.generated.api_10_11.models.sort_order import SortOrder
from typing import Optional, Set
from typing_extensions import Self

class GetProgramsDto(BaseModel):
    """
    Get programs dto.
    """ # noqa: E501
    channel_ids: Optional[List[UUID]] = Field(default=None, description="Gets or sets the channels to return guide information for.", alias="ChannelIds")
    user_id: Optional[UUID] = Field(default=None, description="Gets or sets optional. Filter by user id.", alias="UserId")
    min_start_date: Optional[datetime] = Field(default=None, description="Gets or sets the minimum premiere start date.", alias="MinStartDate")
    has_aired: Optional[StrictBool] = Field(default=None, description="Gets or sets filter by programs that have completed airing, or not.", alias="HasAired")
    is_airing: Optional[StrictBool] = Field(default=None, description="Gets or sets filter by programs that are currently airing, or not.", alias="IsAiring")
    max_start_date: Optional[datetime] = Field(default=None, description="Gets or sets the maximum premiere start date.", alias="MaxStartDate")
    min_end_date: Optional[datetime] = Field(default=None, description="Gets or sets the minimum premiere end date.", alias="MinEndDate")
    max_end_date: Optional[datetime] = Field(default=None, description="Gets or sets the maximum premiere end date.", alias="MaxEndDate")
    is_movie: Optional[StrictBool] = Field(default=None, description="Gets or sets filter for movies.", alias="IsMovie")
    is_series: Optional[StrictBool] = Field(default=None, description="Gets or sets filter for series.", alias="IsSeries")
    is_news: Optional[StrictBool] = Field(default=None, description="Gets or sets filter for news.", alias="IsNews")
    is_kids: Optional[StrictBool] = Field(default=None, description="Gets or sets filter for kids.", alias="IsKids")
    is_sports: Optional[StrictBool] = Field(default=None, description="Gets or sets filter for sports.", alias="IsSports")
    start_index: Optional[StrictInt] = Field(default=None, description="Gets or sets the record index to start at. All items with a lower index will be dropped from the results.", alias="StartIndex")
    limit: Optional[StrictInt] = Field(default=None, description="Gets or sets the maximum number of records to return.", alias="Limit")
    sort_by: Optional[List[ItemSortBy]] = Field(default=None, description="Gets or sets specify one or more sort orders, comma delimited. Options: Name, StartDate.", alias="SortBy")
    sort_order: Optional[List[SortOrder]] = Field(default=None, description="Gets or sets sort order.", alias="SortOrder")
    genres: Optional[List[StrictStr]] = Field(default=None, description="Gets or sets the genres to return guide information for.", alias="Genres")
    genre_ids: Optional[List[UUID]] = Field(default=None, description="Gets or sets the genre ids to return guide information for.", alias="GenreIds")
    enable_images: Optional[StrictBool] = Field(default=None, description="Gets or sets include image information in output.", alias="EnableImages")
    enable_total_record_count: Optional[StrictBool] = Field(default=True, description="Gets or sets a value indicating whether retrieve total record count.", alias="EnableTotalRecordCount")
    image_type_limit: Optional[StrictInt] = Field(default=None, description="Gets or sets the max number of images to return, per image type.", alias="ImageTypeLimit")
    enable_image_types: Optional[List[ImageType]] = Field(default=None, description="Gets or sets the image types to include in the output.", alias="EnableImageTypes")
    enable_user_data: Optional[StrictBool] = Field(default=None, description="Gets or sets include user data.", alias="EnableUserData")
    series_timer_id: Optional[StrictStr] = Field(default=None, description="Gets or sets filter by series timer id.", alias="SeriesTimerId")
    library_series_id: Optional[UUID] = Field(default=None, description="Gets or sets filter by library series id.", alias="LibrarySeriesId")
    fields: Optional[List[ItemFields]] = Field(default=None, description="Gets or sets specify additional fields of information to return in the output.", alias="Fields")
    __properties: ClassVar[List[str]] = ["ChannelIds", "UserId", "MinStartDate", "HasAired", "IsAiring", "MaxStartDate", "MinEndDate", "MaxEndDate", "IsMovie", "IsSeries", "IsNews", "IsKids", "IsSports", "StartIndex", "Limit", "SortBy", "SortOrder", "Genres", "GenreIds", "EnableImages", "EnableTotalRecordCount", "ImageTypeLimit", "EnableImageTypes", "EnableUserData", "SeriesTimerId", "LibrarySeriesId", "Fields"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetProgramsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if channel_ids (nullable) is None
        # and model_fields_set contains the field
        if self.channel_ids is None and "channel_ids" in self.model_fields_set:
            _dict['ChannelIds'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['UserId'] = None

        # set to None if min_start_date (nullable) is None
        # and model_fields_set contains the field
        if self.min_start_date is None and "min_start_date" in self.model_fields_set:
            _dict['MinStartDate'] = None

        # set to None if has_aired (nullable) is None
        # and model_fields_set contains the field
        if self.has_aired is None and "has_aired" in self.model_fields_set:
            _dict['HasAired'] = None

        # set to None if is_airing (nullable) is None
        # and model_fields_set contains the field
        if self.is_airing is None and "is_airing" in self.model_fields_set:
            _dict['IsAiring'] = None

        # set to None if max_start_date (nullable) is None
        # and model_fields_set contains the field
        if self.max_start_date is None and "max_start_date" in self.model_fields_set:
            _dict['MaxStartDate'] = None

        # set to None if min_end_date (nullable) is None
        # and model_fields_set contains the field
        if self.min_end_date is None and "min_end_date" in self.model_fields_set:
            _dict['MinEndDate'] = None

        # set to None if max_end_date (nullable) is None
        # and model_fields_set contains the field
        if self.max_end_date is None and "max_end_date" in self.model_fields_set:
            _dict['MaxEndDate'] = None

        # set to None if is_movie (nullable) is None
        # and model_fields_set contains the field
        if self.is_movie is None and "is_movie" in self.model_fields_set:
            _dict['IsMovie'] = None

        # set to None if is_series (nullable) is None
        # and model_fields_set contains the field
        if self.is_series is None and "is_series" in self.model_fields_set:
            _dict['IsSeries'] = None

        # set to None if is_news (nullable) is None
        # and model_fields_set contains the field
        if self.is_news is None and "is_news" in self.model_fields_set:
            _dict['IsNews'] = None

        # set to None if is_kids (nullable) is None
        # and model_fields_set contains the field
        if self.is_kids is None and "is_kids" in self.model_fields_set:
            _dict['IsKids'] = None

        # set to None if is_sports (nullable) is None
        # and model_fields_set contains the field
        if self.is_sports is None and "is_sports" in self.model_fields_set:
            _dict['IsSports'] = None

        # set to None if start_index (nullable) is None
        # and model_fields_set contains the field
        if self.start_index is None and "start_index" in self.model_fields_set:
            _dict['StartIndex'] = None

        # set to None if limit (nullable) is None
        # and model_fields_set contains the field
        if self.limit is None and "limit" in self.model_fields_set:
            _dict['Limit'] = None

        # set to None if sort_by (nullable) is None
        # and model_fields_set contains the field
        if self.sort_by is None and "sort_by" in self.model_fields_set:
            _dict['SortBy'] = None

        # set to None if sort_order (nullable) is None
        # and model_fields_set contains the field
        if self.sort_order is None and "sort_order" in self.model_fields_set:
            _dict['SortOrder'] = None

        # set to None if genres (nullable) is None
        # and model_fields_set contains the field
        if self.genres is None and "genres" in self.model_fields_set:
            _dict['Genres'] = None

        # set to None if genre_ids (nullable) is None
        # and model_fields_set contains the field
        if self.genre_ids is None and "genre_ids" in self.model_fields_set:
            _dict['GenreIds'] = None

        # set to None if enable_images (nullable) is None
        # and model_fields_set contains the field
        if self.enable_images is None and "enable_images" in self.model_fields_set:
            _dict['EnableImages'] = None

        # set to None if image_type_limit (nullable) is None
        # and model_fields_set contains the field
        if self.image_type_limit is None and "image_type_limit" in self.model_fields_set:
            _dict['ImageTypeLimit'] = None

        # set to None if enable_image_types (nullable) is None
        # and model_fields_set contains the field
        if self.enable_image_types is None and "enable_image_types" in self.model_fields_set:
            _dict['EnableImageTypes'] = None

        # set to None if enable_user_data (nullable) is None
        # and model_fields_set contains the field
        if self.enable_user_data is None and "enable_user_data" in self.model_fields_set:
            _dict['EnableUserData'] = None

        # set to None if series_timer_id (nullable) is None
        # and model_fields_set contains the field
        if self.series_timer_id is None and "series_timer_id" in self.model_fields_set:
            _dict['SeriesTimerId'] = None

        # set to None if library_series_id (nullable) is None
        # and model_fields_set contains the field
        if self.library_series_id is None and "library_series_id" in self.model_fields_set:
            _dict['LibrarySeriesId'] = None

        # set to None if fields (nullable) is None
        # and model_fields_set contains the field
        if self.fields is None and "fields" in self.model_fields_set:
            _dict['Fields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetProgramsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ChannelIds": obj.get("ChannelIds"),
            "UserId": obj.get("UserId"),
            "MinStartDate": obj.get("MinStartDate"),
            "HasAired": obj.get("HasAired"),
            "IsAiring": obj.get("IsAiring"),
            "MaxStartDate": obj.get("MaxStartDate"),
            "MinEndDate": obj.get("MinEndDate"),
            "MaxEndDate": obj.get("MaxEndDate"),
            "IsMovie": obj.get("IsMovie"),
            "IsSeries": obj.get("IsSeries"),
            "IsNews": obj.get("IsNews"),
            "IsKids": obj.get("IsKids"),
            "IsSports": obj.get("IsSports"),
            "StartIndex": obj.get("StartIndex"),
            "Limit": obj.get("Limit"),
            "SortBy": obj.get("SortBy"),
            "SortOrder": obj.get("SortOrder"),
            "Genres": obj.get("Genres"),
            "GenreIds": obj.get("GenreIds"),
            "EnableImages": obj.get("EnableImages"),
            "EnableTotalRecordCount": obj.get("EnableTotalRecordCount") if obj.get("EnableTotalRecordCount") is not None else True,
            "ImageTypeLimit": obj.get("ImageTypeLimit"),
            "EnableImageTypes": obj.get("EnableImageTypes"),
            "EnableUserData": obj.get("EnableUserData"),
            "SeriesTimerId": obj.get("SeriesTimerId"),
            "LibrarySeriesId": obj.get("LibrarySeriesId"),
            "Fields": obj.get("Fields")
        })
        return _obj


