# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from jellyfin.generated.api_10_11.models.activity_log_entry_start_message import ActivityLogEntryStartMessage
from jellyfin.generated.api_10_11.models.activity_log_entry_stop_message import ActivityLogEntryStopMessage
from jellyfin.generated.api_10_11.models.inbound_keep_alive_message import InboundKeepAliveMessage
from jellyfin.generated.api_10_11.models.scheduled_tasks_info_start_message import ScheduledTasksInfoStartMessage
from jellyfin.generated.api_10_11.models.scheduled_tasks_info_stop_message import ScheduledTasksInfoStopMessage
from jellyfin.generated.api_10_11.models.sessions_start_message import SessionsStartMessage
from jellyfin.generated.api_10_11.models.sessions_stop_message import SessionsStopMessage
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

INBOUNDWEBSOCKETMESSAGE_ONE_OF_SCHEMAS = ["ActivityLogEntryStartMessage", "ActivityLogEntryStopMessage", "InboundKeepAliveMessage", "ScheduledTasksInfoStartMessage", "ScheduledTasksInfoStopMessage", "SessionsStartMessage", "SessionsStopMessage"]

class InboundWebSocketMessage(BaseModel):
    """
    Represents the list of possible inbound websocket types
    """
    # data type: ActivityLogEntryStartMessage
    oneof_schema_1_validator: Optional[ActivityLogEntryStartMessage] = None
    # data type: ActivityLogEntryStopMessage
    oneof_schema_2_validator: Optional[ActivityLogEntryStopMessage] = None
    # data type: InboundKeepAliveMessage
    oneof_schema_3_validator: Optional[InboundKeepAliveMessage] = None
    # data type: ScheduledTasksInfoStartMessage
    oneof_schema_4_validator: Optional[ScheduledTasksInfoStartMessage] = None
    # data type: ScheduledTasksInfoStopMessage
    oneof_schema_5_validator: Optional[ScheduledTasksInfoStopMessage] = None
    # data type: SessionsStartMessage
    oneof_schema_6_validator: Optional[SessionsStartMessage] = None
    # data type: SessionsStopMessage
    oneof_schema_7_validator: Optional[SessionsStopMessage] = None
    actual_instance: Optional[Union[ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage]] = None
    one_of_schemas: Set[str] = { "ActivityLogEntryStartMessage", "ActivityLogEntryStopMessage", "InboundKeepAliveMessage", "ScheduledTasksInfoStartMessage", "ScheduledTasksInfoStopMessage", "SessionsStartMessage", "SessionsStopMessage" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = InboundWebSocketMessage.model_construct()
        error_messages = []
        match = 0
        # validate data type: ActivityLogEntryStartMessage
        if not isinstance(v, ActivityLogEntryStartMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ActivityLogEntryStartMessage`")
        else:
            match += 1
        # validate data type: ActivityLogEntryStopMessage
        if not isinstance(v, ActivityLogEntryStopMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ActivityLogEntryStopMessage`")
        else:
            match += 1
        # validate data type: InboundKeepAliveMessage
        if not isinstance(v, InboundKeepAliveMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InboundKeepAliveMessage`")
        else:
            match += 1
        # validate data type: ScheduledTasksInfoStartMessage
        if not isinstance(v, ScheduledTasksInfoStartMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ScheduledTasksInfoStartMessage`")
        else:
            match += 1
        # validate data type: ScheduledTasksInfoStopMessage
        if not isinstance(v, ScheduledTasksInfoStopMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ScheduledTasksInfoStopMessage`")
        else:
            match += 1
        # validate data type: SessionsStartMessage
        if not isinstance(v, SessionsStartMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SessionsStartMessage`")
        else:
            match += 1
        # validate data type: SessionsStopMessage
        if not isinstance(v, SessionsStopMessage):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SessionsStopMessage`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in InboundWebSocketMessage with oneOf schemas: ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in InboundWebSocketMessage with oneOf schemas: ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ActivityLogEntryStartMessage
        try:
            instance.actual_instance = ActivityLogEntryStartMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ActivityLogEntryStopMessage
        try:
            instance.actual_instance = ActivityLogEntryStopMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into InboundKeepAliveMessage
        try:
            instance.actual_instance = InboundKeepAliveMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ScheduledTasksInfoStartMessage
        try:
            instance.actual_instance = ScheduledTasksInfoStartMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ScheduledTasksInfoStopMessage
        try:
            instance.actual_instance = ScheduledTasksInfoStopMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SessionsStartMessage
        try:
            instance.actual_instance = SessionsStartMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SessionsStopMessage
        try:
            instance.actual_instance = SessionsStopMessage.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into InboundWebSocketMessage with oneOf schemas: ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into InboundWebSocketMessage with oneOf schemas: ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ActivityLogEntryStartMessage, ActivityLogEntryStopMessage, InboundKeepAliveMessage, ScheduledTasksInfoStartMessage, ScheduledTasksInfoStopMessage, SessionsStartMessage, SessionsStopMessage]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


