# coding: utf-8

"""
    Jellyfin API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 10.11.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from jellyfin.generated.api_10_11.models.image_option import ImageOption
from jellyfin.generated.api_10_11.models.image_type import ImageType
from jellyfin.generated.api_10_11.models.library_option_info_dto import LibraryOptionInfoDto
from typing import Optional, Set
from typing_extensions import Self

class LibraryTypeOptionsDto(BaseModel):
    """
    Library type options dto.
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="Gets or sets the type.", alias="Type")
    metadata_fetchers: Optional[List[LibraryOptionInfoDto]] = Field(default=None, description="Gets or sets the metadata fetchers.", alias="MetadataFetchers")
    image_fetchers: Optional[List[LibraryOptionInfoDto]] = Field(default=None, description="Gets or sets the image fetchers.", alias="ImageFetchers")
    supported_image_types: Optional[List[ImageType]] = Field(default=None, description="Gets or sets the supported image types.", alias="SupportedImageTypes")
    default_image_options: Optional[List[ImageOption]] = Field(default=None, description="Gets or sets the default image options.", alias="DefaultImageOptions")
    __properties: ClassVar[List[str]] = ["Type", "MetadataFetchers", "ImageFetchers", "SupportedImageTypes", "DefaultImageOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LibraryTypeOptionsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metadata_fetchers (list)
        _items = []
        if self.metadata_fetchers:
            for _item_metadata_fetchers in self.metadata_fetchers:
                if _item_metadata_fetchers:
                    _items.append(_item_metadata_fetchers.to_dict())
            _dict['MetadataFetchers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in image_fetchers (list)
        _items = []
        if self.image_fetchers:
            for _item_image_fetchers in self.image_fetchers:
                if _item_image_fetchers:
                    _items.append(_item_image_fetchers.to_dict())
            _dict['ImageFetchers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in default_image_options (list)
        _items = []
        if self.default_image_options:
            for _item_default_image_options in self.default_image_options:
                if _item_default_image_options:
                    _items.append(_item_default_image_options.to_dict())
            _dict['DefaultImageOptions'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['Type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LibraryTypeOptionsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "MetadataFetchers": [LibraryOptionInfoDto.from_dict(_item) for _item in obj["MetadataFetchers"]] if obj.get("MetadataFetchers") is not None else None,
            "ImageFetchers": [LibraryOptionInfoDto.from_dict(_item) for _item in obj["ImageFetchers"]] if obj.get("ImageFetchers") is not None else None,
            "SupportedImageTypes": obj.get("SupportedImageTypes"),
            "DefaultImageOptions": [ImageOption.from_dict(_item) for _item in obj["DefaultImageOptions"]] if obj.get("DefaultImageOptions") is not None else None
        })
        return _obj


